/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.CommonBundle;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.options.newEditor.OptionsEditor;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import java.awt.AWTEvent;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionsEditorDialog
extends DialogWrapper
implements DataProvider {
    private Project myProject;
    private ConfigurableGroup[] myGroups;
    private Configurable myPreselected;
    private OptionsEditor myEditor;
    private ApplyAction myApplyAction;
    public static final String DIMENSION_KEY = "OptionsEditor";
    @NonNls
    static final String LAST_SELECTED_CONFIGURABLE = "options.lastSelected";

    public OptionsEditorDialog(Project project, ConfigurableGroup[] groups, @Nullable Configurable preselectedConfigurable, boolean applicationModalIfPossible) {
        super(project, true, applicationModalIfPossible);
        this.init(project, groups, preselectedConfigurable != null ? preselectedConfigurable : OptionsEditorDialog.findLastSavedConfigurable(groups, project));
    }

    public OptionsEditorDialog(Project project, ConfigurableGroup[] groups, @NotNull String preselectedConfigurableDisplayName, boolean applicationModalIfPossible) {
        if (preselectedConfigurableDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preselectedConfigurableDisplayName", "com/intellij/openapi/options/newEditor/OptionsEditorDialog", "<init>"));
        }
        super(project, true, applicationModalIfPossible);
        this.init(project, groups, OptionsEditorDialog.getPreselectedByDisplayName(groups, preselectedConfigurableDisplayName, project));
    }

    public OptionsEditorDialog(Project project, ConfigurableGroup[] groups, @Nullable Configurable preselectedConfigurable) {
        super(project, true);
        this.init(project, groups, preselectedConfigurable != null ? preselectedConfigurable : OptionsEditorDialog.findLastSavedConfigurable(groups, project));
    }

    public OptionsEditorDialog(Project project, ConfigurableGroup[] groups, @NotNull String preselectedConfigurableDisplayName) {
        if (preselectedConfigurableDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preselectedConfigurableDisplayName", "com/intellij/openapi/options/newEditor/OptionsEditorDialog", "<init>"));
        }
        super(project, true);
        this.init(project, groups, OptionsEditorDialog.getPreselectedByDisplayName(groups, preselectedConfigurableDisplayName, project));
    }

    private void init(Project project, ConfigurableGroup[] groups, @Nullable Configurable preselected) {
        this.myProject = project;
        this.myGroups = groups;
        this.myPreselected = preselected;
        this.setTitle(CommonBundle.settingsTitle());
        this.init();
    }

    @Nullable
    private static Configurable getPreselectedByDisplayName(ConfigurableGroup[] groups, String preselectedConfigurableDisplayName, Project project) {
        Configurable result2 = OptionsEditorDialog.findPreselectedByDisplayName(preselectedConfigurableDisplayName, groups);
        return result2 == null ? OptionsEditorDialog.findLastSavedConfigurable(groups, project) : result2;
    }

    public boolean isTypeAheadEnabled() {
        return true;
    }

    protected JComponent createCenterPanel() {
        this.myEditor = new OptionsEditor(this.myProject, this.myGroups, this.myPreselected);
        this.myEditor.getContext().addColleague(new OptionsEditorColleague.Adapter(){

            @Override
            public ActionCallback onModifiedAdded(Configurable configurable) {
                OptionsEditorDialog.this.updateStatus();
                return ActionCallback.DONE;
            }

            @Override
            public ActionCallback onModifiedRemoved(Configurable configurable) {
                OptionsEditorDialog.this.updateStatus();
                return ActionCallback.DONE;
            }

            @Override
            public ActionCallback onErrorsChanged() {
                OptionsEditorDialog.this.updateStatus();
                return ActionCallback.DONE;
            }
        });
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myEditor);
        return this.myEditor;
    }

    public boolean updateStatus() {
        this.myApplyAction.setEnabled(this.myEditor.canApply());
        Map<Configurable, ConfigurationException> errors = this.myEditor.getContext().getErrors();
        if (errors.size() == 0) {
            this.setErrorText(null);
        } else {
            String text = "Changes were not applied because of an error";
            String errorMessage = OptionsEditorDialog.getErrorMessage(errors);
            if (errorMessage != null) {
                text = text + "<br>" + errorMessage;
            }
            this.setErrorText(text);
        }
        return errors.size() == 0;
    }

    @Nullable
    private static String getErrorMessage(Map<Configurable, ConfigurationException> errors) {
        Collection<ConfigurationException> values = errors.values();
        ConfigurationException[] exceptions = values.toArray(new ConfigurationException[values.size()]);
        if (exceptions.length > 0) {
            return exceptions[0].getMessage();
        }
        return null;
    }

    protected String getDimensionServiceKey() {
        return DIMENSION_KEY;
    }

    protected void doOKAction() {
        this.myEditor.flushModifications();
        DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (OptionsEditorDialog.this.myEditor.canApply()) {
                    OptionsEditorDialog.this.myEditor.apply();
                    if (!OptionsEditorDialog.this.updateStatus()) {
                        return;
                    }
                }
                OptionsEditorDialog.this.saveCurrentConfigurable();
                ApplicationManager.getApplication().saveAll();
                OptionsEditorDialog.super.doOKAction();
            }
        });
    }

    private void saveCurrentConfigurable() {
        Configurable current = this.myEditor.getContext().getCurrentConfigurable();
        if (current == null) {
            return;
        }
        PropertiesComponent props = PropertiesComponent.getInstance((Project)this.myProject);
        if (current instanceof SearchableConfigurable) {
            props.setValue(LAST_SELECTED_CONFIGURABLE, ((SearchableConfigurable)current).getId());
        } else {
            props.setValue(LAST_SELECTED_CONFIGURABLE, current.getClass().getName());
        }
    }

    @Nullable
    private static Configurable findLastSavedConfigurable(ConfigurableGroup[] groups, Project project) {
        String id = PropertiesComponent.getInstance((Project)project).getValue(LAST_SELECTED_CONFIGURABLE);
        if (id == null) {
            return null;
        }
        return OptionsEditorDialog.findConfigurableInGroups(id, (Configurable.Composite[])groups);
    }

    @Nullable
    private static Configurable findConfigurableInGroups(String id, Configurable.Composite ... groups) {
        Configurable[] configurables;
        for (Configurable.Composite group : groups) {
            for (Configurable c : configurables = group.getConfigurables()) {
                if (c instanceof SearchableConfigurable && id.equals(((SearchableConfigurable)c).getId())) {
                    return c;
                }
                if (!id.equals(c.getClass().getName())) continue;
                return c;
            }
        }
        for (Configurable.Composite group : groups) {
            for (Configurable c : configurables = group.getConfigurables()) {
                Configurable result2;
                if (!(c instanceof Configurable.Composite) || (result2 = OptionsEditorDialog.findConfigurableInGroups(id, (Configurable.Composite)c)) == null) continue;
                return result2;
            }
        }
        return null;
    }

    @Nullable
    private static Configurable findPreselectedByDisplayName(String preselectedConfigurableDisplayName, ConfigurableGroup[] groups) {
        List<Configurable> all = SearchUtil.expand(groups);
        for (Configurable each : all) {
            if (!preselectedConfigurableDisplayName.equals(each.getDisplayName())) continue;
            return each;
        }
        return null;
    }

    public void doCancelAction(AWTEvent source) {
        if ((source instanceof KeyEvent || source instanceof ActionEvent) && this.myEditor.getContext().isHoldingFilter()) {
            this.myEditor.clearFilter();
            return;
        }
        super.doCancelAction(source);
    }

    public void doCancelAction() {
        this.saveCurrentConfigurable();
        super.doCancelAction();
    }

    @NotNull
    protected Action[] createActions() {
        this.myApplyAction = new ApplyAction();
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.myApplyAction, this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/newEditor/OptionsEditorDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        String topic = this.myEditor.getHelpTopic();
        if (topic != null) {
            HelpManager.getInstance().invokeHelp(topic);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getPreferredFocusedComponent();
    }

    public Object getData(@NonNls String dataId) {
        if (Settings.KEY.is(dataId)) {
            return this.myEditor.mySettings;
        }
        if (OptionsEditor.KEY.is(dataId)) {
            return this.myEditor;
        }
        return null;
    }

    private class ApplyAction
    extends AbstractAction {
        public ApplyAction() {
            super(CommonBundle.getApplyButtonText());
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionsEditorDialog.this.myEditor.apply();
                }
            });
            OptionsEditorDialog.this.myEditor.revalidate();
            OptionsEditorDialog.this.myEditor.repaint();
        }
    }
}

