/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.roots.JavaProjectModelModifier;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.pom.java.LanguageLevel;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public class JavaProjectModelModificationServiceImpl
extends JavaProjectModelModificationService {
    private final Project myProject;

    public JavaProjectModelModificationServiceImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public Promise<Void> addDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/roots/impl/JavaProjectModelModificationServiceImpl", "addDependency"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/openapi/roots/impl/JavaProjectModelModificationServiceImpl", "addDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/impl/JavaProjectModelModificationServiceImpl", "addDependency"));
        }
        for (JavaProjectModelModifier modifier : this.getModelModifiers()) {
            Promise<Void> promise2 = modifier.addModuleDependency(from, to, scope);
            if (promise2 == null) continue;
            return promise2;
        }
        return Promise.REJECTED;
    }

    @Override
    public Promise<Void> addDependency(@NotNull Collection<Module> from, @NotNull ExternalLibraryDescriptor libraryDescriptor, @NotNull DependencyScope scope) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/roots/impl/JavaProjectModelModificationServiceImpl", "addDependency"));
        }
        if (libraryDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDescriptor", "com/intellij/openapi/roots/impl/JavaProjectModelModificationServiceImpl", "addDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/impl/JavaProjectModelModificationServiceImpl", "addDependency"));
        }
        for (JavaProjectModelModifier modifier : this.getModelModifiers()) {
            Promise<Void> promise2 = modifier.addExternalLibraryDependency(from, libraryDescriptor, scope);
            if (promise2 == null) continue;
            return promise2;
        }
        return Promise.REJECTED;
    }

    @Override
    public Promise<Void> addDependency(@NotNull Module from, @NotNull Library library, @NotNull DependencyScope scope) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/roots/impl/JavaProjectModelModificationServiceImpl", "addDependency"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/JavaProjectModelModificationServiceImpl", "addDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/impl/JavaProjectModelModificationServiceImpl", "addDependency"));
        }
        for (JavaProjectModelModifier modifier : this.getModelModifiers()) {
            Promise<Void> promise2 = modifier.addLibraryDependency(from, library, scope);
            if (promise2 == null) continue;
            return promise2;
        }
        return Promise.REJECTED;
    }

    @Override
    public Promise<Void> changeLanguageLevel(@NotNull Module module, @NotNull LanguageLevel languageLevel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/impl/JavaProjectModelModificationServiceImpl", "changeLanguageLevel"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/openapi/roots/impl/JavaProjectModelModificationServiceImpl", "changeLanguageLevel"));
        }
        for (JavaProjectModelModifier modifier : this.getModelModifiers()) {
            Promise<Void> promise2 = modifier.changeLanguageLevel(module, languageLevel);
            if (promise2 == null) continue;
            return promise2;
        }
        return Promise.REJECTED;
    }

    @NotNull
    private JavaProjectModelModifier[] getModelModifiers() {
        JavaProjectModelModifier[] javaProjectModelModifierArray = (JavaProjectModelModifier[])JavaProjectModelModifier.EP_NAME.getExtensions((AreaInstance)this.myProject);
        if (javaProjectModelModifierArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/JavaProjectModelModificationServiceImpl", "getModelModifiers"));
        }
        return javaProjectModelModifierArray;
    }
}

