/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleOrderEnumerator
extends OrderEnumeratorBase {
    private final ModuleRootModel myRootModel;

    public ModuleOrderEnumerator(ModuleRootModel rootModel, OrderRootsCache cache) {
        super(rootModel.getModule(), rootModel.getModule().getProject(), cache);
        this.myRootModel = rootModel;
    }

    @Override
    public void processRootModules(@NotNull Processor<Module> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/roots/impl/ModuleOrderEnumerator", "processRootModules"));
        }
        processor2.process((Object)this.myRootModel.getModule());
    }

    public void forEach(@NotNull Processor<OrderEntry> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/roots/impl/ModuleOrderEnumerator", "forEach"));
        }
        this.processEntries(this.myRootModel, processor2, (Set<Module>)(this.myRecursively ? new THashSet() : null), true);
    }

    @Override
    public boolean isRootModuleModel(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/ModuleOrderEnumerator", "isRootModuleModel"));
        }
        return rootModel.equals(this.myRootModel);
    }
}

