/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui.impl;

import com.intellij.openapi.roots.libraries.LibraryRootType;
import com.intellij.openapi.roots.libraries.ui.DetectedLibraryRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class SuggestedChildRootInfo {
    private final VirtualFile myRootCandidate;
    private final DetectedLibraryRoot myDetectedRoot;
    private final Map<LibraryRootType, String> myRootTypeNames;
    private LibraryRootType mySelectedRootType;

    SuggestedChildRootInfo(@NotNull VirtualFile rootCandidate, @NotNull DetectedLibraryRoot detectedRoot, @NotNull Map<LibraryRootType, String> rootTypeNames) {
        if (rootCandidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCandidate", "com/intellij/openapi/roots/libraries/ui/impl/SuggestedChildRootInfo", "<init>"));
        }
        if (detectedRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detectedRoot", "com/intellij/openapi/roots/libraries/ui/impl/SuggestedChildRootInfo", "<init>"));
        }
        if (rootTypeNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTypeNames", "com/intellij/openapi/roots/libraries/ui/impl/SuggestedChildRootInfo", "<init>"));
        }
        this.myRootCandidate = rootCandidate;
        this.myDetectedRoot = detectedRoot;
        this.myRootTypeNames = rootTypeNames;
        this.mySelectedRootType = detectedRoot.getTypes().get(0);
    }

    @NotNull
    public VirtualFile getRootCandidate() {
        VirtualFile virtualFile = this.myRootCandidate;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/libraries/ui/impl/SuggestedChildRootInfo", "getRootCandidate"));
        }
        return virtualFile;
    }

    @NotNull
    public DetectedLibraryRoot getDetectedRoot() {
        DetectedLibraryRoot detectedLibraryRoot = this.myDetectedRoot;
        if (detectedLibraryRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/libraries/ui/impl/SuggestedChildRootInfo", "getDetectedRoot"));
        }
        return detectedLibraryRoot;
    }

    public String getRootTypeName(LibraryRootType type) {
        return this.myRootTypeNames.get(type);
    }

    @NotNull
    public LibraryRootType getSelectedRootType() {
        LibraryRootType libraryRootType = this.mySelectedRootType;
        if (libraryRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/libraries/ui/impl/SuggestedChildRootInfo", "getSelectedRootType"));
        }
        return libraryRootType;
    }

    public void setSelectedRootType(String selectedRootType) {
        for (LibraryRootType type : this.myDetectedRoot.getTypes()) {
            if (!this.getRootTypeName(type).equals(selectedRootType)) continue;
            this.mySelectedRootType = type;
            break;
        }
    }

    @NotNull
    public String[] getRootTypeNames() {
        String[] types = ArrayUtil.toStringArray(this.myRootTypeNames.values());
        Arrays.sort(types, String.CASE_INSENSITIVE_ORDER);
        if (types == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/libraries/ui/impl/SuggestedChildRootInfo", "getRootTypeNames"));
        }
        return types;
    }
}

