/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public abstract class LanguageLevelCombo
extends ComboBox {
    private final String myDefaultItem;

    public LanguageLevelCombo(String defaultItem) {
        this.myDefaultItem = defaultItem;
        for (LanguageLevel level : LanguageLevel.values()) {
            this.addItem(level);
        }
        this.setRenderer((ListCellRenderer)new ColoredListCellRendererWrapper(){

            protected void doCustomize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof LanguageLevel) {
                    this.append(((LanguageLevel)value).getPresentableText());
                } else if (value instanceof String) {
                    this.append((String)value);
                    LanguageLevel defaultLevel = LanguageLevelCombo.this.getDefaultLevel();
                    if (defaultLevel != null) {
                        this.append(" (" + defaultLevel.getPresentableText() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            }
        });
    }

    public void reset(Project project) {
        this.removeAllItems();
        for (LanguageLevel level : LanguageLevel.values()) {
            this.addItem(level);
        }
        Sdk sdk = ProjectRootManagerEx.getInstanceEx((Project)project).getProjectSdk();
        this.sdkUpdated(sdk);
        LanguageLevelProjectExtension extension = LanguageLevelProjectExtension.getInstance((Project)project);
        if (this.getDefaultLevel() != null && extension.isDefault()) {
            this.setSelectedItem(this.myDefaultItem);
        } else {
            this.setSelectedItem(extension.getLanguageLevel());
        }
    }

    protected abstract LanguageLevel getDefaultLevel();

    void sdkUpdated(Sdk sdk) {
        JavaSdkVersion version;
        LanguageLevel newLevel = null;
        if (sdk != null && (version = JavaSdk.getInstance().getVersion(sdk)) != null) {
            newLevel = version.getMaxLanguageLevel();
        }
        this.updateDefaultLevel(newLevel);
    }

    void updateDefaultLevel(LanguageLevel newLevel) {
        if (newLevel == null) {
            if (this.getSelectedItem() == this.myDefaultItem) {
                this.setSelectedItem(this.getDefaultLevel());
            }
            this.removeItem(this.myDefaultItem);
        } else if (!(this.getItemAt(0) instanceof String)) {
            this.addDefaultItem();
        }
        this.repaint();
    }

    void addDefaultItem() {
        this.insertItemAt(this.myDefaultItem, 0);
    }

    public LanguageLevel getSelectedLevel() {
        Object item = this.getSelectedItem();
        return item instanceof LanguageLevel ? (LanguageLevel)item : this.getDefaultLevel();
    }

    public boolean isDefault() {
        return !(this.getSelectedItem() instanceof LanguageLevel);
    }

    public void setSelectedItem(Object anObject) {
        super.setSelectedItem(anObject == null ? this.myDefaultItem : anObject);
    }
}

