/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.actions;

import com.intellij.CommonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactTypeCellRenderer;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeComponent;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.IExtractArtifactDialog;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.impl.artifacts.PlainArtifactType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ExtractArtifactDialog
extends DialogWrapper
implements IExtractArtifactDialog {
    private JPanel myMainPanel;
    private JTextField myNameField;
    private JComboBox myTypeBox;
    private final ArtifactEditorContext myContext;

    public ExtractArtifactDialog(ArtifactEditorContext context, LayoutTreeComponent treeComponent, String initialName) {
        super((Component)((Object)treeComponent.getLayoutTree()), true);
        this.myContext = context;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(ProjectBundle.message((String)"dialog.title.extract.artifact", (Object[])objectArray));
        for (ArtifactType type : ArtifactType.getAllTypes()) {
            this.myTypeBox.addItem(type);
        }
        this.myTypeBox.setSelectedItem((Object)PlainArtifactType.getInstance());
        this.myTypeBox.setRenderer(new ArtifactTypeCellRenderer(this.myTypeBox.getRenderer()));
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ExtractArtifactDialog.this.setOKActionEnabled(!StringUtil.isEmptyOrSpaces((String)ExtractArtifactDialog.this.getArtifactName()));
            }
        });
        this.myNameField.setText(initialName);
        this.init();
    }

    protected void doOKAction() {
        String artifactName = this.getArtifactName();
        if (this.myContext.getArtifactModel().findArtifact(artifactName) != null) {
            Messages.showErrorDialog((Project)this.myContext.getProject(), (String)("Artifact '" + artifactName + "' already exists!"), (String)CommonBundle.getErrorTitle());
            return;
        }
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Override
    public String getArtifactName() {
        return this.myNameField.getText();
    }

    @Override
    public ArtifactType getArtifactType() {
        return (ArtifactType)this.myTypeBox.getSelectedItem();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JTextField jTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ProjectBundle").getString("label.text.specify.artifact.name"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Select artifact type:");
        jLabel2.setDisplayedMnemonic('T');
        jLabel2.setDisplayedMnemonicIndex(16);
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTypeBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(3, 0, 1, 1, 8, 0, 2, 0, null, null, null, 1));
        jLabel.setLabelFor(jTextField);
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

