/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.util.Comparing;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.SourceItemPresentation;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModuleGroupItem
extends PackagingSourceItem {
    private final String myGroupName;
    private final String[] myPath;

    public ModuleGroupItem(String[] path) {
        super(false);
        this.myGroupName = path[path.length - 1];
        this.myPath = path;
    }

    public boolean equals(Object obj) {
        return obj instanceof ModuleGroupItem && Comparing.equal((Object[])this.myPath, (Object[])((ModuleGroupItem)((Object)obj)).myPath);
    }

    public int hashCode() {
        return Arrays.hashCode(this.myPath);
    }

    public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleGroupItem", "createPresentation"));
        }
        return new ModuleGroupSourceItemPresentation(this.myGroupName);
    }

    @NotNull
    public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleGroupItem", "createElements"));
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleGroupItem", "createElements"));
        }
        return list;
    }

    public String[] getPath() {
        return this.myPath;
    }

    private static class ModuleGroupSourceItemPresentation
    extends SourceItemPresentation {
        private final String myGroupName;

        public ModuleGroupSourceItemPresentation(String groupName) {
            this.myGroupName = groupName;
        }

        public String getPresentableName() {
            return this.myGroupName;
        }

        public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
            if (presentationData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationData", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleGroupItem$ModuleGroupSourceItemPresentation", "render"));
            }
            presentationData.setIcon(PlatformIcons.CLOSED_MODULE_GROUP_ICON);
            presentationData.addText(this.myGroupName, mainAttributes);
        }

        public int getWeight() {
            return 100;
        }
    }
}

