/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.ex;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessagesEx
extends Messages {
    public static MessageInfo fileIsReadOnly(Project project, String filePath) {
        return MessagesEx.error(project, UIBundle.message((String)"file.is.read.only.message.text", (Object[])new Object[]{filePath}));
    }

    public static MessageInfo filesAreReadOnly(Project project, String[] files) {
        if (files.length == 1) {
            return MessagesEx.fileIsReadOnly(project, files[0]);
        }
        return MessagesEx.error(project, UIBundle.message((String)"files.are.read.only.message.text", (Object[])new Object[]{MessagesEx.filePaths(files)}));
    }

    private static String filePaths(String[] files) {
        return StringUtil.join((String[])files, (String)",\n");
    }

    public static MessageInfo fileIsReadOnly(Project project, VirtualFile file) {
        return MessagesEx.fileIsReadOnly(project, file.getPresentableUrl());
    }

    public static MessageInfo error(Project project, String message) {
        return MessagesEx.error(project, message, UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]));
    }

    @NotNull
    public static MessageInfo error(Project project, String message, String title) {
        MessageInfo messageInfo = new MessageInfo(project, message, title);
        if (messageInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/ex/MessagesEx", "error"));
        }
        return messageInfo;
    }

    public static void showErrorDialog(@Nullable Component parent, String message, @NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/ex/MessagesEx", "showErrorDialog"));
        }
        if (parent != null) {
            Messages.showErrorDialog((Component)parent, (String)message, (String)title);
        } else {
            MessagesEx.showErrorDialog((String)message, (String)title);
        }
    }

    public static void showWarningDialog(@Nullable Component parent, String message, @NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/ex/MessagesEx", "showWarningDialog"));
        }
        if (parent != null) {
            Messages.showWarningDialog((Component)parent, (String)message, (String)title);
        } else {
            MessagesEx.showWarningDialog((String)message, (String)title);
        }
    }

    public static void showInfoMessage(@Nullable Component parent, String message, @NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/ex/MessagesEx", "showInfoMessage"));
        }
        if (parent != null) {
            Messages.showInfoMessage((Component)parent, (String)message, (String)title);
        } else {
            MessagesEx.showInfoMessage((String)message, (String)title);
        }
    }

    public static int showOkCancelDialog(@Nullable Component parent, String message, String title, Icon icon) {
        return parent != null ? Messages.showOkCancelDialog((Component)parent, (String)message, (String)title, (Icon)icon) : MessagesEx.showOkCancelDialog((String)message, (String)title, (Icon)icon);
    }

    public static abstract class BaseInputInfo<ThisClass extends BaseInputInfo>
    extends BaseDialogInfo<ThisClass> {
        public BaseInputInfo(Project project) {
            super(project);
        }

        public String forceUserInput() {
            this.setOptions(new String[]{CommonBundle.getOkButtonText()}, 0);
            return this.askUser().getInput();
        }

        public abstract UserInput askUser();
    }

    public static class InputInfo
    extends BaseInputInfo<InputInfo> {
        private String myDefaultValue;

        public InputInfo(Project project) {
            super(project);
            this.setOptions(new String[]{CommonBundle.getOkButtonText(), CommonBundle.getCancelButtonText()}, 0);
        }

        @Override
        public UserInput askUser() {
            Messages.InputDialog dialog = new Messages.InputDialog(this.getProject(), this.getMessage(), this.getTitle(), this.getIcon(), this.myDefaultValue, null, this.getOptions(), this.getDefaultOption());
            dialog.show();
            return new UserInput(dialog.getTextField().getText(), dialog.getExitCode());
        }

        @Override
        @NotNull
        public InputInfo getThis() {
            InputInfo inputInfo = this;
            if (inputInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/ex/MessagesEx$InputInfo", "getThis"));
            }
            return inputInfo;
        }

        public void setDefaultValue(String defaultValue) {
            this.myDefaultValue = defaultValue;
        }
    }

    public static class UserInput {
        private final int mySelectedOption;
        private final String myInput;

        public UserInput(String choice, int option) {
            this.mySelectedOption = option;
            this.myInput = choice;
        }

        public String getInput() {
            return this.myInput;
        }

        public int getSelectedOption() {
            return this.mySelectedOption;
        }
    }

    public static class ChoiceInfo
    extends BaseInputInfo<ChoiceInfo> {
        private String[] myChoises = ArrayUtil.EMPTY_STRING_ARRAY;
        private String myDefaultChoice = null;

        public ChoiceInfo(Project project) {
            super(project);
            this.setIcon(Messages.getQuestionIcon());
            this.setOptions(new String[]{CommonBundle.getOkButtonText()}, 0);
        }

        @Override
        @NotNull
        public ChoiceInfo getThis() {
            ChoiceInfo choiceInfo = this;
            if (choiceInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/ex/MessagesEx$ChoiceInfo", "getThis"));
            }
            return choiceInfo;
        }

        public ChoiceInfo setChoices(String[] choices, String defaultChoice) {
            this.myChoises = choices;
            this.myDefaultChoice = defaultChoice;
            return this.getThis();
        }

        @Override
        public UserInput askUser() {
            Messages.ChooseDialog dialog = new Messages.ChooseDialog(this.getProject(), this.getMessage(), this.getTitle(), this.getIcon(), this.myChoises, this.myDefaultChoice, this.getOptions(), this.getDefaultOption());
            dialog.setValidator(null);
            JComboBox comboBox = dialog.getComboBox();
            comboBox.setEditable(false);
            comboBox.setSelectedItem(this.myDefaultChoice);
            dialog.show();
            Object selectedItem = comboBox.getSelectedItem();
            return new UserInput(selectedItem != null ? selectedItem.toString() : null, dialog.getExitCode());
        }
    }

    public static class MessageInfo
    extends BaseDialogInfo<MessageInfo> {
        public MessageInfo(Project project, String message, String title) {
            super(project, message, title, Messages.getErrorIcon());
        }

        public int showNow() {
            return Messages.showDialog((Project)this.getProject(), (String)this.getMessage(), (String)this.getTitle(), (String[])this.getOptions(), (int)this.getDefaultOption(), (Icon)this.getIcon());
        }

        public void showLater() {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageInfo.this.showNow();
                }
            }, ApplicationManager.getApplication().getDisposed());
        }

        @Messages.YesNoResult
        public int askYesNo() {
            this.setIcon(Messages.getQuestionIcon());
            return Messages.showYesNoDialog((Project)this.getProject(), (String)this.getMessage(), (String)this.getTitle(), (Icon)this.getIcon());
        }

        public int ask(String[] options, int defaultOptionIndex) {
            this.setOptions(options, defaultOptionIndex);
            return this.showNow();
        }

        @Override
        @NotNull
        protected MessageInfo getThis() {
            MessageInfo messageInfo = this;
            if (messageInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/ex/MessagesEx$MessageInfo", "getThis"));
            }
            return messageInfo;
        }
    }

    public static abstract class BaseDialogInfo<ThisClass extends BaseDialogInfo> {
        private final Project myProject;
        private String myMessage;
        private String myTitle;
        private Icon myIcon;
        private String[] myOptions;
        private int myDefaultOption;

        protected BaseDialogInfo(Project project) {
            this.myOptions = new String[]{CommonBundle.getOkButtonText()};
            this.myDefaultOption = 0;
            this.myProject = project;
        }

        public BaseDialogInfo(Project project, @NotNull String message, String title, Icon icon) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/ui/ex/MessagesEx$BaseDialogInfo", "<init>"));
            }
            this(project);
            this.myMessage = message;
            this.myTitle = title;
            this.myIcon = icon;
        }

        @NotNull
        public ThisClass setTitle(String title) {
            this.myTitle = title;
            ThisClass ThisClass = this.getThis();
            if (ThisClass == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/ex/MessagesEx$BaseDialogInfo", "setTitle"));
            }
            return ThisClass;
        }

        public String getMessage() {
            return this.myMessage;
        }

        @NotNull
        public ThisClass appendMessage(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/ui/ex/MessagesEx$BaseDialogInfo", "appendMessage"));
            }
            this.myMessage = this.myMessage + message;
            ThisClass ThisClass = this.getThis();
            if (ThisClass == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/ex/MessagesEx$BaseDialogInfo", "appendMessage"));
            }
            return ThisClass;
        }

        public void setOptions(String[] options, int defaultOption) {
            this.myOptions = options;
            this.myDefaultOption = defaultOption;
        }

        @NotNull
        protected abstract ThisClass getThis();

        @NotNull
        public ThisClass setIcon(Icon icon) {
            this.myIcon = icon;
            ThisClass ThisClass = this.getThis();
            if (ThisClass == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/ex/MessagesEx$BaseDialogInfo", "setIcon"));
            }
            return ThisClass;
        }

        public void setMessage(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/ui/ex/MessagesEx$BaseDialogInfo", "setMessage"));
            }
            this.myMessage = message;
        }

        public Project getProject() {
            return this.myProject;
        }

        public String getTitle() {
            return this.myTitle;
        }

        public String[] getOptions() {
            return this.myOptions;
        }

        public int getDefaultOption() {
            return this.myDefaultOption;
        }

        public Icon getIcon() {
            return this.myIcon;
        }
    }
}

