/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffRequestFactory;
import com.intellij.openapi.diff.MergeRequest;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.actions.ChangeDiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.DiffChainContext;
import com.intellij.openapi.vcs.changes.actions.DiffExtendUIFactory;
import com.intellij.openapi.vcs.changes.actions.DiffPresentationReturnValue;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;

public class ConflictedDiffRequestPresentable
implements DiffRequestPresentable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.actions.ConflictedDiffRequestPresentable");
    private final Project myProject;
    private final VirtualFile myFile;
    private final Change myChange;

    public ConflictedDiffRequestPresentable(Project project, VirtualFile file, Change change) {
        this.myProject = project;
        this.myFile = file;
        this.myChange = change;
    }

    public DiffRequestPresentable.MyResult step(DiffChainContext context) {
        boolean nowItIsText;
        FileType type;
        if (this.myChange.getAfterRevision() == null) {
            return this.createErrorResult();
        }
        FileType fileType = type = this.myChange.getVirtualFile() != null ? this.myChange.getVirtualFile().getFileType() : null;
        if (this.myFile.getFileType().isBinary() && !(nowItIsText = ChangeDiffRequestPresentable.checkAssociate(this.myProject, this.myFile.getName(), context))) {
            return this.createErrorResult();
        }
        AbstractVcs vcs = ChangesUtil.getVcsForChange((Change)this.myChange, (Project)this.myProject);
        if (vcs == null || vcs.getMergeProvider() == null) {
            return this.createErrorResult();
        }
        try {
            MergeData mergeData = vcs.getMergeProvider().loadRevisions(this.myFile);
            Charset charset = this.myFile.getCharset();
            MergeRequest request = DiffRequestFactory.getInstance().create3WayDiffRequest(CharsetToolkit.bytesToString((byte[])mergeData.CURRENT, (Charset)charset), CharsetToolkit.bytesToString((byte[])mergeData.LAST, (Charset)charset), CharsetToolkit.bytesToString((byte[])mergeData.ORIGINAL, (Charset)charset), type, this.myProject, null, null);
            request.setWindowTitle(FileUtil.toSystemDependentName((String)this.myFile.getPresentableUrl()));
            VcsRevisionNumber lastRevisionNumber = mergeData.LAST_REVISION_NUMBER;
            request.setVersionTitles(new String[]{this.myChange.getAfterRevision().getRevisionNumber().asString(), "Base Version", lastRevisionNumber != null ? lastRevisionNumber.asString() : ""});
            return new DiffRequestPresentable.MyResult((DiffRequest)request, DiffPresentationReturnValue.useRequest);
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            return this.createErrorResult();
        }
    }

    private DiffRequestPresentable.MyResult createErrorResult() {
        SimpleDiffRequest request = new SimpleDiffRequest(this.myProject, null);
        return new DiffRequestPresentable.MyResult((DiffRequest)request, DiffPresentationReturnValue.removeFromList);
    }

    public void haveStuff() throws VcsException {
    }

    public List<? extends AnAction> createActions(DiffExtendUIFactory uiFactory) {
        return Collections.emptyList();
    }

    public String getPathPresentation() {
        return this.myFile.getPath();
    }
}

