/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.vfs.ContentRevisionVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;

public class OpenRepositoryVersionAction
extends AnAction
implements DumbAware {
    public OpenRepositoryVersionAction() {
        super(VcsBundle.message((String)"open.repository.version.text", (Object[])new Object[0]), VcsBundle.message((String)"open.repository.version.description", (Object[])new Object[0]), AllIcons.ObjectBrowser.ShowEditorHighlighting);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Change[] changes = (Change[])e.getData(VcsDataKeys.SELECTED_CHANGES);
        assert (changes != null);
        for (Change change : changes) {
            ContentRevision revision = change.getAfterRevision();
            if (revision == null || revision.getFile().isDirectory()) continue;
            ContentRevisionVirtualFile vFile = ContentRevisionVirtualFile.create((ContentRevision)revision);
            OpenFileDescriptor navigatable = new OpenFileDescriptor(project, (VirtualFile)vFile);
            navigatable.navigate(true);
        }
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Change[] changes = (Change[])e.getData(VcsDataKeys.SELECTED_CHANGES);
        e.getPresentation().setEnabled(project != null && changes != null && !CommittedChangesBrowserUseCase.IN_AIR.equals(CommittedChangesBrowserUseCase.DATA_KEY.getData(e.getDataContext())) && OpenRepositoryVersionAction.hasValidChanges(changes) && ModalityState.NON_MODAL.equals(ModalityState.current()));
    }

    private static boolean hasValidChanges(Change[] changes) {
        for (Change c : changes) {
            ContentRevision contentRevision = c.getAfterRevision();
            if (contentRevision == null || contentRevision.getFile().isDirectory()) continue;
            return true;
        }
        return false;
    }
}

