/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class AdditionalLocalChangeActionsInstaller {
    @Nullable
    public static List<AnAction> calculateActions(Project project, Collection<Change> changes) {
        ProjectLevelVcsManager plVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        HashMap<String, AbstractVcs> map = new HashMap<String, AbstractVcs>();
        for (Change change : changes) {
            AbstractVcs vcs;
            if (change.getAfterRevision() == null || (vcs = plVcsManager.getVcsFor(change.getAfterRevision().getFile())) == null || map.containsKey(vcs.getName())) continue;
            map.put(vcs.getName(), vcs);
        }
        if (map.isEmpty()) {
            return null;
        }
        ArrayList<AnAction> result2 = new ArrayList<AnAction>(1);
        for (AbstractVcs vcs : map.values()) {
            List actions = vcs.getAdditionalActionsForLocalChange();
            if (actions == null) continue;
            result2.addAll(actions);
        }
        return result2;
    }
}

