/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CachedRevisionsContents {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.history.impl.CachedRevisionsContents");
    private final Map<VcsRevisionNumber, String> myCachedContents;
    private final Project myProject;
    private List<VcsFileRevision> myRevisions;
    private final VirtualFile myFile;

    public CachedRevisionsContents(Project project, VirtualFile file) {
        this.myProject = project;
        this.myFile = file;
        this.myCachedContents = Collections.synchronizedMap(new HashMap());
    }

    public void setRevisions(List<VcsFileRevision> revisions) {
        this.myRevisions = revisions;
    }

    public void loadContentsFor(VcsFileRevision[] revisions) throws VcsException {
        VcsFileRevision[] revisionsToLoad = this.revisionsNeededToBeLoaded(revisions);
        final LinkedList<VcsFileRevision> toBeLoaded = new LinkedList<VcsFileRevision>();
        for (VcsFileRevision revision : revisionsToLoad) {
            if (this.myCachedContents.containsKey(revision.getRevisionNumber())) continue;
            toBeLoaded.add(revision);
        }
        if (toBeLoaded.isEmpty()) {
            return;
        }
        final VcsException[] exception = new VcsException[1];
        Runnable process = new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            boolean loaded = ProgressManager.getInstance().runProcessWithProgressSynchronously(process, VcsBundle.message((String)"progress.title.loading.contents", (Object[])new Object[0]), true, this.myProject);
            if (!loaded) {
                throw new VcsException("Load of revision contents canceled");
            }
        } else {
            process.run();
        }
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    public String getContentOf(VcsFileRevision revision) throws VcsException {
        if (!this.myCachedContents.containsKey(revision.getRevisionNumber())) {
            this.loadContentsFor(new VcsFileRevision[]{revision});
        }
        return this.myCachedContents.get(revision.getRevisionNumber());
    }

    private VcsFileRevision[] revisionsNeededToBeLoaded(VcsFileRevision[] revisions) {
        HashSet<VcsFileRevision> result2 = new HashSet<VcsFileRevision>();
        for (VcsFileRevision revision : revisions) {
            result2.addAll(this.collectRevisionsFromFirstTo(revision));
        }
        return result2.toArray(new VcsFileRevision[result2.size()]);
    }

    private Collection<VcsFileRevision> collectRevisionsFromFirstTo(VcsFileRevision revision) {
        ArrayList<VcsFileRevision> result2 = new ArrayList<VcsFileRevision>();
        for (VcsFileRevision vcsFileRevision : this.myRevisions) {
            if (VcsHistoryUtil.compareNumbers(revision, vcsFileRevision) > 0) continue;
            result2.add(vcsFileRevision);
        }
        return result2;
    }

    static /* synthetic */ Map access$000(CachedRevisionsContents x0) {
        return x0.myCachedContents;
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }

    static /* synthetic */ VirtualFile access$200(CachedRevisionsContents x0) {
        return x0.myFile;
    }
}

