/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsRootError;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.roots.VcsRootErrorsFinder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRootProblemNotifier {
    public static final Function<VcsRootError, String> PATH_FROM_ROOT_ERROR = new Function<VcsRootError, String>(){

        public String fun(@NotNull VcsRootError error) {
            if (error == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier$1", "fun"));
            }
            return error.getMapping();
        }
    };
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsConfiguration mySettings;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final Set<String> myReportedUnregisteredRoots;
    @Nullable
    private Notification myNotification;
    @NotNull
    private final Object NOTIFICATION_LOCK;

    public static VcsRootProblemNotifier getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "getInstance"));
        }
        return new VcsRootProblemNotifier(project);
    }

    private VcsRootProblemNotifier(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "<init>"));
        }
        this.NOTIFICATION_LOCK = new Object();
        this.myProject = project;
        this.mySettings = VcsConfiguration.getInstance((Project)this.myProject);
        this.myChangeListManager = ChangeListManager.getInstance((Project)project);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myReportedUnregisteredRoots = new HashSet((Collection)this.mySettings.IGNORED_UNREGISTERED_ROOTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescanAndNotifyIfNeeded() {
        Collection<VcsRootError> errors = this.scan();
        if (errors.isEmpty()) {
            Object object = this.NOTIFICATION_LOCK;
            synchronized (object) {
                this.expireNotification();
            }
            return;
        }
        List<VcsRootError> importantUnregisteredRoots = this.getImportantUnregisteredMappings(errors);
        Collection<VcsRootError> invalidRoots = VcsRootProblemNotifier.getInvalidRoots(errors);
        List unregRootPaths = ContainerUtil.map(importantUnregisteredRoots, PATH_FROM_ROOT_ERROR);
        if (invalidRoots.isEmpty() && (importantUnregisteredRoots.isEmpty() || this.myReportedUnregisteredRoots.containsAll(unregRootPaths))) {
            return;
        }
        this.myReportedUnregisteredRoots.addAll(unregRootPaths);
        String title = VcsRootProblemNotifier.makeTitle(importantUnregisteredRoots, invalidRoots);
        String description = VcsRootProblemNotifier.makeDescription(importantUnregisteredRoots, invalidRoots);
        Object object = this.NOTIFICATION_LOCK;
        synchronized (object) {
            this.expireNotification();
            MyNotificationListener listener = new MyNotificationListener(this.myProject, this.mySettings, this.myVcsManager, importantUnregisteredRoots);
            VcsNotifier notifier = VcsNotifier.getInstance(this.myProject);
            this.myNotification = invalidRoots.isEmpty() ? notifier.notifyMinorInfo(title, description, (NotificationListener)listener) : notifier.notifyError(title, description, (NotificationListener)listener);
        }
    }

    private boolean isUnderOrAboveProjectDir(@NotNull String mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "isUnderOrAboveProjectDir"));
        }
        String projectDir = this.myProject.getBasePath();
        return mapping.equals("<Project>") || FileUtil.isAncestor((String)projectDir, (String)mapping, (boolean)false) || FileUtil.isAncestor((String)mapping, (String)projectDir, (boolean)false);
    }

    private boolean isIgnored(@NotNull String mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "isIgnored"));
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(mapping);
        return file != null && this.myChangeListManager.isIgnoredFile(file);
    }

    private void expireNotification() {
        if (this.myNotification != null) {
            final Notification notification = this.myNotification;
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    notification.expire();
                }
            });
            this.myNotification = null;
        }
    }

    @NotNull
    private Collection<VcsRootError> scan() {
        Collection<VcsRootError> collection = new VcsRootErrorsFinder(this.myProject).find();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "scan"));
        }
        return collection;
    }

    @NotNull
    private static String makeDescription(@NotNull Collection<VcsRootError> unregisteredRoots, @NotNull Collection<VcsRootError> invalidRoots) {
        if (unregisteredRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unregisteredRoots", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "makeDescription"));
        }
        if (invalidRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invalidRoots", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "makeDescription"));
        }
        Function<VcsRootError, String> rootToDisplayableString = new Function<VcsRootError, String>(){

            public String fun(VcsRootError rootError) {
                if (rootError.getMapping().equals("<Project>")) {
                    return StringUtil.escapeXml((String)rootError.getMapping());
                }
                return FileUtil.toSystemDependentName((String)rootError.getMapping());
            }
        };
        StringBuilder description = new StringBuilder();
        if (!invalidRoots.isEmpty()) {
            if (invalidRoots.size() == 1) {
                VcsRootError rootError = invalidRoots.iterator().next();
                String vcsName = rootError.getVcsKey().getName();
                description.append(String.format("The directory %s is registered as a %s root, but no %s repositories were found there.", rootToDisplayableString.fun((Object)rootError), vcsName, vcsName));
            } else {
                description.append("The following directories are registered as VCS roots, but they are not: <br/>" + StringUtil.join(invalidRoots, (Function)rootToDisplayableString, (String)"<br/>"));
            }
            description.append("<br/>");
        }
        if (!unregisteredRoots.isEmpty()) {
            if (unregisteredRoots.size() == 1) {
                VcsRootError unregisteredRoot = unregisteredRoots.iterator().next();
                description.append(String.format("The directory %s is under %s, but is not registered in the Settings.", rootToDisplayableString.fun((Object)unregisteredRoot), unregisteredRoot.getVcsKey().getName()));
            } else {
                description.append("The following directories are roots of VCS repositories, but they are not registered in the Settings: <br/>" + StringUtil.join(unregisteredRoots, (Function)rootToDisplayableString, (String)"<br/>"));
            }
            description.append("<br/>");
        }
        String add = invalidRoots.isEmpty() ? "<a href='add'>Add " + StringUtil.pluralize((String)"root", (int)unregisteredRoots.size()) + "</a>&nbsp;&nbsp;" : "";
        String configure = "<a href='configure'>Configure</a>";
        String ignore = invalidRoots.isEmpty() ? "&nbsp;&nbsp;<a href='ignore'>Ignore</a>" : "";
        description.append(add + configure + ignore);
        String string = description.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "makeDescription"));
        }
        return string;
    }

    @NotNull
    private static String makeTitle(@NotNull Collection<VcsRootError> unregisteredRoots, @NotNull Collection<VcsRootError> invalidRoots) {
        if (unregisteredRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unregisteredRoots", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "makeTitle"));
        }
        if (invalidRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invalidRoots", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "makeTitle"));
        }
        String title = unregisteredRoots.isEmpty() ? "Invalid VCS root " + StringUtil.pluralize((String)"mapping", (int)invalidRoots.size()) : (invalidRoots.isEmpty() ? "Unregistered VCS " + StringUtil.pluralize((String)"root", (int)unregisteredRoots.size()) + " detected" : "VCS root configuration problems");
        String string = title;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "makeTitle"));
        }
        return string;
    }

    @NotNull
    private List<VcsRootError> getImportantUnregisteredMappings(@NotNull Collection<VcsRootError> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "getImportantUnregisteredMappings"));
        }
        List list = ContainerUtil.filter(errors, (Condition)new Condition<VcsRootError>(){

            public boolean value(VcsRootError error) {
                String mapping = error.getMapping();
                return error.getType() == VcsRootError.Type.UNREGISTERED_ROOT && VcsRootProblemNotifier.this.isUnderOrAboveProjectDir(mapping) && !VcsRootProblemNotifier.this.isIgnored(mapping);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "getImportantUnregisteredMappings"));
        }
        return list;
    }

    @NotNull
    private static Collection<VcsRootError> getInvalidRoots(@NotNull Collection<VcsRootError> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "getInvalidRoots"));
        }
        List list = ContainerUtil.filter(errors, (Condition)new Condition<VcsRootError>(){

            public boolean value(VcsRootError error) {
                return error.getType() == VcsRootError.Type.EXTRA_MAPPING;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier", "getInvalidRoots"));
        }
        return list;
    }

    private static class MyNotificationListener
    extends NotificationListener.Adapter {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VcsConfiguration mySettings;
        @NotNull
        private final ProjectLevelVcsManager myVcsManager;
        @NotNull
        private final Collection<VcsRootError> myImportantUnregisteredRoots;

        private MyNotificationListener(@NotNull Project project, @NotNull VcsConfiguration settings, @NotNull ProjectLevelVcsManager vcsManager, @NotNull Collection<VcsRootError> importantUnregisteredRoots) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier$MyNotificationListener", "<init>"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier$MyNotificationListener", "<init>"));
            }
            if (vcsManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsManager", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier$MyNotificationListener", "<init>"));
            }
            if (importantUnregisteredRoots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importantUnregisteredRoots", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier$MyNotificationListener", "<init>"));
            }
            this.myProject = project;
            this.mySettings = settings;
            this.myVcsManager = vcsManager;
            this.myImportantUnregisteredRoots = importantUnregisteredRoots;
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier$MyNotificationListener", "hyperlinkActivated"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier$MyNotificationListener", "hyperlinkActivated"));
            }
            if (event.getDescription().equals("configure") && !this.myProject.isDisposed()) {
                ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, ActionsBundle.message((String)"group.VcsGroup.text", (Object[])new Object[0]));
                Collection errorsAfterPossibleFix = VcsRootProblemNotifier.getInstance(this.myProject).scan();
                if (errorsAfterPossibleFix.isEmpty() && !notification.isExpired()) {
                    notification.expire();
                }
            } else if (event.getDescription().equals("ignore")) {
                this.mySettings.addIgnoredUnregisteredRoots((Collection)ContainerUtil.map(this.myImportantUnregisteredRoots, PATH_FROM_ROOT_ERROR));
                notification.expire();
            } else if (event.getDescription().equals("add")) {
                List mappings = this.myVcsManager.getDirectoryMappings();
                for (VcsRootError root : this.myImportantUnregisteredRoots) {
                    mappings = VcsUtil.addMapping((List)mappings, (String)root.getMapping(), (String)root.getVcsKey().getName());
                }
                this.myVcsManager.setDirectoryMappings(mappings);
            }
        }
    }
}

