/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.VfsImplUtil");
    private static final String FILE_SEPARATORS = "/" + File.separator;
    private static final AtomicBoolean ourSubscribed = new AtomicBoolean(false);
    private static final Object ourLock = new Object();
    private static final Map<String, Pair<ArchiveFileSystem, ArchiveHandler>> ourHandlers = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
    private static final Map<String, Set<String>> ourDominatorsMap = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);

    private VfsImplUtil() {
    }

    @Nullable
    public static NewVirtualFile findFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull @NonNls String path) {
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfs", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "findFileByPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "findFileByPath"));
        }
        Pair<NewVirtualFile, Iterable<String>> data = VfsImplUtil.prepare(vfs, path);
        if (data == null) {
            return null;
        }
        NewVirtualFile file = (NewVirtualFile)data.first;
        for (String pathElement : (Iterable)data.second) {
            NewVirtualFile canonicalFile;
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            file = "..".equals(pathElement) ? (file.is(VFileProperty.SYMLINK) ? ((canonicalFile = file.getCanonicalFile()) != null ? canonicalFile.getParent() : null) : file.getParent()) : file.findChild(pathElement);
            if (file != null) continue;
            return null;
        }
        return file;
    }

    @Nullable
    public static NewVirtualFile findFileByPathIfCached(@NotNull NewVirtualFileSystem vfs, @NotNull @NonNls String path) {
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfs", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "findFileByPathIfCached"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "findFileByPathIfCached"));
        }
        Pair<NewVirtualFile, Iterable<String>> data = VfsImplUtil.prepare(vfs, path);
        if (data == null) {
            return null;
        }
        NewVirtualFile file = (NewVirtualFile)data.first;
        for (String pathElement : (Iterable)data.second) {
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            if ("..".equals(pathElement)) {
                if (file.is(VFileProperty.SYMLINK)) {
                    String canonicalPath = file.getCanonicalPath();
                    NewVirtualFile canonicalFile = canonicalPath != null ? VfsImplUtil.findFileByPathIfCached(vfs, canonicalPath) : null;
                    file = canonicalFile != null ? canonicalFile.getParent() : null;
                } else {
                    file = file.getParent();
                }
            } else {
                file = file.findChildIfCached(pathElement);
            }
            if (file != null) continue;
            return null;
        }
        return file;
    }

    @Nullable
    public static NewVirtualFile refreshAndFindFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull @NonNls String path) {
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfs", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "refreshAndFindFileByPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "refreshAndFindFileByPath"));
        }
        Pair<NewVirtualFile, Iterable<String>> data = VfsImplUtil.prepare(vfs, path);
        if (data == null) {
            return null;
        }
        NewVirtualFile file = (NewVirtualFile)data.first;
        for (String pathElement : (Iterable)data.second) {
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            if ("..".equals(pathElement)) {
                if (file.is(VFileProperty.SYMLINK)) {
                    String canonicalPath = file.getCanonicalPath();
                    NewVirtualFile canonicalFile = canonicalPath != null ? VfsImplUtil.refreshAndFindFileByPath(vfs, canonicalPath) : null;
                    file = canonicalFile != null ? canonicalFile.getParent() : null;
                } else {
                    file = file.getParent();
                }
            } else {
                file = file.refreshAndFindChild(pathElement);
            }
            if (file != null) continue;
            return null;
        }
        return file;
    }

    @Nullable
    private static Pair<NewVirtualFile, Iterable<String>> prepare(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfs", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "prepare"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "prepare"));
        }
        String normalizedPath = VfsImplUtil.normalize(vfs, path);
        if (StringUtil.isEmptyOrSpaces((String)normalizedPath)) {
            return null;
        }
        String basePath = vfs.extractRootPath(normalizedPath);
        if (basePath.length() > normalizedPath.length()) {
            LOG.error(vfs + " failed to extract root path '" + basePath + "' from '" + normalizedPath + "' (original '" + path + "')");
            return null;
        }
        NewVirtualFile root = ManagingFS.getInstance().findRoot(basePath, vfs);
        if (root == null || !root.exists()) {
            return null;
        }
        Iterable parts = StringUtil.tokenize((String)normalizedPath.substring(basePath.length()), (String)FILE_SEPARATORS);
        return Pair.create((Object)root, (Object)parts);
    }

    public static void refresh(@NotNull NewVirtualFileSystem vfs, boolean asynchronous) {
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfs", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "refresh"));
        }
        VirtualFile[] roots = ManagingFS.getInstance().getRoots(vfs);
        if (roots.length > 0) {
            RefreshQueue.getInstance().refresh(asynchronous, true, null, roots);
        }
    }

    @Nullable
    public static String normalize(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfs", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "normalize"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "normalize"));
        }
        return vfs.normalize(path);
    }

    @NotNull
    public static <T extends ArchiveHandler> T getHandler(@NotNull ArchiveFileSystem vfs, @NotNull VirtualFile entryFile, @NotNull Function<String, T> producer) {
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfs", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "getHandler"));
        }
        if (entryFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryFile", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "getHandler"));
        }
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "getHandler"));
        }
        String localPath = vfs.extractLocalPath(vfs.extractRootPath(entryFile.getPath()));
        T t = VfsImplUtil.getHandler(vfs, localPath, producer);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "getHandler"));
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T extends ArchiveHandler> T getHandler(@NotNull ArchiveFileSystem vfs, @NotNull String localPath, @NotNull Function<String, T> producer) {
        ArchiveHandler t;
        ArchiveHandler handler2;
        if (vfs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfs", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "getHandler"));
        }
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "getHandler"));
        }
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "getHandler"));
        }
        VfsImplUtil.checkSubscription();
        Object object = ourLock;
        synchronized (object) {
            Pair record = ourHandlers.get(localPath);
            if (record == null) {
                handler2 = (ArchiveHandler)producer.fun((Object)localPath);
                record = Pair.create((Object)vfs, (Object)handler2);
                ourHandlers.put(localPath, (Pair<ArchiveFileSystem, ArchiveHandler>)record);
                final String finalRootPath = localPath;
                VfsImplUtil.forEachDirectoryComponent(localPath, new Consumer<String>(){

                    public void consume(String containingDirectoryPath) {
                        Set handlers = (Set)ourDominatorsMap.get(containingDirectoryPath);
                        if (handlers == null) {
                            handlers = ContainerUtil.newTroveSet();
                            ourDominatorsMap.put(containingDirectoryPath, handlers);
                        }
                        handlers.add(finalRootPath);
                    }
                });
            }
            handler2 = (ArchiveHandler)record.second;
        }
        ArchiveHandler archiveHandler = t = handler2;
        if (archiveHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/VfsImplUtil", "getHandler"));
        }
        return (T)archiveHandler;
    }

    private static void forEachDirectoryComponent(String rootPath, Consumer<String> consumer) {
        int index = rootPath.lastIndexOf(47);
        while (index > 0) {
            String containingDirectoryPath = rootPath.substring(0, index);
            consumer.consume((Object)containingDirectoryPath);
            index = rootPath.lastIndexOf(47, index - 1);
        }
    }

    private static void checkSubscription() {
        if (ourSubscribed.getAndSet(true)) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        app.getMessageBus().connect((Disposable)app).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/newvfs/VfsImplUtil$2", "after"));
                }
                InvalidationState state = null;
                Object object = ourLock;
                synchronized (object) {
                    for (VFileEvent vFileEvent : events) {
                        if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem) || vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFilePropertyChangeEvent && !"name".equals(((VFilePropertyChangeEvent)vFileEvent).getPropertyName())) continue;
                        String path = vFileEvent.getPath();
                        if (vFileEvent instanceof VFilePropertyChangeEvent) {
                            path = ((VFilePropertyChangeEvent)vFileEvent).getOldPath();
                        } else if (vFileEvent instanceof VFileMoveEvent) {
                            path = ((VFileMoveEvent)vFileEvent).getOldPath();
                        }
                        VirtualFile file = vFileEvent.getFile();
                        if (file == null || !file.isDirectory()) {
                            state = InvalidationState.invalidate(state, path);
                            continue;
                        }
                        Collection affectedPaths = (Collection)ourDominatorsMap.get(path);
                        if (affectedPaths == null) continue;
                        affectedPaths = ContainerUtil.newArrayList((Iterable)affectedPaths);
                        for (String affectedPath : affectedPaths) {
                            state = InvalidationState.invalidate(state, affectedPath);
                        }
                    }
                }
                if (state != null) {
                    state.scheduleRefresh();
                }
            }
        });
    }

    private static class InvalidationState {
        private Set<NewVirtualFile> myRootsToRefresh;

        private InvalidationState() {
        }

        @Nullable
        static InvalidationState invalidate(@Nullable InvalidationState state, final String path) {
            Pair handlerPair = (Pair)ourHandlers.remove(path);
            if (handlerPair != null) {
                ((ArchiveHandler)handlerPair.second).dispose();
                VfsImplUtil.forEachDirectoryComponent(path, (Consumer<String>)((Consumer)new Consumer<String>(){

                    public void consume(String containingDirectoryPath) {
                        Set handlers = (Set)ourDominatorsMap.get(containingDirectoryPath);
                        if (handlers != null && handlers.remove(path) && handlers.isEmpty()) {
                            ourDominatorsMap.remove(containingDirectoryPath);
                        }
                    }
                }));
                if (state == null) {
                    state = new InvalidationState();
                }
                state.registerPathToRefresh(path, (ArchiveFileSystem)handlerPair.first);
            }
            return state;
        }

        private void registerPathToRefresh(String path, ArchiveFileSystem vfs) {
            NewVirtualFile root = ManagingFS.getInstance().findRoot(vfs.composeRootPath(path), (NewVirtualFileSystem)vfs);
            if (root != null) {
                if (this.myRootsToRefresh == null) {
                    this.myRootsToRefresh = ContainerUtil.newHashSet();
                }
                this.myRootsToRefresh.add(root);
            }
        }

        void scheduleRefresh() {
            if (this.myRootsToRefresh != null) {
                for (NewVirtualFile root : this.myRootsToRefresh) {
                    root.markDirtyRecursively();
                }
                boolean async = !ApplicationManager.getApplication().isUnitTestMode();
                RefreshQueue.getInstance().refresh(async, true, null, this.myRootsToRefresh);
            }
        }
    }
}

