/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.icons.AllIcons;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.NewDirectoryProjectDialog;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.Function;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewDirectoryProjectAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(NewDirectoryProjectAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/platform/NewDirectoryProjectAction", "actionPerformed"));
        }
        Project project = e.getProject();
        NewDirectoryProjectDialog dlg = new NewDirectoryProjectDialog(project);
        dlg.show();
        if (dlg.getExitCode() == 0) {
            this.generateProject(project, dlg);
        }
    }

    @Nullable
    protected Project generateProject(Project project, NewDirectoryProjectDialog dlg) {
        final DirectoryProjectGenerator generator = dlg.getProjectGenerator();
        return NewDirectoryProjectAction.doGenerateProject(project, dlg.getNewProjectLocation(), generator, new Function<VirtualFile, Object>(){

            public Object fun(VirtualFile file) {
                return NewDirectoryProjectAction.this.showSettings(generator, file);
            }
        });
    }

    public static Project doGenerateProject(@Nullable Project project, @NotNull String locationString, final @Nullable DirectoryProjectGenerator generator, @NotNull Function<VirtualFile, Object> settingsComputable) {
        String message;
        int rc;
        if (locationString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locationString", "com/intellij/platform/NewDirectoryProjectAction", "doGenerateProject"));
        }
        if (settingsComputable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsComputable", "com/intellij/platform/NewDirectoryProjectAction", "doGenerateProject"));
        }
        final File location = new File(FileUtil.toSystemDependentName((String)locationString));
        if (!location.exists() && !location.mkdirs()) {
            String message2 = ActionsBundle.message((String)"action.NewDirectoryProject.cannot.create.dir", (Object[])new Object[]{location.getAbsolutePath()});
            Messages.showErrorDialog((Project)project, (String)message2, (String)ActionsBundle.message((String)"action.NewDirectoryProject.title", (Object[])new Object[0]));
            return null;
        }
        final VirtualFile baseDir = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(location);
            }
        });
        if (baseDir == null) {
            LOG.error("Couldn't find '" + location + "' in VFS");
            return null;
        }
        baseDir.refresh(false, true);
        if (baseDir.getChildren().length > 0 && (rc = Messages.showYesNoDialog((Project)project, (String)(message = ActionsBundle.message((String)"action.NewDirectoryProject.not.empty", (Object[])new Object[]{location.getAbsolutePath()})), (String)ActionsBundle.message((String)"action.NewDirectoryProject.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) == 0) {
            return PlatformProjectOpenProcessor.getInstance().doOpenProject(baseDir, null, false);
        }
        String generatorName = generator == null ? "empty" : ConvertUsagesUtil.ensureProperKey(generator.getName());
        UsageTrigger.trigger("NewDirectoryProjectAction." + generatorName);
        Object settings = null;
        if (generator != null) {
            try {
                settings = settingsComputable.fun((Object)baseDir);
            }
            catch (ProcessCanceledException e) {
                return null;
            }
        }
        RecentProjectsManager.getInstance().setLastProjectCreationLocation(location.getParent());
        final Object finalSettings = settings;
        return PlatformProjectOpenProcessor.doOpenProject(baseDir, null, false, -1, new ProjectOpenedCallback(){

            public void projectOpened(Project project, Module module) {
                if (generator != null) {
                    generator.generateProject(project, baseDir, finalSettings, module);
                }
            }
        }, false);
    }

    protected Object showSettings(DirectoryProjectGenerator generator, VirtualFile baseDir) throws ProcessCanceledException {
        return generator.showGenerationSettings(baseDir);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/platform/NewDirectoryProjectAction", "update"));
        }
        if (NewWelcomeScreen.isNewWelcomeScreen(e)) {
            e.getPresentation().setIcon(AllIcons.Welcome.CreateNewProject);
        }
    }
}

