/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.content;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.content.JpsExcludeFolder;
import com.intellij.project.model.impl.module.content.JpsSourceFolder;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JpsContentEntry
implements ContentEntry,
Disposable {
    private final VirtualFilePointer myRoot;
    private final JpsModule myModule;
    private final JpsRootModel myRootModel;
    private final List<JpsSourceFolder> mySourceFolders;
    private final List<JpsExcludeFolder> myExcludeFolders;

    public JpsContentEntry(JpsModule module, JpsRootModel rootModel, String rootUrl) {
        this.myModule = module;
        this.myRootModel = rootModel;
        this.myRoot = VirtualFilePointerManager.getInstance().create(rootUrl, (Disposable)this, null);
        this.mySourceFolders = new ArrayList<JpsSourceFolder>();
        String rootPath = VfsUtilCore.urlToPath((String)this.getUrl());
        for (JpsModuleSourceRoot root : this.myModule.getSourceRoots()) {
            if (!FileUtil.isAncestor((String)rootPath, (String)VfsUtilCore.urlToPath((String)root.getUrl()), (boolean)false)) continue;
            this.mySourceFolders.add(new JpsSourceFolder(root, this));
        }
        this.myExcludeFolders = new ArrayList<JpsExcludeFolder>();
        for (String excludedUrl : this.myModule.getExcludeRootsList().getUrls()) {
            if (!FileUtil.isAncestor((String)rootPath, (String)VfsUtilCore.urlToPath((String)excludedUrl), (boolean)false)) continue;
            this.myExcludeFolders.add(new JpsExcludeFolder(excludedUrl, this));
        }
    }

    public VirtualFile getFile() {
        return this.myRoot.getFile();
    }

    @NotNull
    public String getUrl() {
        String string = this.myRoot.getUrl();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getUrl"));
        }
        return string;
    }

    @NotNull
    public SourceFolder[] getSourceFolders() {
        SourceFolder[] sourceFolderArray = this.mySourceFolders.toArray(new SourceFolder[this.mySourceFolders.size()]);
        if (sourceFolderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getSourceFolders"));
        }
        return sourceFolderArray;
    }

    @NotNull
    public List<SourceFolder> getSourceFolders(@NotNull JpsModuleSourceRootType<?> rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getSourceFolders"));
        }
        List<SourceFolder> list = this.getSourceFolders(Collections.singleton(rootType));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getSourceFolders"));
        }
        return list;
    }

    @NotNull
    public List<SourceFolder> getSourceFolders(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTypes", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getSourceFolders"));
        }
        SmartList folders = new SmartList();
        for (JpsSourceFolder folder : this.mySourceFolders) {
            if (!rootTypes.contains(folder.getRootType())) continue;
            folders.add(folder);
        }
        SmartList smartList = folders;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getSourceFolders"));
        }
        return smartList;
    }

    @NotNull
    public VirtualFile[] getSourceFolderFiles() {
        VirtualFile[] virtualFileArray = JpsContentEntry.getFiles((ContentFolder[])this.getSourceFolders());
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getSourceFolderFiles"));
        }
        return virtualFileArray;
    }

    private static VirtualFile[] getFiles(ContentFolder[] sourceFolders) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(sourceFolders.length);
        for (ContentFolder sourceFolder : sourceFolders) {
            VirtualFile file = sourceFolder.getFile();
            if (file == null) continue;
            result2.add(file);
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    @NotNull
    public ExcludeFolder[] getExcludeFolders() {
        ExcludeFolder[] excludeFolderArray = this.myExcludeFolders.toArray(new ExcludeFolder[this.myExcludeFolders.size()]);
        if (excludeFolderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getExcludeFolders"));
        }
        return excludeFolderArray;
    }

    @NotNull
    public List<String> getExcludeFolderUrls() {
        ArrayList<String> excluded = new ArrayList<String>();
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            excluded.add(folder.getUrl());
        }
        for (DirectoryIndexExcludePolicy excludePolicy : (DirectoryIndexExcludePolicy[])Extensions.getExtensions(DirectoryIndexExcludePolicy.EP_NAME, (AreaInstance)this.myRootModel.getProject())) {
            for (VirtualFilePointer pointer : excludePolicy.getExcludeRootsForModule(this.myRootModel)) {
                excluded.add(pointer.getUrl());
            }
        }
        ArrayList<String> arrayList = excluded;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getExcludeFolderUrls"));
        }
        return arrayList;
    }

    @NotNull
    public VirtualFile[] getExcludeFolderFiles() {
        ArrayList excluded = new ArrayList();
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            ContainerUtil.addIfNotNull(excluded, (Object)folder.getFile());
        }
        for (DirectoryIndexExcludePolicy excludePolicy : (DirectoryIndexExcludePolicy[])Extensions.getExtensions(DirectoryIndexExcludePolicy.EP_NAME, (AreaInstance)this.myRootModel.getProject())) {
            for (VirtualFilePointer pointer : excludePolicy.getExcludeRootsForModule(this.myRootModel)) {
                ContainerUtil.addIfNotNull(excluded, (Object)pointer.getFile());
            }
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(excluded);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getExcludeFolderFiles"));
        }
        return virtualFileArray;
    }

    @NotNull
    public SourceFolder addSourceFolder(@NotNull VirtualFile file, boolean isTestSource) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        SourceFolder sourceFolder = this.addSourceFolder(file, isTestSource, "");
        if (sourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        return sourceFolder;
    }

    @NotNull
    public SourceFolder addSourceFolder(@NotNull VirtualFile file, boolean isTestSource, @NotNull String packagePrefix) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        if (packagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePrefix", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        SourceFolder sourceFolder = this.addSourceFolder(file.getUrl(), isTestSource, packagePrefix);
        if (sourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        return sourceFolder;
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file, @NotNull JpsModuleSourceRootType<P> type, @NotNull P properties) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        JpsModuleSourceRoot sourceRoot = this.myModule.addSourceRoot(file.getUrl(), type, properties);
        JpsSourceFolder sourceFolder = new JpsSourceFolder(sourceRoot, this);
        this.mySourceFolders.add(sourceFolder);
        JpsSourceFolder jpsSourceFolder = sourceFolder;
        if (jpsSourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        return jpsSourceFolder;
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file, @NotNull JpsModuleSourceRootType<P> type) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        SourceFolder sourceFolder = this.addSourceFolder(file, type, (JpsElement)type.createDefaultProperties());
        if (sourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        return sourceFolder;
    }

    private SourceFolder addSourceFolder(String url, boolean isTestSource, String packagePrefix) {
        JavaSourceRootType rootType = isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        JavaSourceRootProperties properties = JpsJavaExtensionService.getInstance().createSourceRootProperties(packagePrefix);
        return this.addSourceFolder(url, (JpsModuleSourceRootType)rootType, (JpsElement)properties);
    }

    @NotNull
    public SourceFolder addSourceFolder(@NotNull String url, boolean isTestSource) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        SourceFolder sourceFolder = this.addSourceFolder(url, isTestSource, "");
        if (sourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        return sourceFolder;
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        SourceFolder sourceFolder = this.addSourceFolder(url, type, (JpsElement)type.createDefaultProperties());
        if (sourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        return sourceFolder;
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type, @NotNull P properties) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        JpsModuleSourceRoot sourceRoot = this.myModule.addSourceRoot(url, type, properties);
        JpsSourceFolder sourceFolder = new JpsSourceFolder(sourceRoot, this);
        this.mySourceFolders.add(sourceFolder);
        JpsSourceFolder jpsSourceFolder = sourceFolder;
        if (jpsSourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        return jpsSourceFolder;
    }

    public void removeSourceFolder(@NotNull SourceFolder sourceFolder) {
        if (sourceFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFolder", "com/intellij/project/model/impl/module/content/JpsContentEntry", "removeSourceFolder"));
        }
        JpsSourceFolder folder = (JpsSourceFolder)sourceFolder;
        this.mySourceFolders.remove(folder);
        this.myModule.removeSourceRoot(folder.getSourceRoot().getUrl(), folder.getSourceRoot().getRootType());
        Disposer.dispose((Disposable)folder);
    }

    public void clearSourceFolders() {
        ArrayList<JpsModuleSourceRoot> toRemove = new ArrayList<JpsModuleSourceRoot>();
        for (JpsSourceFolder folder : this.mySourceFolders) {
            toRemove.add(folder.getSourceRoot());
            Disposer.dispose((Disposable)folder);
        }
        this.mySourceFolders.clear();
        for (JpsModuleSourceRoot root : toRemove) {
            this.myModule.removeSourceRoot(root.getUrl(), root.getRootType());
        }
    }

    public ExcludeFolder addExcludeFolder(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addExcludeFolder"));
        }
        return this.addExcludeFolder(file.getUrl());
    }

    public ExcludeFolder addExcludeFolder(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addExcludeFolder"));
        }
        JpsExcludeFolder folder = new JpsExcludeFolder(url, this);
        this.myModule.getExcludeRootsList().addUrl(url);
        this.myExcludeFolders.add(folder);
        return folder;
    }

    public void removeExcludeFolder(@NotNull ExcludeFolder excludeFolder) {
        if (excludeFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludeFolder", "com/intellij/project/model/impl/module/content/JpsContentEntry", "removeExcludeFolder"));
        }
        JpsExcludeFolder folder = (JpsExcludeFolder)excludeFolder;
        this.myExcludeFolders.remove(folder);
        this.myModule.getExcludeRootsList().removeUrl(folder.getUrl());
        Disposer.dispose((Disposable)folder);
    }

    public boolean removeExcludeFolder(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/project/model/impl/module/content/JpsContentEntry", "removeExcludeFolder"));
        }
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            if (!folder.getUrl().equals(url)) continue;
            this.myExcludeFolders.remove(folder);
            this.myModule.getExcludeRootsList().removeUrl(url);
            Disposer.dispose((Disposable)folder);
            return true;
        }
        return false;
    }

    public void clearExcludeFolders() {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            toRemove.add(folder.getUrl());
            Disposer.dispose((Disposable)folder);
        }
        this.myExcludeFolders.clear();
        for (String url : toRemove) {
            this.myModule.getExcludeRootsList().removeUrl(url);
        }
    }

    public boolean isSynthetic() {
        return false;
    }

    public void dispose() {
        for (JpsSourceFolder jpsSourceFolder : this.mySourceFolders) {
            Disposer.dispose((Disposable)jpsSourceFolder);
        }
        for (JpsExcludeFolder jpsExcludeFolder : this.myExcludeFolders) {
            Disposer.dispose((Disposable)jpsExcludeFolder);
        }
    }
}

