/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.annotations.NotNull;

public class ClassFileDecompiler
implements BinaryFileDecompiler {
    private static final Logger LOG = Logger.getInstance(ClassFileDecompiler.class);

    @NotNull
    public CharSequence decompile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/compiled/ClassFileDecompiler", "decompile"));
        }
        ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.find((VirtualFile)file);
        if (decompiler instanceof ClassFileDecompilers.Full) {
            PsiManager manager = PsiManager.getInstance((Project)DefaultProjectFactory.getInstance().getDefaultProject());
            CharSequence charSequence = ((ClassFileDecompilers.Full)decompiler).createFileViewProvider(file, manager, true).getContents();
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClassFileDecompiler", "decompile"));
            }
            return charSequence;
        }
        if (decompiler instanceof ClassFileDecompilers.Light) {
            CharSequence charSequence;
            try {
                charSequence = ((ClassFileDecompilers.Light)decompiler).getText(file);
            }
            catch (ClassFileDecompilers.Light.CannotDecompileException e) {
                LOG.warn("decompiler: " + decompiler.getClass(), (Throwable)e);
            }
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClassFileDecompiler", "decompile"));
            }
            return charSequence;
        }
        CharSequence charSequence = ClsFileImpl.decompile(file);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClassFileDecompiler", "decompile"));
        }
        return charSequence;
    }
}

