/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import com.intellij.psi.impl.compiled.OutOfOrderInnerClassException;
import com.intellij.psi.impl.compiled.SignatureParsing;
import com.intellij.psi.impl.java.stubs.JavaClassReferenceListElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiFieldStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiMethodStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiModifierListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterListStubImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.cls.ClsFormatException;
import java.lang.reflect.Array;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class StubBuildingVisitor<T>
extends ClassVisitor {
    private static final Pattern REGEX_PATTERN = Pattern.compile("(?<=[^\\$\\.])\\$(?=[^\\$])");
    public static final String DOUBLE_POSITIVE_INF = "1.0 / 0.0";
    public static final String DOUBLE_NEGATIVE_INF = "-1.0 / 0.0";
    public static final String DOUBLE_NAN = "0.0d / 0.0";
    public static final String FLOAT_POSITIVE_INF = "1.0f / 0.0";
    public static final String FLOAT_NEGATIVE_INF = "-1.0f / 0.0";
    public static final String FLOAT_NAN = "0.0f / 0.0";
    private static final int ASM_API = 327680;
    private static final String SYNTHETIC_CLASS_INIT_METHOD = "<clinit>";
    private static final String SYNTHETIC_INIT_METHOD = "<init>";
    private final T mySource;
    private final InnerClassSourceStrategy<T> myInnersStrategy;
    private final StubElement myParent;
    private final int myAccess;
    private final String myShortName;
    private PsiClassStub myResult;
    private PsiModifierListStub myModList;
    private static final String[] parameterNames = new String[]{"p1", "p2", "p3", "p4", "p5", "p6", "p7", "p8", "p9"};

    public StubBuildingVisitor(T classSource, InnerClassSourceStrategy<T> innersStrategy, StubElement parent, int access, String shortName) {
        super(327680);
        this.mySource = classSource;
        this.myInnersStrategy = innersStrategy;
        this.myParent = parent;
        this.myAccess = access;
        this.myShortName = shortName;
    }

    public PsiClassStub<?> getResult() {
        return this.myResult;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String convertedSuper;
        StringCharacterIterator signatureIterator;
        String fqn = StubBuildingVisitor.getFqn(name, this.myShortName, this.myParent instanceof PsiClassStub ? ((PsiClassStub)this.myParent).getQualifiedName() : null);
        String shortName = this.myShortName != null && name.endsWith(this.myShortName) ? this.myShortName : PsiNameHelper.getShortClassName((String)fqn);
        int flags = this.myAccess | access;
        boolean isDeprecated = (flags & 0x20000) != 0;
        boolean isInterface = (flags & 0x200) != 0;
        boolean isEnum = (flags & 0x4000) != 0;
        boolean isAnnotationType = (flags & 0x2000) != 0;
        byte stubFlags = PsiClassStubImpl.packFlags(isDeprecated, isInterface, isEnum, false, false, isAnnotationType, false, false);
        this.myResult = new PsiClassStubImpl(JavaStubElementTypes.CLASS, this.myParent, fqn, shortName, null, stubFlags);
        LanguageLevel languageLevel = ClsParsingUtil.getLanguageLevelByVersion(version);
        if (languageLevel == null) {
            languageLevel = LanguageLevel.HIGHEST;
        }
        ((PsiClassStubImpl)this.myResult).setLanguageLevel(languageLevel);
        this.myModList = new PsiModifierListStubImpl((StubElement)this.myResult, StubBuildingVisitor.packClassFlags(flags));
        StringCharacterIterator stringCharacterIterator = signatureIterator = signature != null ? new StringCharacterIterator(signature) : null;
        if (signatureIterator != null) {
            try {
                SignatureParsing.parseTypeParametersDeclaration(signatureIterator, (StubElement)this.myResult);
            }
            catch (ClsFormatException e) {
                signatureIterator = null;
            }
        } else {
            new PsiTypeParameterListStubImpl((StubElement)this.myResult);
        }
        ArrayList<String> convertedInterfaces = new ArrayList<String>();
        if (signatureIterator == null) {
            convertedSuper = StubBuildingVisitor.parseClassDescription(superName, interfaces, convertedInterfaces);
        } else {
            try {
                convertedSuper = StubBuildingVisitor.parseClassSignature(signatureIterator, convertedInterfaces);
            }
            catch (ClsFormatException e) {
                new PsiTypeParameterListStubImpl((StubElement)this.myResult);
                convertedSuper = StubBuildingVisitor.parseClassDescription(superName, interfaces, convertedInterfaces);
            }
        }
        if (isInterface) {
            if (isAnnotationType) {
                convertedInterfaces.remove("java.lang.annotation.Annotation");
            }
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_LIST, (StubElement)this.myResult, ArrayUtil.toStringArray(convertedInterfaces));
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.IMPLEMENTS_LIST, (StubElement)this.myResult, new String[0]);
        } else {
            if (convertedSuper == null || "java.lang.Object".equals(convertedSuper) || isEnum && ("java.lang.Enum".equals(convertedSuper) || ("java.lang.Enum<" + fqn + ">").equals(convertedSuper))) {
                StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_LIST, (StubElement)this.myResult, new String[0]);
            } else {
                StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_LIST, (StubElement)this.myResult, convertedSuper);
            }
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.IMPLEMENTS_LIST, (StubElement)this.myResult, ArrayUtil.toStringArray(convertedInterfaces));
        }
    }

    public static String getFqn(@NotNull String internalName, @Nullable String shortName, @Nullable String parentName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "getFqn"));
        }
        if (shortName == null || !internalName.endsWith(shortName)) {
            return StubBuildingVisitor.getClassName(internalName);
        }
        if (internalName.length() == shortName.length()) {
            return shortName;
        }
        if (parentName == null) {
            parentName = StubBuildingVisitor.getClassName(internalName.substring(0, internalName.length() - shortName.length() - 1));
        }
        return parentName + "." + shortName;
    }

    public static void newReferenceList(JavaClassReferenceListElementType type, StubElement parent, String ... types) {
        PsiReferenceList.Role role;
        if (type == JavaStubElementTypes.EXTENDS_LIST) {
            role = PsiReferenceList.Role.EXTENDS_LIST;
        } else if (type == JavaStubElementTypes.IMPLEMENTS_LIST) {
            role = PsiReferenceList.Role.IMPLEMENTS_LIST;
        } else if (type == JavaStubElementTypes.THROWS_LIST) {
            role = PsiReferenceList.Role.THROWS_LIST;
        } else if (type == JavaStubElementTypes.EXTENDS_BOUND_LIST) {
            role = PsiReferenceList.Role.EXTENDS_BOUNDS_LIST;
        } else {
            throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
        }
        new PsiClassReferenceListStubImpl(type, parent, types, role);
    }

    @Nullable
    private static String parseClassDescription(String superName, String[] interfaces, List<String> convertedInterfaces) {
        String convertedSuper = superName != null ? StubBuildingVisitor.getClassName(superName) : null;
        for (String anInterface : interfaces) {
            convertedInterfaces.add(StubBuildingVisitor.getClassName(anInterface));
        }
        return convertedSuper;
    }

    @Nullable
    private static String parseClassSignature(CharacterIterator signatureIterator, List<String> convertedInterfaces) throws ClsFormatException {
        String convertedSuper = SignatureParsing.parseTopLevelClassRefSignature(signatureIterator);
        while (signatureIterator.current() != '\uffff') {
            String ifs = SignatureParsing.parseTopLevelClassRefSignature(signatureIterator);
            if (ifs == null) {
                throw new ClsFormatException();
            }
            convertedInterfaces.add(ifs);
        }
        return convertedSuper;
    }

    private static int packCommonFlags(int access) {
        int flags = 0;
        flags = (access & 2) != 0 ? (flags |= 2) : ((access & 4) != 0 ? (flags |= 4) : ((access & 1) != 0 ? (flags |= 1) : (flags |= 0x1000)));
        if ((access & 8) != 0) {
            flags |= 8;
        }
        if ((access & 0x10) != 0) {
            flags |= 0x10;
        }
        return flags;
    }

    private static int packClassFlags(int access) {
        int flags = StubBuildingVisitor.packCommonFlags(access);
        if ((access & 0x400) != 0) {
            flags |= 0x400;
        }
        return flags;
    }

    private static int packFieldFlags(int access) {
        int flags = StubBuildingVisitor.packCommonFlags(access);
        if ((access & 0x40) != 0) {
            flags |= 0x40;
        }
        if ((access & 0x80) != 0) {
            flags |= 0x80;
        }
        return flags;
    }

    private static int packMethodFlags(int access, boolean isInterface) {
        int flags = StubBuildingVisitor.packCommonFlags(access);
        if ((access & 0x20) != 0) {
            flags |= 0x20;
        }
        if ((access & 0x100) != 0) {
            flags |= 0x100;
        }
        if ((access & 0x400) != 0) {
            flags |= 0x400;
        } else if (isInterface && (access & 8) == 0) {
            flags |= 0x200;
        }
        if ((access & 0x800) != 0) {
            flags |= 0x800;
        }
        return flags;
    }

    public void visitSource(String source, String debug) {
        ((PsiClassStubImpl)this.myResult).setSourceFileName(source);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        if (this.myParent instanceof PsiFileStub) {
            throw new OutOfOrderInnerClassException();
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new AnnotationTextCollector(desc, new AnnotationResultCallback(){

            @Override
            public void callback(String text) {
                new PsiAnnotationStubImpl(StubBuildingVisitor.this.myModList, text);
            }
        });
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if ((access & 0x1000) != 0) {
            return;
        }
        if (!StubBuildingVisitor.isCorrectName(innerName) || outerName == null) {
            return;
        }
        if ((StubBuildingVisitor.getClassName(outerName) + "." + innerName).equals(this.myResult.getQualifiedName()) && this.myParent instanceof PsiFileStub) {
            throw new OutOfOrderInnerClassException();
        }
        if (!StubBuildingVisitor.namesEqual(outerName, this.myResult.getQualifiedName())) {
            return;
        }
        T innerClass = this.myInnersStrategy.findInnerClass(innerName, this.mySource);
        if (innerClass != null) {
            StubBuildingVisitor<T> visitor = new StubBuildingVisitor<T>(innerClass, this.myInnersStrategy, (StubElement)this.myResult, access, innerName);
            this.myInnersStrategy.accept(innerClass, visitor);
        }
    }

    private static boolean isCorrectName(String name) {
        return name != null;
    }

    private static boolean namesEqual(String signature, String fqn) {
        int dot;
        if (fqn == null) {
            return true;
        }
        if (fqn.length() != signature.length()) {
            return false;
        }
        int p = 0;
        while ((dot = fqn.indexOf(46, p)) >= 0) {
            if (!signature.regionMatches(p, fqn, p, dot - p)) {
                return false;
            }
            char ch = signature.charAt(dot);
            if (ch != '/' && ch != '$') {
                return false;
            }
            p = dot + 1;
        }
        return fqn.regionMatches(p, signature, p, fqn.length() - p);
    }

    @Nullable
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & 0x1000) != 0) {
            return null;
        }
        if (!StubBuildingVisitor.isCorrectName(name)) {
            return null;
        }
        byte flags = PsiFieldStubImpl.packFlags((access & 0x4000) != 0, (access & 0x20000) != 0, false, false);
        TypeInfo type = StubBuildingVisitor.fieldType(desc, signature);
        String initializer = StubBuildingVisitor.constToString(value, type.text, false);
        PsiFieldStubImpl stub = new PsiFieldStubImpl((StubElement)this.myResult, name, type, initializer, flags);
        PsiModifierListStubImpl modList = new PsiModifierListStubImpl((StubElement)stub, StubBuildingVisitor.packFieldFlags(access));
        return new AnnotationCollectingVisitor(modList);
    }

    @NotNull
    public static TypeInfo fieldType(String desc, String signature) {
        if (signature != null) {
            TypeInfo typeInfo;
            try {
                typeInfo = TypeInfo.fromString(SignatureParsing.parseTypeString(new StringCharacterIterator(signature, 0)));
            }
            catch (ClsFormatException e) {
                TypeInfo typeInfo2 = StubBuildingVisitor.fieldTypeViaDescription(desc);
                if (typeInfo2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "fieldType"));
                }
                return typeInfo2;
            }
            if (typeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "fieldType"));
            }
            return typeInfo;
        }
        TypeInfo typeInfo = StubBuildingVisitor.fieldTypeViaDescription(desc);
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "fieldType"));
        }
        return typeInfo;
    }

    @NotNull
    private static TypeInfo fieldTypeViaDescription(@NotNull String desc) {
        int dim;
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "fieldTypeViaDescription"));
        }
        Type type = Type.getType((String)desc);
        int n = dim = type.getSort() == 9 ? type.getDimensions() : 0;
        if (dim > 0) {
            type = type.getElementType();
        }
        TypeInfo typeInfo = new TypeInfo(StubBuildingVisitor.getTypeText(type), (byte)dim, false, PsiAnnotationStub.EMPTY_ARRAY);
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "fieldTypeViaDescription"));
        }
        return typeInfo;
    }

    @Nullable
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        int localVarIgnoreCount;
        if ((access & 0x1000) != 0) {
            return null;
        }
        if (SYNTHETIC_CLASS_INIT_METHOD.equals(name)) {
            return null;
        }
        boolean isEnum = this.myResult.isEnum();
        if (isEnum) {
            if ("values".equals(name) && desc.startsWith("()")) {
                return null;
            }
            if ("valueOf".equals(name) && desc.startsWith("(Ljava/lang/String;)")) {
                return null;
            }
        }
        boolean isDeprecated = (access & 0x20000) != 0;
        boolean isConstructor = SYNTHETIC_INIT_METHOD.equals(name);
        boolean isVarargs = (access & 0x80) != 0;
        boolean isAnnotationMethod = this.myResult.isAnnotationType();
        if (!isConstructor && !StubBuildingVisitor.isCorrectName(name)) {
            return null;
        }
        byte flags = PsiMethodStubImpl.packFlags(isConstructor, isAnnotationMethod, isVarargs, isDeprecated, false, false);
        String canonicalMethodName = isConstructor ? this.myResult.getName() : name;
        List<String> args = new ArrayList<String>();
        ArrayList<String> throwables = exceptions != null ? new ArrayList<String>() : null;
        int modifiersMask = StubBuildingVisitor.packMethodFlags(access, this.myResult.isInterface());
        PsiMethodStubImpl stub = new PsiMethodStubImpl((StubElement)this.myResult, canonicalMethodName, flags, signature, args, throwables, desc, modifiersMask);
        PsiModifierListStub modList = (PsiModifierListStub)stub.findChildStubByType((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
        assert (modList != null) : stub;
        if (isEnum && isConstructor && signature == null && args.size() >= 2 && "java.lang.String".equals(args.get(0)) && "int".equals(args.get(1))) {
            args = args.subList(2, args.size());
        }
        boolean isNonStaticInnerClassConstructor = isConstructor && !(this.myParent instanceof PsiFileStub) && (this.myModList.getModifiersMask() & 8) == 0;
        boolean parsedViaGenericSignature = stub.isParsedViaGenericSignature();
        boolean shouldSkipFirstParamForNonStaticInnerClassConstructor = !parsedViaGenericSignature && isNonStaticInnerClassConstructor;
        PsiParameterListStubImpl parameterList = new PsiParameterListStubImpl((StubElement)stub);
        int paramCount = args.size();
        PsiParameterStubImpl[] paramStubs = new PsiParameterStubImpl[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            PsiParameterStubImpl parameterStub;
            if (shouldSkipFirstParamForNonStaticInnerClassConstructor && i == 0) continue;
            String arg = args.get(i);
            boolean isEllipsisParam = isVarargs && i == paramCount - 1;
            TypeInfo typeInfo = TypeInfo.fromString(arg, isEllipsisParam);
            String paramName = i < parameterNames.length ? parameterNames[i] : "p" + (i + 1);
            paramStubs[i] = parameterStub = new PsiParameterStubImpl((StubElement)parameterList, paramName, typeInfo, isEllipsisParam);
            new PsiModifierListStubImpl((StubElement)parameterStub, 0);
        }
        String[] thrownTypes = StubBuildingVisitor.buildThrowsList(exceptions, throwables, parsedViaGenericSignature);
        StubBuildingVisitor.newReferenceList(JavaStubElementTypes.THROWS_LIST, (StubElement)stub, thrownTypes);
        int n = (access & 8) != 0 ? 0 : (localVarIgnoreCount = isConstructor && isEnum ? 3 : 1);
        int paramIgnoreCount = isConstructor && isEnum ? 2 : (isNonStaticInnerClassConstructor ? 1 : 0);
        return new AnnotationParamCollectingVisitor(stub, modList, localVarIgnoreCount, paramIgnoreCount, paramCount, paramStubs);
    }

    private static String[] buildThrowsList(String[] exceptions, List<String> throwables, boolean parsedViaGenericSignature) {
        if (exceptions == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (parsedViaGenericSignature && throwables != null && exceptions.length > throwables.size()) {
            parsedViaGenericSignature = false;
        }
        if (parsedViaGenericSignature && throwables != null) {
            return ArrayUtil.toStringArray(throwables);
        }
        String[] converted = ArrayUtil.newStringArray((int)exceptions.length);
        for (int i = 0; i < converted.length; ++i) {
            converted[i] = StubBuildingVisitor.getClassName(exceptions[i]);
        }
        return converted;
    }

    @NotNull
    public static String parseMethodViaDescription(@NotNull String desc, @NotNull PsiMethodStubImpl stub, @NotNull List<String> args) {
        Type[] argTypes;
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "parseMethodViaDescription"));
        }
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "parseMethodViaDescription"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "parseMethodViaDescription"));
        }
        String returnType = StubBuildingVisitor.getTypeText(Type.getReturnType((String)desc));
        for (Type argType : argTypes = Type.getArgumentTypes((String)desc)) {
            args.add(StubBuildingVisitor.getTypeText(argType));
        }
        new PsiTypeParameterListStubImpl((StubElement)stub);
        String string = returnType;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "parseMethodViaDescription"));
        }
        return string;
    }

    @NotNull
    public static String parseMethodViaGenericSignature(@NotNull String signature, @NotNull PsiMethodStubImpl stub, @NotNull List<String> args, @Nullable List<String> throwables) throws ClsFormatException {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "parseMethodViaGenericSignature"));
        }
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "parseMethodViaGenericSignature"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "parseMethodViaGenericSignature"));
        }
        StringCharacterIterator iterator = new StringCharacterIterator(signature);
        SignatureParsing.parseTypeParametersDeclaration(iterator, (StubElement)stub);
        if (iterator.current() != '(') {
            throw new ClsFormatException();
        }
        iterator.next();
        while (iterator.current() != ')' && iterator.current() != '\uffff') {
            args.add(SignatureParsing.parseTypeString(iterator));
        }
        if (iterator.current() != ')') {
            throw new ClsFormatException();
        }
        iterator.next();
        String returnType = SignatureParsing.parseTypeString(iterator);
        while (iterator.current() == '^') {
            iterator.next();
            String exType = SignatureParsing.parseTypeString(iterator);
            if (throwables == null) continue;
            throwables.add(exType);
        }
        String string = returnType;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "parseMethodViaGenericSignature"));
        }
        return string;
    }

    @Nullable
    private static String constToString(@Nullable Object value, @Nullable String type, boolean anno) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return "\"" + StringUtil.escapeStringCharacters((String)((String)value)) + "\"";
        }
        if (value instanceof Boolean || value instanceof Short || value instanceof Byte) {
            return value.toString();
        }
        if (value instanceof Character) {
            return "'" + StringUtil.escapeCharCharacters((String)value.toString()) + "'";
        }
        if (value instanceof Long) {
            return value.toString() + "L";
        }
        if (value instanceof Integer) {
            if ("boolean".equals(type)) {
                if (value.equals(0)) {
                    return "false";
                }
                if (value.equals(1)) {
                    return "true";
                }
            }
            if ("char".equals(type)) {
                char ch = (char)((Integer)value).intValue();
                return "'" + StringUtil.escapeCharCharacters((String)String.valueOf(ch)) + "'";
            }
            return value.toString();
        }
        if (value instanceof Double) {
            double d = (Double)value;
            if (Double.isInfinite(d)) {
                return d > 0.0 ? DOUBLE_POSITIVE_INF : DOUBLE_NEGATIVE_INF;
            }
            if (Double.isNaN(d)) {
                return DOUBLE_NAN;
            }
            return Double.toString(d);
        }
        if (value instanceof Float) {
            float v = ((Float)value).floatValue();
            if (Float.isInfinite(v)) {
                return v > 0.0f ? FLOAT_POSITIVE_INF : FLOAT_NEGATIVE_INF;
            }
            if (Float.isNaN(v)) {
                return FLOAT_NAN;
            }
            return Float.toString(v) + "f";
        }
        if (value.getClass().isArray()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append('{');
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(StubBuildingVisitor.constToString(Array.get(value, i), type, anno));
            }
            buffer.append('}');
            return buffer.toString();
        }
        if (anno && value instanceof Type) {
            return StubBuildingVisitor.getTypeText((Type)value) + ".class";
        }
        return null;
    }

    private static String getClassName(String name) {
        return StubBuildingVisitor.getTypeText(Type.getObjectType((String)name));
    }

    @NotNull
    private static String getTypeText(@NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "getTypeText"));
        }
        String raw = type.getClassName();
        String string = raw.indexOf(36) >= 0 ? REGEX_PATTERN.matcher(raw).replaceAll("\\.") : raw;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "getTypeText"));
        }
        return string;
    }

    private static interface AnnotationResultCallback {
        public void callback(String var1);
    }

    private static class AnnotationParamCollectingVisitor
    extends MethodVisitor {
        private final PsiMethodStub myOwner;
        private final PsiModifierListStub myModList;
        private final int myIgnoreCount;
        private final int myParamIgnoreCount;
        private final int myParamCount;
        private final PsiParameterStubImpl[] myParamStubs;
        private int myUsedParamSize;
        private int myUsedParamCount;

        private AnnotationParamCollectingVisitor(@NotNull PsiMethodStub owner, @NotNull PsiModifierListStub modList, int ignoreCount, int paramIgnoreCount, int paramCount, @NotNull PsiParameterStubImpl[] paramStubs) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/psi/impl/compiled/StubBuildingVisitor$AnnotationParamCollectingVisitor", StubBuildingVisitor.SYNTHETIC_INIT_METHOD));
            }
            if (modList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modList", "com/intellij/psi/impl/compiled/StubBuildingVisitor$AnnotationParamCollectingVisitor", StubBuildingVisitor.SYNTHETIC_INIT_METHOD));
            }
            if (paramStubs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramStubs", "com/intellij/psi/impl/compiled/StubBuildingVisitor$AnnotationParamCollectingVisitor", StubBuildingVisitor.SYNTHETIC_INIT_METHOD));
            }
            super(327680);
            this.myUsedParamSize = 0;
            this.myUsedParamCount = 0;
            this.myOwner = owner;
            this.myModList = modList;
            this.myIgnoreCount = ignoreCount;
            this.myParamIgnoreCount = paramIgnoreCount;
            this.myParamCount = paramCount;
            this.myParamStubs = paramStubs;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationTextCollector(desc, new AnnotationResultCallback(){

                @Override
                public void callback(String text) {
                    new PsiAnnotationStubImpl(AnnotationParamCollectingVisitor.this.myModList, text);
                }
            });
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return new AnnotationTextCollector(null, new AnnotationResultCallback(){

                @Override
                public void callback(String text) {
                    ((PsiMethodStubImpl)AnnotationParamCollectingVisitor.this.myOwner).setDefaultValueText(text);
                }
            });
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (index >= this.myIgnoreCount) {
                PsiParameterStubImpl parameterStub;
                int paramIndex;
                int n = paramIndex = index - this.myIgnoreCount == this.myUsedParamSize ? this.myUsedParamCount : index - this.myIgnoreCount;
                if (paramIndex >= this.myParamCount) {
                    return;
                }
                if (ClsParsingUtil.isJavaIdentifier(name, LanguageLevel.HIGHEST) && (parameterStub = this.myParamStubs[paramIndex]) != null) {
                    parameterStub.setName(name);
                }
                this.myUsedParamCount = paramIndex + 1;
                this.myUsedParamSize = "D".equals(desc) || "J".equals(desc) ? (this.myUsedParamSize += 2) : ++this.myUsedParamSize;
            }
        }

        @Nullable
        public AnnotationVisitor visitParameterAnnotation(final int parameter, String desc, boolean visible) {
            if (parameter < this.myParamIgnoreCount) {
                return null;
            }
            return new AnnotationTextCollector(desc, new AnnotationResultCallback(){

                @Override
                public void callback(String text) {
                    new PsiAnnotationStubImpl(AnnotationParamCollectingVisitor.this.myOwner.findParameter(parameter - AnnotationParamCollectingVisitor.this.myParamIgnoreCount).getModList(), text);
                }
            });
        }
    }

    private static class AnnotationCollectingVisitor
    extends FieldVisitor {
        private final PsiModifierListStub myModList;

        private AnnotationCollectingVisitor(PsiModifierListStub modList) {
            super(327680);
            this.myModList = modList;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationTextCollector(desc, new AnnotationResultCallback(){

                @Override
                public void callback(String text) {
                    new PsiAnnotationStubImpl(AnnotationCollectingVisitor.this.myModList, text);
                }
            });
        }
    }

    private static class AnnotationTextCollector
    extends AnnotationVisitor {
        private final StringBuilder myBuilder = new StringBuilder();
        private final AnnotationResultCallback myCallback;
        private boolean hasParams = false;
        private final String myDesc;

        public AnnotationTextCollector(@Nullable String desc, AnnotationResultCallback callback) {
            super(327680);
            this.myCallback = callback;
            this.myDesc = desc;
            if (desc != null) {
                this.myBuilder.append('@').append(StubBuildingVisitor.getTypeText(Type.getType((String)desc)));
            }
        }

        public void visit(String name, Object value) {
            this.valuePairPrefix(name);
            this.myBuilder.append(StubBuildingVisitor.constToString(value, null, true));
        }

        public void visitEnum(String name, String desc, String value) {
            this.valuePairPrefix(name);
            this.myBuilder.append(StubBuildingVisitor.getTypeText(Type.getType((String)desc))).append(".").append(value);
        }

        private void valuePairPrefix(String name) {
            if (!this.hasParams) {
                this.hasParams = true;
                if (this.myDesc != null) {
                    this.myBuilder.append('(');
                }
            } else {
                this.myBuilder.append(',');
            }
            if (name != null) {
                this.myBuilder.append(name).append('=');
            }
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            this.valuePairPrefix(name);
            return new AnnotationTextCollector(desc, new AnnotationResultCallback(){

                @Override
                public void callback(String text) {
                    AnnotationTextCollector.this.myBuilder.append(text);
                }
            });
        }

        public AnnotationVisitor visitArray(String name) {
            this.valuePairPrefix(name);
            this.myBuilder.append("{");
            return new AnnotationTextCollector(null, new AnnotationResultCallback(){

                @Override
                public void callback(String text) {
                    AnnotationTextCollector.this.myBuilder.append(text).append('}');
                }
            });
        }

        public void visitEnd() {
            if (this.hasParams && this.myDesc != null) {
                this.myBuilder.append(')');
            }
            this.myCallback.callback(this.myBuilder.toString());
        }
    }
}

