/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.UpdateAddedFileProcessor;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JavaUpdateAddedFileProcessor
extends UpdateAddedFileProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/JavaUpdateAddedFileProcessor", "canProcessElement"));
        }
        return file instanceof PsiClassOwner && !JavaProjectRootsUtil.isOutsideJavaSourceRoot(file);
    }

    @Override
    public void update(PsiFile element, PsiFile originalElement) throws IncorrectOperationException {
        if (element.getViewProvider() instanceof TemplateLanguageFileViewProvider) {
            return;
        }
        PsiDirectory dir = element.getContainingDirectory();
        if (dir == null) {
            return;
        }
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(dir);
        if (aPackage == null) {
            return;
        }
        String packageName = aPackage.getQualifiedName();
        ((PsiClassOwner)element).setPackageName(packageName);
    }
}

