/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class VariableInIncompleteCodeSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public VariableInIncompleteCodeSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters p, final @NotNull Processor<PsiReference> consumer) {
        PsiElement[] elements;
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/VariableInIncompleteCodeSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/VariableInIncompleteCodeSearcher", "processQuery"));
        }
        final PsiElement refElement = p.getElementToSearch();
        if (!refElement.isValid() || !(refElement instanceof PsiVariable)) {
            return;
        }
        final String name = ((PsiVariable)refElement).getName();
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return;
        }
        SearchScope scope = p.getEffectiveSearchScope();
        if (!(scope instanceof LocalSearchScope)) {
            PsiFile file = refElement.getContainingFile();
            if (file == null) {
                return;
            }
            scope = new LocalSearchScope((PsiElement)file);
        }
        if ((elements = ((LocalSearchScope)scope).getScope()).length == 0) {
            return;
        }
        PsiSearchHelper.SERVICE.getInstance((Project)p.getProject()).processElementsWithWord(new TextOccurenceProcessor(){

            public boolean execute(@NotNull PsiElement element, int offsetInElement) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/search/VariableInIncompleteCodeSearcher$1", "execute"));
                }
                for (PsiElement child = element.findElementAt(offsetInElement); child != null && name.equals(child.getText()); child = child.getParent()) {
                    PsiJavaCodeReferenceElement ref;
                    if (!(child instanceof PsiJavaCodeReferenceElement) || (ref = (PsiJavaCodeReferenceElement)child).isQualified() || ref.getParent() instanceof PsiMethodCallExpression || ref.resolve() != null || ref.advancedResolve(true).getElement() != refElement) continue;
                    consumer.process((Object)ref);
                }
                return true;
            }
        }, scope, name, (short)255, true);
    }
}

