/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class XmlAttributeValueManipulator
extends AbstractElementManipulator<XmlAttributeValue> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.resolve.reference.impl.manipulators.XmlAttributeValueManipulator");

    public XmlAttributeValue handleContentChange(@NotNull XmlAttributeValue element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeValueManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeValueManipulator", "handleContentChange"));
        }
        return XmlAttributeValueManipulator.handleContentChange(element, range, newContent, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN);
    }

    public static <T extends PsiElement> T handleContentChange(T element, TextRange range, String newContent, IElementType tokenType) {
        String text;
        CheckUtil.checkWritable(element);
        CompositeElement attrNode = (CompositeElement)element.getNode();
        LeafElement valueNode = attrNode.findLeafElementAt(range.getStartOffset());
        LOG.assertTrue(valueNode != null, (Object)("Leaf not found in " + attrNode + " at offset " + range.getStartOffset() + " in element " + element));
        PsiElement elementToReplace = valueNode.getPsi();
        try {
            text = elementToReplace.getText();
            int offsetInParent = elementToReplace.getStartOffsetInParent();
            String textBeforeRange = text.substring(0, range.getStartOffset() - offsetInParent);
            String textAfterRange = text.substring(range.getEndOffset() - offsetInParent, text.length());
            newContent = element.getText().startsWith("'") || element.getText().endsWith("'") ? newContent.replace("'", "&apos;") : newContent.replace("\"", "&quot;");
            text = textBeforeRange + newContent + textAfterRange;
        }
        catch (StringIndexOutOfBoundsException e) {
            LOG.error("Range: " + range + " in text: '" + element.getText() + "'", (Throwable)e);
            throw e;
        }
        CharTable charTableByTree = SharedImplUtil.findCharTableByTree(attrNode);
        LeafElement newValueElement = Factory.createSingleLeafElement(tokenType, text, charTableByTree, element.getManager());
        attrNode.replaceChildInternal(valueNode, newValueElement);
        return element;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull XmlAttributeValue xmlAttributeValue) {
        if (xmlAttributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeValueManipulator", "getRangeInElement"));
        }
        PsiElement first = xmlAttributeValue.getFirstChild();
        if (first == null) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeValueManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        ASTNode firstNode = first.getNode();
        assert (firstNode != null);
        PsiElement last = xmlAttributeValue.getLastChild();
        ASTNode lastNode = last != null && last != first ? last.getNode() : null;
        int textLength = xmlAttributeValue.getTextLength();
        int start = firstNode.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER ? first.getTextLength() : 0;
        int end = lastNode != null && lastNode.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER ? last.getTextLength() : 0;
        TextRange textRange = new TextRange(start, textLength - end);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeValueManipulator", "getRangeInElement"));
        }
        return textRange;
    }
}

