/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShredImpl
implements PsiLanguageInjectionHost.Shred {
    private final SmartPsiFileRange relevantRangeInHost;
    private final SmartPsiElementPointer<PsiLanguageInjectionHost> hostElementPointer;
    private final TextRange range;
    private final String prefix;
    private final String suffix;
    private final boolean usePsiRange;

    ShredImpl(@NotNull SmartPsiFileRange relevantRangeInHost, @NotNull SmartPsiElementPointer<PsiLanguageInjectionHost> hostElementPointer, @NotNull String prefix, @NotNull String suffix, @NotNull TextRange range, boolean usePsiRange) {
        if (relevantRangeInHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relevantRangeInHost", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "<init>"));
        }
        if (hostElementPointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostElementPointer", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "<init>"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "<init>"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "<init>"));
        }
        this.hostElementPointer = hostElementPointer;
        this.relevantRangeInHost = relevantRangeInHost;
        this.prefix = prefix;
        this.suffix = suffix;
        this.range = range;
        this.usePsiRange = usePsiRange;
        this.assertValid();
    }

    private void assertValid() {
        Segment hostRange = this.getHostRangeMarker();
        assert (hostRange != null) : "invalid host range: " + this.relevantRangeInHost;
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)this.hostElementPointer.getElement();
        assert (host != null && host.isValid()) : "no host: " + this.hostElementPointer;
    }

    ShredImpl withPsiRange() {
        return new ShredImpl(this.relevantRangeInHost, this.hostElementPointer, this.prefix, this.suffix, this.range, true);
    }

    @NotNull
    public SmartPsiElementPointer<PsiLanguageInjectionHost> getSmartPointer() {
        SmartPsiElementPointer<PsiLanguageInjectionHost> smartPsiElementPointer = this.hostElementPointer;
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "getSmartPointer"));
        }
        return smartPsiElementPointer;
    }

    @Nullable(value="returns null when the host document marker is invalid")
    public Segment getHostRangeMarker() {
        return this.usePsiRange ? this.relevantRangeInHost.getPsiRange() : this.relevantRangeInHost.getRange();
    }

    @NotNull
    public TextRange getRangeInsideHost() {
        TextRange textRange;
        PsiLanguageInjectionHost host = this.getHost();
        Segment psiRange = this.relevantRangeInHost.getPsiRange();
        TextRange textRange2 = textRange = psiRange == null ? null : TextRange.create((Segment)psiRange);
        if (host == null) {
            if (textRange != null) {
                TextRange textRange3 = textRange;
                if (textRange3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "getRangeInsideHost"));
                }
                return textRange3;
            }
            Segment fromSP = this.hostElementPointer.getPsiRange();
            if (fromSP != null) {
                TextRange textRange4 = TextRange.create((Segment)fromSP);
                if (textRange4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "getRangeInsideHost"));
                }
                return textRange4;
            }
            TextRange textRange5 = new TextRange(0, 0);
            if (textRange5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "getRangeInsideHost"));
            }
            return textRange5;
        }
        TextRange hostTextRange = host.getTextRange();
        TextRange textRange6 = textRange = textRange == null ? null : textRange.intersection(hostTextRange);
        if (textRange == null) {
            ProperTextRange properTextRange = new ProperTextRange(0, hostTextRange.getLength());
            if (properTextRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "getRangeInsideHost"));
            }
            return properTextRange;
        }
        TextRange textRange7 = textRange.shiftRight(-hostTextRange.getStartOffset());
        if (textRange7 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "getRangeInsideHost"));
        }
        return textRange7;
    }

    public String toString() {
        PsiLanguageInjectionHost host = this.getHost();
        Segment hostRange = this.getHostRangeMarker();
        return "Shred " + (host == null ? null : host.getTextRange()) + ": " + host + " In host range: " + (hostRange != null ? "(" + hostRange.getStartOffset() + "," + hostRange.getEndOffset() + ");" : "invalid;") + " PSI range: " + this.range;
    }

    public boolean isValid() {
        PsiLanguageInjectionHost host = this.getHost();
        return this.getHostRangeMarker() != null && host != null && host.isValid();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)o;
        PsiLanguageInjectionHost host = this.getHost();
        Segment hostRangeMarker = this.getHostRangeMarker();
        Segment hostRangeMarker2 = shred.getHostRangeMarker();
        return host != null && host.equals(shred.getHost()) && this.prefix.equals(shred.getPrefix()) && this.suffix.equals(shred.getSuffix()) && this.range.equals((Object)shred.getRange()) && hostRangeMarker != null && hostRangeMarker2 != null && TextRange.create((Segment)hostRangeMarker).equals((Object)TextRange.create((Segment)hostRangeMarker2));
    }

    public int hashCode() {
        return this.range.hashCode();
    }

    public void dispose() {
    }

    @Nullable
    public PsiLanguageInjectionHost getHost() {
        return (PsiLanguageInjectionHost)this.hostElementPointer.getElement();
    }

    @NotNull
    public TextRange getRange() {
        TextRange textRange = this.range;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "getRange"));
        }
        return textRange;
    }

    @NotNull
    public String getPrefix() {
        String string = this.prefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "getPrefix"));
        }
        return string;
    }

    @NotNull
    public String getSuffix() {
        String string = this.suffix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/ShredImpl", "getSuffix"));
        }
        return string;
    }
}

