/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveClassesOrPackagesCallback;
import com.intellij.refactoring.move.MoveMultipleElementsViewDescriptor;
import com.intellij.refactoring.move.moveClassesOrPackages.CommonMoveUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveAllClassesInFileHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.PackageLocalsUsageCollector;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classRefs.ClassInstanceScanner;
import com.intellij.refactoring.util.classRefs.ClassReferenceScanner;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveClassesOrPackagesProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesProcessor");
    private final PsiElement[] myElementsToMove;
    private boolean mySearchInComments;
    private boolean mySearchInNonJavaFiles;
    private final PackageWrapper myTargetPackage;
    private final MoveCallback myMoveCallback;
    @NotNull
    protected final MoveDestination myMoveDestination;
    protected NonCodeUsageInfo[] myNonCodeUsages;
    private boolean myOpenInEditor;

    public MoveClassesOrPackagesProcessor(Project project, PsiElement[] elements, @NotNull MoveDestination moveDestination, boolean searchInComments, boolean searchInNonJavaFiles, MoveCallback moveCallback) {
        if (moveDestination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moveDestination", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesProcessor", "<init>"));
        }
        super(project);
        LinkedHashSet<PsiElement> toMove = new LinkedHashSet<PsiElement>();
        for (PsiElement element : elements) {
            if (element instanceof PsiClassOwner) {
                Collections.addAll(toMove, ((PsiClassOwner)element).getClasses());
                continue;
            }
            toMove.add(element);
        }
        this.myElementsToMove = PsiUtilCore.toPsiElementArray(toMove);
        Arrays.sort(this.myElementsToMove, new Comparator<PsiElement>(){

            @Override
            public int compare(PsiElement o1, PsiElement o2) {
                VirtualFile virtualFile;
                PsiFile containingFile;
                if (o1 instanceof PsiClass && o2 instanceof PsiClass && Comparing.equal((Object)(containingFile = o1.getContainingFile()), (Object)o2.getContainingFile()) && (virtualFile = containingFile.getVirtualFile()) != null) {
                    String fileName = virtualFile.getNameWithoutExtension();
                    if (Comparing.strEqual((String)fileName, (String)((PsiClass)o1).getName())) {
                        return -1;
                    }
                    if (Comparing.strEqual((String)fileName, (String)((PsiClass)o2).getName())) {
                        return 1;
                    }
                }
                return 0;
            }
        });
        this.myMoveDestination = moveDestination;
        this.myTargetPackage = this.myMoveDestination.getTargetPackage();
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
        this.myMoveCallback = moveCallback;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesProcessor", "createUsageViewDescriptor"));
        }
        PsiElement[] elements = new PsiElement[this.myElementsToMove.length];
        System.arraycopy(this.myElementsToMove, 0, elements, 0, this.myElementsToMove.length);
        MoveMultipleElementsViewDescriptor moveMultipleElementsViewDescriptor = new MoveMultipleElementsViewDescriptor(elements, MoveClassesOrPackagesUtil.getPackageName(this.myTargetPackage));
        if (moveMultipleElementsViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesProcessor", "createUsageViewDescriptor"));
        }
        return moveMultipleElementsViewDescriptor;
    }

    public boolean verifyValidPackageName() {
        PsiNameHelper helper;
        String qName = this.myTargetPackage.getQualifiedName();
        if (!StringUtil.isEmpty((String)qName) && !(helper = PsiNameHelper.getInstance((Project)this.myProject)).isQualifiedName(qName)) {
            Messages.showMessageDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"invalid.target.package.name.specified"), (String)"Invalid Package Name", (Icon)Messages.getErrorIcon());
            return false;
        }
        return true;
    }

    private boolean hasClasses() {
        for (PsiElement element : this.getElements()) {
            if (!(element instanceof PsiClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isSearchInComments() {
        return this.mySearchInComments;
    }

    public boolean isSearchInNonJavaFiles() {
        return this.mySearchInNonJavaFiles;
    }

    public void setSearchInComments(boolean searchInComments) {
        this.mySearchInComments = searchInComments;
    }

    public void setSearchInNonJavaFiles(boolean searchInNonJavaFiles) {
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<UsageInfo> allUsages = new ArrayList<UsageInfo>();
        ArrayList<UsageInfo> usagesToSkip = new ArrayList<UsageInfo>();
        MultiMap conflicts = new MultiMap();
        for (PsiElement element : this.myElementsToMove) {
            String newName = this.getNewQName(element);
            if (newName == null) continue;
            UsageInfo[] usages = MoveClassesOrPackagesUtil.findUsages(element, this.mySearchInComments, this.mySearchInNonJavaFiles, newName);
            ArrayList<UsageInfo> infos = new ArrayList<UsageInfo>(Arrays.asList(usages));
            allUsages.addAll(infos);
            if (Comparing.strEqual((String)newName, (String)this.getOldQName(element))) {
                usagesToSkip.addAll(infos);
            }
            if (!(element instanceof PsiPackage)) continue;
            for (PsiDirectory directory : ((PsiPackage)element).getDirectories()) {
                UsageInfo[] dirUsages = MoveClassesOrPackagesUtil.findUsages((PsiElement)directory, this.mySearchInComments, this.mySearchInNonJavaFiles, newName);
                allUsages.addAll(new ArrayList<UsageInfo>(Arrays.asList(dirUsages)));
            }
        }
        this.myMoveDestination.analyzeModuleConflicts(Arrays.asList(this.myElementsToMove), conflicts, allUsages.toArray(new UsageInfo[allUsages.size()]));
        UsageInfo[] usageInfos = allUsages.toArray(new UsageInfo[allUsages.size()]);
        this.detectPackageLocalsMoved(usageInfos, (MultiMap<PsiElement, String>)conflicts);
        this.detectPackageLocalsUsed((MultiMap<PsiElement, String>)conflicts);
        if (!conflicts.isEmpty()) {
            for (PsiElement element : conflicts.keySet()) {
                allUsages.add(new ConflictsUsageInfo(element, conflicts.get((Object)element)));
            }
        }
        allUsages.removeAll(usagesToSkip);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages(allUsages.toArray(new UsageInfo[allUsages.size()]));
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    public List<PsiElement> getElements() {
        return Collections.unmodifiableList(Arrays.asList(this.myElementsToMove));
    }

    public PackageWrapper getTargetPackage() {
        return this.myMoveDestination.getTargetPackage();
    }

    public void setOpenInEditor(boolean openInEditor) {
        this.myOpenInEditor = openInEditor;
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.move";
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElements(this.myElementsToMove);
        return data;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesProcessor", "getAfterData"));
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElements((PsiElement[])this.myTargetPackage.getDirectories());
        data.addElement((PsiElement)JavaPsiFacade.getInstance((Project)this.myProject).findPackage(this.myTargetPackage.getQualifiedName()));
        return data;
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesProcessor", "preprocessUsages"));
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        ArrayList<UsageInfo> filteredUsages = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (usage instanceof ConflictsUsageInfo) {
                ConflictsUsageInfo info = (ConflictsUsageInfo)usage;
                PsiElement element = info.getElement();
                conflicts.putValues((Object)element, info.getConflicts());
                continue;
            }
            filteredUsages.add(usage);
        }
        refUsages.set((Object)filteredUsages.toArray(new UsageInfo[filteredUsages.size()]));
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts, usages);
    }

    private boolean isInsideMoved(PsiElement place) {
        for (PsiElement element : this.myElementsToMove) {
            if (!(element instanceof PsiClass) || !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)place, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void detectPackageLocalsUsed(MultiMap<PsiElement, String> conflicts) {
        PackageLocalsUsageCollector visitor = new PackageLocalsUsageCollector(this.myElementsToMove, this.myTargetPackage, conflicts);
        for (PsiElement element : this.myElementsToMove) {
            if (!(element instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)element;
            aClass.accept((PsiElementVisitor)visitor);
        }
    }

    private void detectPackageLocalsMoved(UsageInfo[] usages, MultiMap<PsiElement, String> conflicts) {
        HashSet<PsiClass> movedClasses = new HashSet<PsiClass>();
        HashMap reportedClassToContainers = new HashMap();
        PackageWrapper aPackage = this.myTargetPackage;
        for (UsageInfo usage : usages) {
            PsiDirectory directory;
            String visibility;
            PsiElement element = usage.getElement();
            if (element == null || !(usage instanceof MoveRenameUsageInfo) || usage instanceof NonCodeUsageInfo || !(((MoveRenameUsageInfo)usage).getReferencedElement() instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)((MoveRenameUsageInfo)usage).getReferencedElement();
            if (!movedClasses.contains(aClass)) {
                movedClasses.add(aClass);
            }
            if (!"packageLocal".equals(visibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)aClass.getModifierList())) || PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class) != null) continue;
            PsiElement container = ConflictsUtil.getContainer(element);
            HashSet<PsiElement> reported = (HashSet<PsiElement>)reportedClassToContainers.get((Object)aClass);
            if (reported == null) {
                reported = new HashSet<PsiElement>();
                reportedClassToContainers.put((Object)aClass, reported);
            }
            if (reported.contains(container)) continue;
            reported.add(container);
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null || this.isInsideMoved(element) || (directory = containingFile.getContainingDirectory()) == null) continue;
            PsiPackage usagePackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (aPackage == null || usagePackage == null || aPackage.equalToPackage(usagePackage)) continue;
            String message = RefactoringBundle.message((String)"a.package.local.class.0.will.no.longer.be.accessible.from.1", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)aClass.getName()), RefactoringUIUtil.getDescription(container, true)});
            conflicts.putValue((Object)aClass, (Object)message);
        }
        MyClassInstanceReferenceVisitor instanceReferenceVisitor = new MyClassInstanceReferenceVisitor(conflicts);
        for (PsiClass aClass : movedClasses) {
            String visibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)aClass.getModifierList());
            if ("packageLocal".equals(visibility)) {
                MoveClassesOrPackagesProcessor.findInstancesOfPackageLocal(aClass, usages, instanceReferenceVisitor);
                continue;
            }
            MoveClassesOrPackagesProcessor.findPublicClassConflicts(aClass, instanceReferenceVisitor);
        }
    }

    private static void findPublicClassConflicts(PsiClass aClass, final MyClassInstanceReferenceVisitor instanceReferenceVisitor) {
        NonPublicClassMemberWrappersSet members = new NonPublicClassMemberWrappersSet();
        members.addElements((PsiMember[])aClass.getFields());
        members.addElements((PsiMember[])aClass.getMethods());
        members.addElements((PsiMember[])aClass.getInnerClasses());
        final RefactoringUtil.IsDescendantOf isDescendantOf = new RefactoringUtil.IsDescendantOf(aClass);
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(aClass.getContainingFile().getContainingDirectory());
        GlobalSearchScope packageScope = aPackage == null ? aClass.getResolveScope() : PackageScope.packageScopeWithoutLibraries((PsiPackage)aPackage, (boolean)false);
        for (final ClassMemberWrapper memberWrapper : members) {
            ReferencesSearch.search((PsiElement)memberWrapper.getMember(), (SearchScope)packageScope, (boolean)false).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference reference) {
                    PsiElement element = reference.getElement();
                    if (element instanceof PsiReferenceExpression) {
                        PsiReferenceExpression expression = (PsiReferenceExpression)element;
                        PsiExpression qualifierExpression = expression.getQualifierExpression();
                        if (qualifierExpression != null) {
                            PsiClass resolvedTypeClass;
                            PsiType type = qualifierExpression.getType();
                            if (type != null && isDescendantOf.value(resolvedTypeClass = PsiUtil.resolveClassInType((PsiType)type))) {
                                instanceReferenceVisitor.visitMemberReference(memberWrapper.getMember(), expression, isDescendantOf);
                            }
                        } else {
                            instanceReferenceVisitor.visitMemberReference(memberWrapper.getMember(), expression, isDescendantOf);
                        }
                    }
                    return true;
                }
            });
        }
    }

    private static void findInstancesOfPackageLocal(final PsiClass aClass, final UsageInfo[] usages, MyClassInstanceReferenceVisitor instanceReferenceVisitor) {
        ClassReferenceScanner referenceScanner = new ClassReferenceScanner(aClass){

            @Override
            public PsiReference[] findReferences() {
                ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
                for (UsageInfo usage : usages) {
                    PsiReference reference;
                    if (!(usage instanceof MoveRenameUsageInfo) || ((MoveRenameUsageInfo)usage).getReferencedElement() != aClass || (reference = usage.getReference()) == null) continue;
                    result2.add(reference);
                }
                return result2.toArray(new PsiReference[result2.size()]);
            }
        };
        referenceScanner.processReferences(new ClassInstanceScanner(aClass, instanceReferenceVisitor));
    }

    @Nullable
    private String getNewQName(PsiElement element) {
        String qualifiedName = this.myTargetPackage.getQualifiedName();
        if (element instanceof PsiClass) {
            return StringUtil.getQualifiedName((String)qualifiedName, (String)((PsiClass)element).getName());
        }
        if (element instanceof PsiPackage) {
            return StringUtil.getQualifiedName((String)qualifiedName, (String)((PsiPackage)element).getName());
        }
        LOG.assertTrue(false);
        return null;
    }

    @Nullable
    private String getOldQName(PsiElement element) {
        if (element instanceof PsiClass) {
            return ((PsiClass)element).getQualifiedName();
        }
        if (element instanceof PsiPackage) {
            return ((PsiPackage)element).getQualifiedName();
        }
        LOG.assertTrue(false);
        return null;
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesProcessor", "refreshElements"));
        }
        LOG.assertTrue(elements.length == this.myElementsToMove.length);
        System.arraycopy(elements, 0, this.myElementsToMove, 0, elements.length);
    }

    @Override
    protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesProcessor", "isPreviewUsages"));
        }
        if (UsageViewUtil.reportNonRegularUsages(usages, this.myProject)) {
            return true;
        }
        return super.isPreviewUsages(usages);
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesProcessor", "performRefactoring"));
        }
        try {
            PsiClass psiClass;
            HashMap allClasses = new HashMap();
            for (PsiElement element : this.myElementsToMove) {
                if (!(element instanceof PsiClass) || allClasses.containsKey(psiClass = (PsiClass)element)) continue;
                for (MoveAllClassesInFileHandler fileHandler : (MoveAllClassesInFileHandler[])Extensions.getExtensions(MoveAllClassesInFileHandler.EP_NAME)) {
                    fileHandler.processMoveAllClassesInFile((Map<PsiClass, Boolean>)allClasses, psiClass, this.myElementsToMove);
                }
            }
            HashMap oldToNewElementsMapping = new HashMap();
            for (int idx = 0; idx < this.myElementsToMove.length; ++idx) {
                PsiPackage newElement;
                PsiElement element = this.myElementsToMove[idx];
                RefactoringElementListener elementListener = this.getTransaction().getElementListener(element);
                if (element instanceof PsiPackage) {
                    PsiDirectory[] directories = ((PsiPackage)element).getDirectories();
                    newElement = MoveClassesOrPackagesUtil.doMovePackage((PsiPackage)element, this.myMoveDestination);
                    LOG.assertTrue(newElement != null, (Object)element);
                    oldToNewElementsMapping.put(element, newElement);
                    int i = 0;
                    PsiDirectory[] newDirectories = newElement.getDirectories();
                    if (newDirectories.length == 1) {
                        for (PsiDirectory directory : directories) {
                            oldToNewElementsMapping.put(directory, newDirectories[0]);
                        }
                    } else {
                        for (PsiDirectory directory : directories) {
                            if (this.myMoveDestination.verify(directory) != null) continue;
                            oldToNewElementsMapping.put(directory, newDirectories[i++]);
                        }
                    }
                    element = newElement;
                } else if (element instanceof PsiClass) {
                    psiClass = (PsiClass)element;
                    MoveClassesOrPackagesUtil.prepareMoveClass(psiClass);
                    newElement = MoveClassesOrPackagesUtil.doMoveClass(psiClass, this.myMoveDestination.getTargetDirectory(element.getContainingFile()), (Boolean)allClasses.get(psiClass));
                    oldToNewElementsMapping.put(element, newElement);
                    element = newElement;
                } else {
                    LOG.error("Unexpected element to move: " + element);
                }
                elementListener.elementMoved(element);
                this.myElementsToMove[idx] = element;
            }
            for (PsiElement element : this.myElementsToMove) {
                if (!(element instanceof PsiClass)) continue;
                MoveClassesOrPackagesUtil.finishMoveClass((PsiClass)element);
            }
            this.myNonCodeUsages = CommonMoveUtil.retargetUsages(usages, (Map<PsiElement, PsiElement>)oldToNewElementsMapping);
            if (this.myOpenInEditor) {
                EditorHelper.openFilesInEditor((PsiElement[])this.myElementsToMove);
            }
        }
        catch (IncorrectOperationException e) {
            this.myNonCodeUsages = new NonCodeUsageInfo[0];
            RefactoringUIUtil.processIncorrectOperation(this.myProject, e);
        }
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        RenameUtil.renameNonCodeUsages(this.myProject, this.myNonCodeUsages);
        if (this.myMoveCallback != null) {
            if (this.myMoveCallback instanceof MoveClassesOrPackagesCallback) {
                ((MoveClassesOrPackagesCallback)this.myMoveCallback).classesOrPackagesMoved(this.myMoveDestination);
            }
            this.myMoveCallback.refactoringCompleted();
        }
    }

    @Override
    protected String getCommandName() {
        String elements = RefactoringUIUtil.calculatePsiElementDescriptionList(this.myElementsToMove);
        String target = this.myTargetPackage.getQualifiedName();
        return RefactoringBundle.message((String)"move.classes.command", (Object[])new Object[]{elements, target});
    }

    private static class NonPublicClassMemberWrappersSet
    extends HashSet<ClassMemberWrapper> {
        private NonPublicClassMemberWrappersSet() {
        }

        public void addElement(PsiMember member) {
            PsiNamedElement namedElement = (PsiNamedElement)member;
            if (member.hasModifierProperty("public")) {
                return;
            }
            if (member.hasModifierProperty("private")) {
                return;
            }
            this.add(new ClassMemberWrapper(namedElement));
        }

        public void addElements(PsiMember[] members) {
            for (PsiMember member : members) {
                this.addElement(member);
            }
        }
    }

    private class MyClassInstanceReferenceVisitor
    implements ClassInstanceScanner.ClassInstanceReferenceVisitor {
        private final MultiMap<PsiElement, String> myConflicts;
        private final HashMap<PsiModifierListOwner, HashSet<PsiElement>> myReportedElementToContainer = new HashMap();
        private final HashMap<PsiClass, RefactoringUtil.IsDescendantOf> myIsDescendantOfCache = new HashMap();

        public MyClassInstanceReferenceVisitor(MultiMap<PsiElement, String> conflicts) {
            this.myConflicts = conflicts;
        }

        @Override
        public void visitQualifier(PsiReferenceExpression qualified, PsiExpression instanceRef, PsiElement referencedInstance) {
            PsiElement resolved = qualified.resolve();
            if (resolved instanceof PsiMember) {
                PsiMember member = (PsiMember)resolved;
                PsiClass containingClass = member.getContainingClass();
                RefactoringUtil.IsDescendantOf isDescendantOf = (RefactoringUtil.IsDescendantOf)this.myIsDescendantOfCache.get((Object)containingClass);
                if (isDescendantOf == null) {
                    isDescendantOf = new RefactoringUtil.IsDescendantOf(containingClass);
                    this.myIsDescendantOfCache.put((Object)containingClass, (Object)isDescendantOf);
                }
                this.visitMemberReference((PsiModifierListOwner)member, qualified, isDescendantOf);
            }
        }

        private synchronized void visitMemberReference(PsiModifierListOwner member, PsiReferenceExpression qualified, RefactoringUtil.IsDescendantOf descendantOf) {
            if (member.hasModifierProperty("packageLocal")) {
                this.visitPackageLocalMemberReference((PsiJavaCodeReferenceElement)qualified, member);
            } else if (member.hasModifierProperty("protected")) {
                PsiExpression qualifier = qualified.getQualifierExpression();
                if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                    this.visitPackageLocalMemberReference((PsiJavaCodeReferenceElement)qualified, member);
                } else if (!this.isInInheritor(qualified, descendantOf)) {
                    this.visitPackageLocalMemberReference((PsiJavaCodeReferenceElement)qualified, member);
                }
            }
        }

        private boolean isInInheritor(PsiReferenceExpression qualified, RefactoringUtil.IsDescendantOf descendantOf) {
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)qualified, PsiClass.class);
            while (aClass != null) {
                if (descendantOf.value(aClass)) {
                    return true;
                }
                aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
            }
            return false;
        }

        private void visitPackageLocalMemberReference(PsiJavaCodeReferenceElement qualified, PsiModifierListOwner member) {
            PsiElement container = ConflictsUtil.getContainer((PsiElement)qualified);
            HashSet<PsiElement> reportedContainers = (HashSet<PsiElement>)this.myReportedElementToContainer.get((Object)member);
            if (reportedContainers == null) {
                reportedContainers = new HashSet<PsiElement>();
                this.myReportedElementToContainer.put((Object)member, reportedContainers);
            }
            if (!reportedContainers.contains(container)) {
                PsiDirectory directory;
                PsiFile containingFile;
                reportedContainers.add(container);
                if (!MoveClassesOrPackagesProcessor.this.isInsideMoved(container) && (containingFile = container.getContainingFile()) != null && (directory = containingFile.getContainingDirectory()) != null) {
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
                    if (!MoveClassesOrPackagesProcessor.this.myTargetPackage.equalToPackage(aPackage)) {
                        String message = RefactoringBundle.message((String)"0.will.be.inaccessible.from.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, true), RefactoringUIUtil.getDescription(container, true)});
                        this.myConflicts.putValue((Object)member, (Object)CommonRefactoringUtil.capitalize((String)message));
                    }
                }
            }
        }

        @Override
        public void visitTypeCast(PsiTypeCastExpression typeCastExpression, PsiExpression instanceRef, PsiElement referencedInstance) {
        }

        @Override
        public void visitReadUsage(PsiExpression instanceRef, PsiType expectedType, PsiElement referencedInstance) {
        }

        @Override
        public void visitWriteUsage(PsiExpression instanceRef, PsiType assignedType, PsiElement referencedInstance) {
        }
    }

    static class ClassMemberWrapper {
        final PsiNamedElement myElement;
        final PsiModifierListOwner myMember;

        public ClassMemberWrapper(PsiNamedElement element) {
            this.myElement = element;
            this.myMember = (PsiModifierListOwner)element;
        }

        PsiModifierListOwner getMember() {
            return this.myMember;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassMemberWrapper)) {
                return false;
            }
            ClassMemberWrapper wrapper = (ClassMemberWrapper)o;
            if (this.myElement instanceof PsiMethod) {
                return wrapper.myElement instanceof PsiMethod && MethodSignatureUtil.areSignaturesEqual((PsiMethod)((PsiMethod)this.myElement), (PsiMethod)((PsiMethod)wrapper.myElement));
            }
            return Comparing.equal((String)this.myElement.getName(), (String)wrapper.myElement.getName());
        }

        public int hashCode() {
            String name = this.myElement.getName();
            if (name != null) {
                return name.hashCode();
            }
            return 0;
        }
    }

    protected static class ConflictsUsageInfo
    extends UsageInfo {
        private final Collection<String> myConflicts;

        public ConflictsUsageInfo(PsiElement pseudoElement, Collection<String> conflicts) {
            super(pseudoElement);
            this.myConflicts = conflicts;
        }

        public Collection<String> getConflicts() {
            return this.myConflicts;
        }
    }
}

