/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableTypeFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.ChangeVariableTypeQuickFixProvider;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeMigrationVariableTypeFixProvider
implements ChangeVariableTypeQuickFixProvider {
    private static final Logger LOG1 = Logger.getInstance((String)("#" + TypeMigrationVariableTypeFixProvider.class.getName()));

    @NotNull
    public IntentionAction[] getFixes(@NotNull PsiVariable variable, @NotNull PsiType toReturn) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider", "getFixes"));
        }
        if (toReturn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toReturn", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider", "getFixes"));
        }
        IntentionAction[] intentionActionArray = new IntentionAction[]{new VariableTypeFix(variable, toReturn){

            @Override
            @NotNull
            public String getText() {
                String string = "Migrate '" + this.myName + "' type to '" + this.getReturnType().getCanonicalText() + "'";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider$1", "getText"));
                }
                return string;
            }

            @Override
            public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider$1", "invoke"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider$1", "invoke"));
                }
                if (startElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider$1", "invoke"));
                }
                if (endElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider$1", "invoke"));
                }
                PsiVariable myVariable = (PsiVariable)startElement;
                if (!FileModificationService.getInstance().prepareFileForWrite(myVariable.getContainingFile())) {
                    return;
                }
                try {
                    myVariable.normalizeDeclaration();
                    TypeMigrationRules rules = new TypeMigrationRules(TypeMigrationLabeler.getElementType((PsiElement)myVariable));
                    rules.setMigrationRootType(this.getReturnType());
                    rules.setBoundScope((SearchScope)GlobalSearchScope.projectScope((Project)project));
                    TypeMigrationProcessor.runHighlightingTypeMigration(project, editor, rules, (PsiElement)myVariable);
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)myVariable);
                    UndoUtil.markPsiFileForUndo((PsiFile)file);
                }
                catch (IncorrectOperationException e) {
                    LOG1.error((Throwable)e);
                }
            }

            @Override
            public boolean startInWriteAction() {
                return true;
            }
        }};
        if (intentionActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider", "getFixes"));
        }
        return intentionActionArray;
    }
}

