/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public class XmlTextTokenizer
extends Tokenizer<XmlText> {
    @Override
    public void tokenize(@NotNull XmlText element, TokenConsumer consumer) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/tokenizer/XmlTextTokenizer", "tokenize"));
        }
        if (element instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)element)) {
            return;
        }
        XmlTextTokenizer.processChildren((PsiElement)element, consumer);
    }

    private static void processChildren(PsiElement element, TokenConsumer consumer) {
        PsiElement[] children2;
        for (PsiElement child : children2 = element.getChildren()) {
            IElementType elementType = child.getNode().getElementType();
            if (elementType == XmlTokenType.XML_DATA_CHARACTERS) {
                consumer.consumeToken(child, PlainTextSplitter.getInstance());
                continue;
            }
            if (elementType != XmlElementType.XML_CDATA) continue;
            XmlTextTokenizer.processChildren(child, consumer);
        }
    }
}

