/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.filters;

import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;

public class TypedSymbolNodeFilter
extends JavaElementVisitor
implements NodeFilter {
    private boolean result;

    public void visitMethod(PsiMethod psiMethod) {
        this.result = psiMethod.hasTypeParameters();
    }

    public void visitClass(PsiClass psiClass) {
        this.result = psiClass.hasTypeParameters();
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement psiJavaCodeReferenceElement) {
        this.result = psiJavaCodeReferenceElement.getParameterList().getTypeParameterElements().length > 0;
    }

    public void visitTypeParameter(PsiTypeParameter parameter) {
    }

    public static NodeFilter getInstance() {
        return NodeFilterHolder.instance;
    }

    private TypedSymbolNodeFilter() {
    }

    @Override
    public boolean accepts(PsiElement element) {
        this.result = false;
        if (element != null) {
            element.accept((PsiElementVisitor)this);
        }
        return this.result;
    }

    private static class NodeFilterHolder {
        private static final NodeFilter instance = new TypedSymbolNodeFilter();

        private NodeFilterHolder() {
        }
    }
}

