/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.fixtures.LightPlatformCodeInsightFixtureTestCase;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public abstract class FileEditorManagerTestCase
extends LightPlatformCodeInsightFixtureTestCase {
    protected FileEditorManagerImpl myManager;
    private FileEditorManager myOldManager;
    private Set<DockContainer> myOldDockContainers;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        DockManager dockManager = DockManager.getInstance((Project)this.getProject());
        this.myOldDockContainers = dockManager.getContainers();
        this.myManager = new FileEditorManagerImpl(this.getProject(), dockManager, EditorHistoryManager.getInstance(this.getProject()));
        this.myOldManager = ((ComponentManagerImpl)this.getProject()).registerComponentInstance(FileEditorManager.class, this.myManager);
        ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).clearSelectedProviders();
    }

    @Override
    protected void tearDown() throws Exception {
        for (DockContainer container : DockManager.getInstance((Project)this.getProject()).getContainers()) {
            if (this.myOldDockContainers.contains(container)) continue;
            Disposer.dispose((Disposable)container);
        }
        this.myOldDockContainers = null;
        ((ComponentManagerImpl)this.getProject()).registerComponentInstance(FileEditorManager.class, this.myOldManager);
        this.myManager.closeAllFiles();
        ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).clearSelectedProviders();
        super.tearDown();
    }

    @Override
    protected boolean isWriteActionRequired() {
        return false;
    }

    protected VirtualFile getFile(String path) {
        String fullPath = this.getTestDataPath() + path;
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath);
        FileEditorManagerTestCase.assertNotNull((String)("Can't find " + fullPath), (Object)file);
        return file;
    }

    protected void openFiles(@NotNull String femSerialisedText) throws IOException, JDOMException, InterruptedException, ExecutionException {
        if (femSerialisedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "femSerialisedText", "com/intellij/testFramework/FileEditorManagerTestCase", "openFiles"));
        }
        Document document = JDOMUtil.loadDocument((CharSequence)femSerialisedText);
        Element rootElement = document.getRootElement();
        ExpandMacroToPathMap map = new ExpandMacroToPathMap();
        map.addMacroExpand("PROJECT_DIR", this.getTestDataPath());
        map.substitute(rootElement, true, true);
        this.myManager.readExternal(rootElement);
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                FileEditorManagerTestCase.this.myManager.getMainSplitters().openFiles();
            }
        });
        while (true) {
            try {
                future2.get(100L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException e) {
                UIUtil.dispatchAllInvocationEvents();
                continue;
            }
            break;
        }
    }
}

