/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class HighlightTestInfo
implements Disposable {
    @NotNull
    protected final String[] filePaths;
    protected boolean checkWarnings;
    protected boolean checkInfos;
    protected boolean checkSymbolNames;
    protected boolean checkWeakWarnings;
    protected String projectRoot;
    private boolean tested;
    private final String myPlace;

    public HighlightTestInfo(@NotNull Disposable parentDisposable, String ... filePaths) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/testFramework/HighlightTestInfo", "<init>"));
        }
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/testFramework/HighlightTestInfo", "<init>"));
        }
        this.filePaths = filePaths;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myPlace = parentDisposable.toString();
    }

    public HighlightTestInfo checkWarnings() {
        this.checkWarnings = true;
        return this;
    }

    public HighlightTestInfo checkWeakWarnings() {
        this.checkWeakWarnings = true;
        return this;
    }

    public HighlightTestInfo checkInfos() {
        this.checkInfos = true;
        return this;
    }

    public HighlightTestInfo checkSymbolNames() {
        this.checkSymbolNames = true;
        return this;
    }

    public HighlightTestInfo projectRoot(@NonNls @NotNull String root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/testFramework/HighlightTestInfo", "projectRoot"));
        }
        this.projectRoot = root;
        return this;
    }

    public HighlightTestInfo test() {
        try {
            this.doTest();
            HighlightTestInfo highlightTestInfo = this;
            return highlightTestInfo;
        }
        finally {
            this.tested = true;
            Disposer.dispose((Disposable)this);
        }
    }

    public void dispose() {
        assert (this.tested) : "You must call HighlightTestInfo.test() in " + this.myPlace;
    }

    protected abstract HighlightTestInfo doTest();
}

