/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class GradientViewport
extends JViewport {
    private final Insets myInsets;
    private final boolean myAlways;

    public GradientViewport(Component view, Insets insets, boolean forScrollBars) {
        this.myInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        this.myAlways = forScrollBars;
        this.setView(view);
    }

    protected Component getHeader() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g = g.create();
        try {
            Component view = this.getView();
            Color background = view == null ? null : view.getBackground();
            Component header = this.getHeader();
            if (header != null) {
                header.setBounds(0, 0, this.getWidth(), header.getPreferredSize().height);
                if (background != null) {
                    g.setColor(background);
                    g.fillRect(header.getX(), header.getY(), header.getWidth(), header.getHeight());
                }
            }
            if (g instanceof Graphics2D && background != null && !Registry.is((String)"ui.no.bangs.and.whistles")) {
                this.paintGradient((Graphics2D)g, background, 0, header == null ? 0 : header.getHeight());
            }
            if (header != null) {
                header.paint(g);
            }
        }
        finally {
            g.dispose();
        }
    }

    private void paintGradient(Graphics2D g2d, Color background, int x1, int y1) {
        Component view = this.getView();
        if (background != null && view != null) {
            Container parent;
            int y3;
            int x3;
            int x2 = x1;
            int x4 = x3 = this.getWidth() - x2;
            int y2 = y1;
            int y4 = y3 = this.getHeight() - y2;
            if (this.myInsets.left > 0 && view.getX() < 0) {
                x2 += this.myInsets.left;
            }
            if (this.myInsets.top > 0 && view.getY() < 0) {
                y2 += this.myInsets.top;
            }
            if (this.myInsets.right > 0 && view.getX() > this.getWidth() - view.getWidth()) {
                x3 -= this.myInsets.right;
            }
            if (this.myInsets.bottom > 0 && view.getY() > this.getHeight() - view.getHeight()) {
                y3 -= this.myInsets.bottom;
            }
            Container container = parent = this.myAlways ? null : this.getParent();
            if (parent instanceof JScrollPane) {
                JScrollBar hBar;
                JScrollPane pane = (JScrollPane)parent;
                JScrollBar vBar = pane.getVerticalScrollBar();
                if (vBar != null && vBar.isVisible()) {
                    if (vBar.getX() < this.getX()) {
                        x2 = x1;
                    } else {
                        x3 = x4;
                    }
                }
                if ((hBar = pane.getHorizontalScrollBar()) != null && hBar.isVisible()) {
                    if (hBar.getY() < this.getY()) {
                        y2 = y1;
                    } else {
                        y3 = y4;
                    }
                }
            }
            Color transparent = ColorUtil.toAlpha((Color)background, (int)0);
            if (x1 != x2) {
                g2d.setPaint(new GradientPaint(x1, y1, background, x2, y1, transparent));
                g2d.fillPolygon(new int[]{x1, x2, x2, x1}, new int[]{y1, y2, y3, y4}, 4);
            }
            if (x3 != x4) {
                g2d.setPaint(new GradientPaint(x3, y1, transparent, x4, y1, background));
                g2d.fillPolygon(new int[]{x4, x3, x3, x4}, new int[]{y1, y2, y3, y4}, 4);
            }
            if (y1 != y2) {
                g2d.setPaint(new GradientPaint(x1, y1, background, x1, y2, transparent));
                g2d.fillPolygon(new int[]{x1, x2, x3, x4}, new int[]{y1, y2, y2, y1}, 4);
            }
            if (y3 != y4) {
                g2d.setPaint(new GradientPaint(x1, y3, transparent, x1, y4, background));
                g2d.fillPolygon(new int[]{x1, x2, x3, x4}, new int[]{y4, y3, y3, y4}, 4);
            }
        }
    }
}

