/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content;

import com.intellij.openapi.project.Project;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedPaneContentUI;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.ui.content.impl.ContentManagerImpl;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ContentFactoryImpl
implements ContentFactory {
    @NotNull
    public ContentImpl createContent(JComponent component, String displayName, boolean isLockable) {
        ContentImpl contentImpl = new ContentImpl(component, displayName, isLockable);
        if (contentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/ContentFactoryImpl", "createContent"));
        }
        return contentImpl;
    }

    @NotNull
    public ContentManagerImpl createContentManager(@NotNull ContentUI contentUI, boolean canCloseContents, @NotNull Project project) {
        if (contentUI == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentUI", "com/intellij/ui/content/ContentFactoryImpl", "createContentManager"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/content/ContentFactoryImpl", "createContentManager"));
        }
        ContentManagerImpl contentManagerImpl = new ContentManagerImpl(contentUI, canCloseContents, project);
        if (contentManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/ContentFactoryImpl", "createContentManager"));
        }
        return contentManagerImpl;
    }

    @NotNull
    public ContentManager createContentManager(boolean canCloseContents, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/content/ContentFactoryImpl", "createContentManager"));
        }
        ContentManagerImpl contentManagerImpl = this.createContentManager(new TabbedPaneContentUI(), canCloseContents, project);
        if (contentManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/ContentFactoryImpl", "createContentManager"));
        }
        return contentManagerImpl;
    }
}

