/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.ui.mac.JDK7WindowReorderingWorkaround;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacFileChooserDialogImpl
implements PathChooserDialog {
    private static final int OK = 1;
    private static final Map<ID, MacFileChooserDialogImpl> ourImplMap = new HashMap<ID, MacFileChooserDialogImpl>(2);
    private final FileChooserDescriptor myChooserDescriptor;
    private final Project myProject;
    private ModalityState myModalityState;
    private Consumer<List<VirtualFile>> myCallback;
    private static final Callback SHOULD_ENABLE_CALLBACK = new Callback(){

        public boolean callback(ID self, String selector, ID panel, ID url) {
            try {
                return MacFileChooserDialogImpl.checkFile(self, url, true);
            }
            catch (Exception e) {
                return false;
            }
        }
    };
    private static final Callback VALIDATE_URL_CALLBACK = new Callback(){

        public boolean callback(ID self, String selector, ID panel, ID url, ID outError) {
            try {
                return MacFileChooserDialogImpl.checkFile(self, url, false);
            }
            catch (Exception e) {
                if (!ID.NIL.equals((Object)outError)) {
                    ID domain = Foundation.nsString((String)ApplicationNamesInfo.getInstance().getProductName());
                    ID dict = Foundation.createDict((String[])new String[]{"NSLocalizedDescription"}, (Object[])new Object[]{e.getMessage()});
                    ID error = Foundation.invoke((String)"NSError", (String)"errorWithDomain:code:userInfo:", (Object[])new Object[]{domain, 100, dict});
                    new Pointer(outError.longValue()).setLong(0L, error.longValue());
                }
                return false;
            }
        }
    };
    private static final Callback OPEN_PANEL_DID_END = new Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callback(ID self, String selector, ID openPanelDidEnd, ID returnCode, ID contextInfo) {
            final MacFileChooserDialogImpl impl = (MacFileChooserDialogImpl)ourImplMap.remove(self);
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IdeMenuBar bar = MacFileChooserDialogImpl.getMenuBar();
                        if (bar != null) {
                            bar.enableUpdates();
                        }
                    }
                });
                final List resultPaths = MacFileChooserDialogImpl.processResult(returnCode, openPanelDidEnd);
                if (resultPaths.size() > 0) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_MODAL, (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    List files = MacFileChooserDialogImpl.getChosenFiles(resultPaths);
                                    if (files.size() > 0) {
                                        FileChooserUtil.setLastOpenedFile(impl.myProject, (VirtualFile)files.get(files.size() - 1));
                                        impl.myCallback.consume((Object)files);
                                    }
                                }
                            });
                        }
                    }, impl.myModalityState);
                } else if (impl.myCallback instanceof FileChooser.FileChooserConsumer) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((FileChooser.FileChooserConsumer)impl.myCallback).cancelled();
                        }
                    }, impl.myModalityState);
                }
            }
            catch (Throwable throwable) {
                MacFileChooserDialogImpl.invoke(contextInfo, "setDelegate:", new Object[]{ID.NIL});
                Foundation.cfRelease((ID[])new ID[]{self});
                Foundation.cfRelease((ID[])new ID[]{contextInfo});
                JDK7WindowReorderingWorkaround.enableReordering();
                throw throwable;
            }
            MacFileChooserDialogImpl.invoke(contextInfo, "setDelegate:", new Object[]{ID.NIL});
            Foundation.cfRelease((ID[])new ID[]{self});
            Foundation.cfRelease((ID[])new ID[]{contextInfo});
            JDK7WindowReorderingWorkaround.enableReordering();
        }
    };
    private static final Callback MAIN_THREAD_RUNNABLE = new Callback(){

        public void callback(ID self, String selector, ID toSelect) {
            Window activeWindow;
            String toSelectPath;
            boolean showHidden;
            ID nsOpenPanel = Foundation.getObjcClass((String)"NSOpenPanel");
            ID chooser = MacFileChooserDialogImpl.invoke(nsOpenPanel, "openPanel", new Object[0]);
            Foundation.cfRetain((ID)chooser);
            FileChooserDescriptor chooserDescriptor = ((MacFileChooserDialogImpl)ourImplMap.get(self)).myChooserDescriptor;
            MacFileChooserDialogImpl.invoke(chooser, "setPrompt:", new Object[]{Foundation.nsString((String)"Choose")});
            MacFileChooserDialogImpl.invoke(chooser, "setCanChooseFiles:", new Object[]{chooserDescriptor.isChooseFiles() || chooserDescriptor.isChooseJars()});
            MacFileChooserDialogImpl.invoke(chooser, "setCanChooseDirectories:", new Object[]{chooserDescriptor.isChooseFolders()});
            MacFileChooserDialogImpl.invoke(chooser, "setAllowsMultipleSelection:", new Object[]{chooserDescriptor.isChooseMultiple()});
            MacFileChooserDialogImpl.invoke(chooser, "setTreatsFilePackagesAsDirectories:", new Object[]{chooserDescriptor.isChooseFolders()});
            MacFileChooserDialogImpl.invoke(chooser, "setResolvesAliases:", new Object[]{false});
            String description = chooserDescriptor.getDescription();
            if (!StringUtil.isEmpty((String)description)) {
                MacFileChooserDialogImpl.invoke(chooser, "setMessage:", new Object[]{Foundation.nsString((String)StringUtil.removeHtmlTags((String)description))});
            }
            if (Foundation.isClassRespondsToSelector((ID)nsOpenPanel, (Pointer)Foundation.createSelector((String)"setCanCreateDirectories:"))) {
                MacFileChooserDialogImpl.invoke(chooser, "setCanCreateDirectories:", new Object[]{true});
            } else if (Foundation.isClassRespondsToSelector((ID)nsOpenPanel, (Pointer)Foundation.createSelector((String)"_setIncludeNewFolderButton:"))) {
                MacFileChooserDialogImpl.invoke(chooser, "_setIncludeNewFolderButton:", new Object[]{true});
            }
            boolean bl = showHidden = chooserDescriptor.isShowHiddenFiles() || Registry.is((String)"ide.mac.file.chooser.show.hidden.files");
            if (showHidden && Foundation.isClassRespondsToSelector((ID)nsOpenPanel, (Pointer)Foundation.createSelector((String)"setShowsHiddenFiles:"))) {
                MacFileChooserDialogImpl.invoke(chooser, "setShowsHiddenFiles:", new Object[]{true});
            }
            MacFileChooserDialogImpl.invoke(chooser, "setDelegate:", new Object[]{self});
            ID directory = null;
            ID file = null;
            String string = toSelectPath = toSelect == null || toSelect.intValue() == 0 ? null : Foundation.toStringViaUTF8((ID)toSelect);
            if (toSelectPath != null) {
                File toSelectFile = new File(toSelectPath);
                if (toSelectFile.isDirectory()) {
                    directory = toSelect;
                } else if (toSelectFile.isFile()) {
                    directory = Foundation.nsString((String)toSelectFile.getParent());
                    file = Foundation.nsString((String)toSelectFile.getName());
                }
            }
            ID types = null;
            if (!chooserDescriptor.isChooseFiles() && chooserDescriptor.isChooseJars()) {
                types = MacFileChooserDialogImpl.invoke("NSArray", "arrayWithObjects:", new Object[]{Foundation.nsString((String)"jar"), Foundation.nsString((String)"zip"), null});
            }
            if ((activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) != null) {
                String activeWindowTitle = null;
                if (activeWindow instanceof Frame) {
                    activeWindowTitle = ((Frame)activeWindow).getTitle();
                } else if (activeWindow instanceof JDialog) {
                    activeWindowTitle = ((JDialog)activeWindow).getTitle();
                }
                ID focusedWindow = MacUtil.findWindowForTitle((String)activeWindowTitle);
                if (focusedWindow != null) {
                    MacFileChooserDialogImpl.invoke(chooser, "beginSheetForDirectory:file:types:modalForWindow:modalDelegate:didEndSelector:contextInfo:", new Object[]{directory, file, types, focusedWindow, self, Foundation.createSelector((String)"openPanelDidEnd:returnCode:contextInfo:"), chooser});
                }
            }
        }
    };

    private static boolean checkFile(@NotNull ID self, ID url, boolean quickCheck) throws Exception {
        if (self == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "self", "com/intellij/ui/mac/MacFileChooserDialogImpl", "checkFile"));
        }
        MacFileChooserDialogImpl impl = ourImplMap.get(self);
        if (impl == null) {
            return true;
        }
        if (url == null || url.intValue() == 0) {
            return false;
        }
        ID filename = Foundation.invoke((ID)url, (String)"path", (Object[])new Object[0]);
        String path = Foundation.toStringViaUTF8((ID)filename);
        if (path == null) {
            return false;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null || quickCheck && file.isDirectory()) {
            return true;
        }
        if (!impl.myChooserDescriptor.isFileSelectable(file)) {
            return false;
        }
        if (!quickCheck) {
            VirtualFile[] files = new VirtualFile[]{file};
            impl.myChooserDescriptor.validateSelectedFiles(files);
        }
        return true;
    }

    @NotNull
    private static List<String> processResult(ID result2, ID panel) {
        ArrayList<String> resultPaths = new ArrayList<String>();
        if (result2 != null && 1 == result2.intValue()) {
            ID url;
            ID fileNamesArray = MacFileChooserDialogImpl.invoke(panel, "URLs", new Object[0]);
            ID enumerator = MacFileChooserDialogImpl.invoke(fileNamesArray, "objectEnumerator", new Object[0]);
            while ((url = MacFileChooserDialogImpl.invoke(enumerator, "nextObject", new Object[0])) != null && 0 != url.intValue()) {
                ID filename = MacFileChooserDialogImpl.invoke(url, "path", new Object[0]);
                String path = Foundation.toStringViaUTF8((ID)filename);
                if (path == null) continue;
                resultPaths.add(path);
            }
        }
        ArrayList<String> arrayList = resultPaths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/mac/MacFileChooserDialogImpl", "processResult"));
        }
        return arrayList;
    }

    @NotNull
    private static List<VirtualFile> getChosenFiles(List<String> paths) {
        if (ContainerUtil.isEmpty(paths)) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/mac/MacFileChooserDialogImpl", "getChosenFiles"));
            }
            return list;
        }
        LocalFileSystem fs = LocalFileSystem.getInstance();
        ArrayList files = ContainerUtil.newArrayListWithCapacity((int)paths.size());
        for (String path : paths) {
            String vfsPath = FileUtil.toSystemIndependentName((String)path);
            VirtualFile file = fs.refreshAndFindFileByPath(vfsPath);
            if (file == null || !file.isValid()) continue;
            files.add(file);
        }
        ArrayList arrayList = files;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/mac/MacFileChooserDialogImpl", "getChosenFiles"));
        }
        return arrayList;
    }

    private static void addFoundationMethod(@NotNull ID delegate, @NotNull String selector, @NotNull Callback callback, @NotNull String types) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/ui/mac/MacFileChooserDialogImpl", "addFoundationMethod"));
        }
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/ui/mac/MacFileChooserDialogImpl", "addFoundationMethod"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/ui/mac/MacFileChooserDialogImpl", "addFoundationMethod"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/ui/mac/MacFileChooserDialogImpl", "addFoundationMethod"));
        }
        if (!Foundation.addMethod((ID)delegate, (Pointer)Foundation.createSelector((String)selector), (Callback)callback, (String)types)) {
            throw new RuntimeException("Unable to add method " + selector + " to objective-c delegate class!");
        }
    }

    public MacFileChooserDialogImpl(@NotNull FileChooserDescriptor chooserDescriptor, Project project) {
        if (chooserDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chooserDescriptor", "com/intellij/ui/mac/MacFileChooserDialogImpl", "<init>"));
        }
        this.myChooserDescriptor = chooserDescriptor;
        this.myProject = project;
    }

    public void choose(@Nullable VirtualFile toSelect, @NotNull Consumer<List<VirtualFile>> callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/ui/mac/MacFileChooserDialogImpl", "choose"));
        }
        ExtensionsInitializer.initialize();
        this.myCallback = callback;
        this.myModalityState = ModalityState.current();
        VirtualFile lastOpenedFile = FileChooserUtil.getLastOpenedFile(this.myProject);
        VirtualFile selectFile = FileChooserUtil.getFileToSelect(this.myChooserDescriptor, this.myProject, toSelect, lastOpenedFile);
        final String selectPath = selectFile != null ? FileUtil.toSystemDependentName((String)selectFile.getPath()) : null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MacFileChooserDialogImpl.showNativeChooserAsSheet(MacFileChooserDialogImpl.this, selectPath);
            }
        });
    }

    @Nullable
    private static IdeMenuBar getMenuBar() {
        for (Window cur = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow(); cur != null; cur = cur.getOwner()) {
            JMenuBar menuBar;
            if (!(cur instanceof JFrame) || !((menuBar = ((JFrame)cur).getJMenuBar()) instanceof IdeMenuBar)) continue;
            return (IdeMenuBar)menuBar;
        }
        return null;
    }

    private static void showNativeChooserAsSheet(@NotNull MacFileChooserDialogImpl impl, @Nullable String toSelect) {
        if (impl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "impl", "com/intellij/ui/mac/MacFileChooserDialogImpl", "showNativeChooserAsSheet"));
        }
        IdeMenuBar bar = MacFileChooserDialogImpl.getMenuBar();
        if (bar != null) {
            bar.disableUpdates();
        }
        ID delegate = MacFileChooserDialogImpl.invoke(Foundation.getObjcClass((String)"NSOpenPanelDelegate_"), "new", new Object[0]);
        ourImplMap.put(delegate, impl);
        ID select = toSelect == null ? null : Foundation.nsString((String)toSelect);
        JDK7WindowReorderingWorkaround.disableReordering();
        MacFileChooserDialogImpl.invoke(delegate, "performSelectorOnMainThread:withObject:waitUntilDone:", Foundation.createSelector((String)"showOpenPanel:"), select, false);
    }

    private static ID invoke(@NotNull String className, @NotNull String selector, Object ... args) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/ui/mac/MacFileChooserDialogImpl", "invoke"));
        }
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/ui/mac/MacFileChooserDialogImpl", "invoke"));
        }
        return MacFileChooserDialogImpl.invoke(Foundation.getObjcClass((String)className), selector, args);
    }

    private static ID invoke(@NotNull ID id, @NotNull String selector, Object ... args) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ui/mac/MacFileChooserDialogImpl", "invoke"));
        }
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/ui/mac/MacFileChooserDialogImpl", "invoke"));
        }
        return Foundation.invoke((ID)id, (Pointer)Foundation.createSelector((String)selector), (Object[])args);
    }

    static {
        ID delegate = Foundation.allocateObjcClassPair((ID)Foundation.getObjcClass((String)"NSObject"), (String)"NSOpenPanelDelegate_");
        MacFileChooserDialogImpl.addFoundationMethod(delegate, "showOpenPanel:", MAIN_THREAD_RUNNABLE, "v*");
        MacFileChooserDialogImpl.addFoundationMethod(delegate, "openPanelDidEnd:returnCode:contextInfo:", OPEN_PANEL_DID_END, "v*i");
        MacFileChooserDialogImpl.addFoundationMethod(delegate, "panel:shouldEnableURL:", SHOULD_ENABLE_CALLBACK, "B@@");
        if (SystemInfo.isMacOSSnowLeopard) {
            MacFileChooserDialogImpl.addFoundationMethod(delegate, "panel:validateURL:error:", VALIDATE_URL_CALLBACK, "B@@o");
        }
        Foundation.registerObjcClassPair((ID)delegate);
    }

    private static class ExtensionsInitializer {
        private static boolean initialized;

        private ExtensionsInitializer() {
        }

        private static void initialize() {
            if (initialized) {
                return;
            }
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    Extensions.getExtensions((ExtensionPointName)ProjectOpenProcessor.EXTENSION_POINT_NAME);
                }
            });
            initialized = true;
        }
    }
}

