/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.classpath;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GlobalLibraryReferenceElement
implements SimpleClasspathElement {
    @NonNls
    public static final String NAME_ATTRIBUTE = "name";
    @NonNls
    public static final String LEVEL_ATTRIBUTE = "level";
    private final String myLibraryName;

    public GlobalLibraryReferenceElement(@NotNull String libraryName) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/util/ui/classpath/GlobalLibraryReferenceElement", "<init>"));
        }
        this.myLibraryName = libraryName;
    }

    public GlobalLibraryReferenceElement(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/ui/classpath/GlobalLibraryReferenceElement", "<init>"));
        }
        this.myLibraryName = element.getAttributeValue(NAME_ATTRIBUTE);
    }

    @Override
    public String getPresentableName() {
        return this.myLibraryName;
    }

    public void writeExternal(Element element) {
        element.setAttribute(NAME_ATTRIBUTE, this.myLibraryName);
        element.setAttribute(LEVEL_ATTRIBUTE, "application");
    }

    @Override
    public Library getLibrary() {
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable();
        return libraryTable.getLibraryByName(this.myLibraryName);
    }

    @Override
    public String getLibraryName() {
        return this.myLibraryName;
    }

    @Override
    public void serialize(Element element) throws IOException {
        element.setAttribute(NAME_ATTRIBUTE, this.myLibraryName);
        element.setAttribute(LEVEL_ATTRIBUTE, "application");
    }

    @Override
    public List<String> getClassesRootUrls() {
        Library library = this.getLibrary();
        if (library != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
                list.add(file.getUrl());
            }
            return list;
        }
        return Collections.emptyList();
    }
}

