/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.google.common.collect.Ordering;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.render.VcsRefPainter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchesPanel
extends JPanel {
    private static final int SMALL_ROOTS_GAP = 3;
    private static final int BIG_ROOTS_GAP = 7;
    private static final int VERTICAL_SPACE = 3;
    private final VcsLogDataHolder myDataHolder;
    private final VcsLogUiImpl myUI;
    private LinkedHashMap<VirtualFile, List<RefGroup>> myRefGroups;
    private final VcsRefPainter myReferencePainter;
    @Nullable
    private Collection<VirtualFile> myRoots;
    private Map<Integer, RefGroup> myRefPositions;

    public BranchesPanel(@NotNull VcsLogDataHolder dataHolder, @NotNull VcsLogUiImpl UI2, @NotNull RefsModel initialRefsModel) {
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/vcs/log/ui/frame/BranchesPanel", "<init>"));
        }
        if (UI2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "UI", "com/intellij/vcs/log/ui/frame/BranchesPanel", "<init>"));
        }
        if (initialRefsModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialRefsModel", "com/intellij/vcs/log/ui/frame/BranchesPanel", "<init>"));
        }
        this.myRoots = null;
        this.myRefPositions = ContainerUtil.newHashMap();
        this.myDataHolder = dataHolder;
        this.myUI = UI2;
        this.myRefGroups = this.getRefsToDisplayOnPanel(initialRefsModel);
        this.myReferencePainter = new VcsRefPainter(this.myUI.getColorManager(), true);
        this.setPreferredSize(new Dimension(-1, this.myReferencePainter.getHeight(this) + 4 + 3));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!BranchesPanel.this.myUI.getMainFrame().areGraphActionsEnabled()) {
                    return;
                }
                RefGroup group = BranchesPanel.this.findRef(e);
                if (group == null) {
                    return;
                }
                if (group.getRefs().size() == 1) {
                    VcsRef ref = (VcsRef)group.getRefs().iterator().next();
                    BranchesPanel.this.myUI.jumpToCommit(ref.getCommitHash());
                } else {
                    ReferencePopupComponent view = new ReferencePopupComponent(group, BranchesPanel.this.myUI, BranchesPanel.this.myReferencePainter);
                    JBPopup popup = view.getPopup();
                    popup.show(new RelativePoint((Component)BranchesPanel.this, new Point(e.getX(), BranchesPanel.this.getHeight())));
                }
            }
        });
        this.myUI.addLogListener(new VcsLogListener(){

            public void onChange(@NotNull VcsLogDataPack dataPack, boolean refresh) {
                if (dataPack == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/frame/BranchesPanel$2", "onChange"));
                }
                if (refresh) {
                    BranchesPanel.this.rebuild(dataPack.getRefs());
                }
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(-1, this.myReferencePainter.getHeight(this) + 10);
    }

    @Nullable
    private RefGroup findRef(MouseEvent e) {
        List sortedPositions = Ordering.natural().sortedCopy(this.myRefPositions.keySet());
        int index = Ordering.natural().binarySearch(sortedPositions, (Object)e.getX());
        if (index < 0) {
            index = -index - 2;
        }
        if (index < 0) {
            return null;
        }
        return this.myRefPositions.get(sortedPositions.get(index));
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.myRefPositions = ContainerUtil.newHashMap();
        int paddingX = 7;
        for (Map.Entry<VirtualFile, List<RefGroup>> entry : this.myRefGroups.entrySet()) {
            VirtualFile root = entry.getKey();
            for (RefGroup group : entry.getValue()) {
                if (this.myRoots != null && !this.myRoots.contains(root)) continue;
                JBColor rootIndicatorColor = VcsLogColorManagerImpl.getIndicatorColor(this.myUI.getColorManager().getRootColor(root));
                Rectangle rectangle = this.myReferencePainter.paint(group.getName(), g, paddingX, (this.getHeight() - this.myReferencePainter.getHeight(this)) / 2 - 3, group.getBgColor(), (Color)rootIndicatorColor);
                paddingX += rectangle.width + 3;
                this.myRefPositions.put(rectangle.x, group);
            }
            paddingX += 4;
        }
    }

    public void rebuild(@NotNull VcsLogRefs refsModel) {
        if (refsModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refsModel", "com/intellij/vcs/log/ui/frame/BranchesPanel", "rebuild"));
        }
        this.myRefGroups = this.getRefsToDisplayOnPanel(refsModel);
        this.getParent().repaint();
    }

    @NotNull
    private LinkedHashMap<VirtualFile, List<RefGroup>> getRefsToDisplayOnPanel(@NotNull VcsLogRefs refsModel) {
        if (refsModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refsModel", "com/intellij/vcs/log/ui/frame/BranchesPanel", "getRefsToDisplayOnPanel"));
        }
        Collection allRefs = refsModel.getBranches();
        LinkedHashMap groups = ContainerUtil.newLinkedHashMap();
        for (Map.Entry entry : VcsLogUtil.groupRefsByRoot(allRefs).entrySet()) {
            VirtualFile root = (VirtualFile)entry.getKey();
            ArrayList list = ContainerUtil.newArrayList();
            list.addAll(BranchesPanel.expandExpandableGroups(this.myDataHolder.getLogProvider(root).getReferenceManager().group((Collection)entry.getValue())));
            groups.put(root, list);
        }
        LinkedHashMap linkedHashMap = groups;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/BranchesPanel", "getRefsToDisplayOnPanel"));
        }
        return linkedHashMap;
    }

    private static Collection<RefGroup> expandExpandableGroups(List<RefGroup> refGroups) {
        ArrayList groups = ContainerUtil.newArrayList();
        for (RefGroup group : refGroups) {
            if (group.isExpanded()) {
                groups.addAll(ContainerUtil.map((Collection)group.getRefs(), (Function)new Function<VcsRef, RefGroup>(){

                    public RefGroup fun(VcsRef ref) {
                        return new SingletonRefGroup(ref);
                    }
                }));
                continue;
            }
            groups.add(group);
        }
        return groups;
    }

    public void onFiltersChange(@NotNull VcsLogFilterCollection filters) {
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/ui/frame/BranchesPanel", "onFiltersChange"));
        }
        this.myRoots = VcsLogUtil.getAllVisibleRoots(this.myDataHolder.getRoots(), filters.getRootFilter(), filters.getStructureFilter());
        this.getParent().repaint();
    }

    private static class SingleReferenceComponent
    extends JPanel {
        private static final int PADDING_Y = 2;
        private static final int PADDING_X = 5;
        @NotNull
        private final VcsRefPainter myReferencePainter;
        @Nullable
        private VcsRef myReference;
        public boolean mySelected;

        public SingleReferenceComponent(@NotNull VcsRefPainter referencePainter) {
            if (referencePainter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencePainter", "com/intellij/vcs/log/ui/frame/BranchesPanel$SingleReferenceComponent", "<init>"));
            }
            this.myReferencePainter = referencePainter;
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.mySelected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.myReference != null) {
                this.myReferencePainter.paint(this.myReference, g, 5, 2);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.myReference == null) {
                return super.getPreferredSize();
            }
            Dimension size = this.myReferencePainter.getSize(this.myReference, (JComponent)this);
            return new Dimension(size.width + 10, size.height + 4);
        }

        public void setReference(@NotNull VcsRef reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/vcs/log/ui/frame/BranchesPanel$SingleReferenceComponent", "setReference"));
            }
            this.myReference = reference;
        }

        public void setSelected(boolean selected) {
            this.mySelected = selected;
        }
    }

    private static class ReferencePopupComponent
    extends JPanel {
        @NotNull
        private final JBPopup myPopup;
        @NotNull
        private final JBList myList;
        @NotNull
        private final VcsLogUiImpl myUi;
        @NotNull
        private final SingleReferenceComponent myRendererComponent;
        @NotNull
        private final ListCellRenderer myCellRenderer;

        ReferencePopupComponent(@NotNull RefGroup group, @NotNull VcsLogUiImpl ui, @NotNull VcsRefPainter referencePainter) {
            if (group == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/vcs/log/ui/frame/BranchesPanel$ReferencePopupComponent", "<init>"));
            }
            if (ui == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/frame/BranchesPanel$ReferencePopupComponent", "<init>"));
            }
            if (referencePainter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencePainter", "com/intellij/vcs/log/ui/frame/BranchesPanel$ReferencePopupComponent", "<init>"));
            }
            super(new BorderLayout());
            this.myUi = ui;
            this.myRendererComponent = new SingleReferenceComponent(referencePainter);
            this.myCellRenderer = new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    ReferencePopupComponent.this.myRendererComponent.setReference((VcsRef)value);
                    ReferencePopupComponent.this.myRendererComponent.setSelected(isSelected);
                    return ReferencePopupComponent.this.myRendererComponent;
                }
            };
            this.myList = this.createList(group);
            this.myPopup = this.createPopup();
            this.add((Component)new JBScrollPane((Component)this.myList));
        }

        private JBList createList(RefGroup group) {
            JBList list = new JBList((ListModel)ReferencePopupComponent.createListModel(group));
            list.setCellRenderer(this.myCellRenderer);
            ListUtil.installAutoSelectOnMouseMove((JList)list);
            list.setSelectedIndex(0);
            list.setSelectionMode(0);
            this.jumpOnMouseClick(list);
            this.jumpOnEnter(list);
            return list;
        }

        private void jumpOnMouseClick(JBList list) {
            list.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ReferencePopupComponent.this.jumpToSelectedRef();
                }
            });
        }

        private void jumpOnEnter(JBList list) {
            list.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ReferencePopupComponent.this.jumpToSelectedRef();
                    }
                }
            });
        }

        private JBPopup createPopup() {
            return JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this, (JComponent)this.myList).setCancelOnClickOutside(true).setCancelOnWindowDeactivation(true).setFocusable(true).setRequestFocus(true).setResizable(true).setDimensionServiceKey(this.myUi.getProject(), "Vcs.Log.Branch.Panel.RefGroup.Popup", false).createPopup();
        }

        private static DefaultListModel createListModel(RefGroup group) {
            DefaultListModel<VcsRef> model = new DefaultListModel<VcsRef>();
            for (VcsRef vcsRef : group.getRefs()) {
                model.addElement(vcsRef);
            }
            return model;
        }

        @NotNull
        JBPopup getPopup() {
            JBPopup jBPopup = this.myPopup;
            if (jBPopup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/BranchesPanel$ReferencePopupComponent", "getPopup"));
            }
            return jBPopup;
        }

        private void jumpToSelectedRef() {
            this.myPopup.cancel();
            VcsRef selectedRef = (VcsRef)this.myList.getSelectedValue();
            if (selectedRef != null) {
                this.myUi.jumpToCommit(selectedRef.getCommitHash());
            }
        }
    }
}

