/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBSplitter;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.EvaluationInputComponent;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeFragmentInputComponent
extends EvaluationInputComponent {
    private final XDebuggerExpressionEditor myMultilineEditor;
    private final JPanel myMainPanel;
    private final String mySplitterProportionKey;

    public CodeFragmentInputComponent(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XSourcePosition sourcePosition, @Nullable XExpression statements, String splitterProportionKey, Disposable parentDisposable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/evaluate/CodeFragmentInputComponent", "<init>"));
        }
        if (editorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorsProvider", "com/intellij/xdebugger/impl/evaluate/CodeFragmentInputComponent", "<init>"));
        }
        super(XDebuggerBundle.message((String)"dialog.title.evaluate.code.fragment", (Object[])new Object[0]));
        this.myMultilineEditor = new XDebuggerExpressionEditor(project, editorsProvider, "evaluateCodeFragment", sourcePosition, statements != null ? statements : XExpressionImpl.EMPTY_CODE_FRAGMENT, true);
        this.myMainPanel = new JPanel(new BorderLayout());
        JPanel editorPanel = new JPanel(new BorderLayout());
        editorPanel.add((Component)this.myMultilineEditor.getComponent(), "Center");
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new HistoryNavigationAction(false, "PreviousOccurence", parentDisposable));
        group.add((AnAction)new HistoryNavigationAction(true, "NextOccurence", parentDisposable));
        editorPanel.add((Component)ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, false).getComponent(), "East");
        this.myMainPanel.add((Component)editorPanel, "Center");
        if (statements != null) {
            this.myMultilineEditor.setExpression(statements);
        }
        this.mySplitterProportionKey = splitterProportionKey;
    }

    @Override
    @NotNull
    protected XDebuggerEditorBase getInputEditor() {
        XDebuggerExpressionEditor xDebuggerExpressionEditor = this.myMultilineEditor;
        if (xDebuggerExpressionEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/evaluate/CodeFragmentInputComponent", "getInputEditor"));
        }
        return xDebuggerExpressionEditor;
    }

    @Override
    public void addComponent(JPanel contentPanel, JPanel resultPanel) {
        JBSplitter splitter = new JBSplitter(true, 0.3f, 0.2f, 0.7f);
        splitter.setSplitterProportionKey(this.mySplitterProportionKey);
        contentPanel.add((Component)splitter, "Center");
        splitter.setFirstComponent((JComponent)this.myMainPanel);
        splitter.setSecondComponent((JComponent)resultPanel);
    }

    private class HistoryNavigationAction
    extends AnAction {
        private final boolean myForward;

        public HistoryNavigationAction(boolean forward, String actionId, Disposable parentDisposable) {
            this.myForward = forward;
            AnAction action = ActionManager.getInstance().getAction(actionId);
            this.copyFrom(action);
            this.registerCustomShortcutSet(action.getShortcutSet(), CodeFragmentInputComponent.this.myMainPanel, parentDisposable);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.myForward ? CodeFragmentInputComponent.this.myMultilineEditor.canGoForward() : CodeFragmentInputComponent.this.myMultilineEditor.canGoBackward());
        }

        public void actionPerformed(AnActionEvent e) {
            if (this.myForward) {
                CodeFragmentInputComponent.this.myMultilineEditor.goForward();
            } else {
                CodeFragmentInputComponent.this.myMultilineEditor.goBackward();
            }
        }
    }
}

