/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionAdapter;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XInstanceEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerInstanceTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeWithHistoryPanel;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XInspectDialog
extends DialogWrapper {
    private final DebuggerTreeWithHistoryPanel myDebuggerTreePanel;
    private final boolean myRebuildOnSessionEvents;

    public XInspectDialog(@NotNull Project project, XDebuggerEditorsProvider editorsProvider, XSourcePosition sourcePosition, @NotNull String name, @NotNull XValue value, XValueMarkers<?, ?> markers, @Nullable XDebugSession session, boolean rebuildOnSessionEvents) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/ui/tree/XInspectDialog", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/xdebugger/impl/ui/tree/XInspectDialog", "<init>"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/XInspectDialog", "<init>"));
        }
        super(project, false);
        this.myRebuildOnSessionEvents = rebuildOnSessionEvents;
        this.setTitle(XDebuggerBundle.message((String)"inspect.value.dialog.title", (Object[])new Object[]{name}));
        this.setModal(false);
        XInstanceEvaluator instanceEvaluator = value.getInstanceEvaluator();
        if (instanceEvaluator != null && this.myRebuildOnSessionEvents && session != null) {
            Pair initialItem = Pair.create((Object)instanceEvaluator, (Object)name);
            XDebuggerInstanceTreeCreator creator = new XDebuggerInstanceTreeCreator(project, editorsProvider, sourcePosition, markers, session);
            this.myDebuggerTreePanel = new DebuggerTreeWithHistoryPanel<Pair<XInstanceEvaluator, String>>(initialItem, creator, project, this.myDisposable);
        } else {
            Pair initialItem = Pair.create((Object)value, (Object)name);
            XDebuggerTreeCreator creator = new XDebuggerTreeCreator(project, editorsProvider, sourcePosition, markers);
            this.myDebuggerTreePanel = new DebuggerTreeWithHistoryPanel<Pair<XValue, String>>(initialItem, creator, project, this.myDisposable);
        }
        if (session != null) {
            session.addSessionListener((XDebugSessionListener)new XDebugSessionAdapter(){

                public void sessionPaused() {
                    if (XInspectDialog.this.myRebuildOnSessionEvents) {
                        XInspectDialog.this.myDebuggerTreePanel.rebuild();
                    }
                }
            }, this.myDisposable);
        }
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myDebuggerTreePanel.getMainPanel();
    }

    @Nullable
    protected JComponent createSouthPanel() {
        return null;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "#xdebugger.XInspectDialog";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myDebuggerTreePanel.getTree();
    }
}

