/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.NullableFunction;
import com.intellij.util.indexing.AdditionalIndexedRootsScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.xml.index.ResourceRelevance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedRelevantResource<K, V extends Comparable>
implements Comparable<IndexedRelevantResource<K, V>> {
    private final VirtualFile myFile;
    private final K myKey;
    private final V myValue;
    private final ResourceRelevance myRelevance;

    public static <K, V extends Comparable> List<IndexedRelevantResource<K, V>> getResources(ID<K, V> indexId, final K key, final @Nullable Module module, @NotNull Project project, final @Nullable GlobalSearchScope additionalScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/index/IndexedRelevantResource", "getResources"));
        }
        if (project.isDefault()) {
            return Collections.emptyList();
        }
        final ArrayList<IndexedRelevantResource<K, V>> resources = new ArrayList<IndexedRelevantResource<K, V>>();
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        FileBasedIndex.getInstance().processValues(indexId, key, null, new FileBasedIndex.ValueProcessor<V>(){

            public boolean process(VirtualFile file, V value) {
                ResourceRelevance relevance = ResourceRelevance.getRelevance(file, module, fileIndex, additionalScope);
                resources.add(new IndexedRelevantResource(file, key, value, relevance));
                return true;
            }
        }, (GlobalSearchScope)new AdditionalIndexedRootsScope(GlobalSearchScope.allScope((Project)project)));
        return resources;
    }

    public static <K, V extends Comparable> List<IndexedRelevantResource<K, V>> getAllResources(ID<K, V> indexId, @Nullable Module module, @NotNull Project project, @Nullable NullableFunction<List<IndexedRelevantResource<K, V>>, IndexedRelevantResource<K, V>> chooser) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/index/IndexedRelevantResource", "getAllResources"));
        }
        ArrayList<IndexedRelevantResource<K, V>> all = new ArrayList<IndexedRelevantResource<K, V>>();
        Collection allKeys = FileBasedIndex.getInstance().getAllKeys(indexId, project);
        for (Object key : allKeys) {
            List<IndexedRelevantResource<K, V>> resources = IndexedRelevantResource.getResources(indexId, key, module, project, null);
            if (resources.isEmpty()) continue;
            if (chooser == null) {
                all.add(resources.get(0));
                continue;
            }
            IndexedRelevantResource resource = (IndexedRelevantResource)chooser.fun(resources);
            if (resource == null) continue;
            all.add(resource);
        }
        return all;
    }

    public IndexedRelevantResource(VirtualFile file, K key, V value, ResourceRelevance relevance) {
        this.myFile = file;
        this.myKey = key;
        this.myValue = value;
        this.myRelevance = relevance;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public V getValue() {
        return this.myValue;
    }

    public ResourceRelevance getRelevance() {
        return this.myRelevance;
    }

    @Override
    public int compareTo(IndexedRelevantResource<K, V> o) {
        int i = this.myRelevance.compareTo(o.getRelevance());
        return i == 0 ? this.myValue.compareTo(o.getValue()) : i;
    }

    public K getKey() {
        return this.myKey;
    }

    public String toString() {
        return "IndexedRelevantResource{myRelevance=" + (Object)((Object)this.myRelevance) + ", myKey=" + this.myKey + ", myValue=" + this.myValue + ", myFile=" + this.myFile + '}';
    }
}

