/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class ClassNamePrefixedWithPackageNameInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.name.prefixed.with.package.name.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/ClassNamePrefixedWithPackageNameInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.name.prefixed.with.package.name.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/ClassNamePrefixedWithPackageNameInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassNameBePrefixedWithPackageNameVisitor();
    }

    private static class ClassNameBePrefixedWithPackageNameVisitor
    extends BaseInspectionVisitor {
        private ClassNameBePrefixedWithPackageNameVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            String lowercasePackageName;
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/naming/ClassNamePrefixedWithPackageNameInspectionBase$ClassNameBePrefixedWithPackageNameVisitor", "visitClass"));
            }
            String className = aClass.getName();
            if (className == null) {
                return;
            }
            PsiClass outerClass = ClassUtils.getOutermostContainingClass(aClass);
            String qualifiedName = outerClass.getQualifiedName();
            if (qualifiedName == null) {
                return;
            }
            if (className.equals(qualifiedName)) {
                return;
            }
            StringTokenizer tokenizer = new StringTokenizer(qualifiedName, ".");
            String currentPackageName = null;
            String lastPackageName = null;
            while (tokenizer.hasMoreTokens()) {
                lastPackageName = currentPackageName;
                currentPackageName = tokenizer.nextToken();
            }
            if (lastPackageName == null) {
                return;
            }
            String lowercaseClassName = className.toLowerCase();
            if (!lowercaseClassName.startsWith(lowercasePackageName = lastPackageName.toLowerCase())) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

