/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class NonExceptionNameEndsWithExceptionInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.exception.name.ends.with.exception.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/NonExceptionNameEndsWithExceptionInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.exception.name.ends.with.exception.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/NonExceptionNameEndsWithExceptionInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonExceptionNameEndsWithExceptionVisitor();
    }

    private static class NonExceptionNameEndsWithExceptionVisitor
    extends BaseInspectionVisitor {
        private NonExceptionNameEndsWithExceptionVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/naming/NonExceptionNameEndsWithExceptionInspectionBase$NonExceptionNameEndsWithExceptionVisitor", "visitClass"));
            }
            String className = aClass.getName();
            if (className == null) {
                return;
            }
            String exception = "Exception";
            if (!className.endsWith("Exception")) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Exception")) {
                return;
            }
            this.registerClassError(aClass, className, this.isOnTheFly());
        }
    }
}

