/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ipp.base.PsiElementPredicate;

class NestedTryStatementsPredicate
implements PsiElementPredicate {
    NestedTryStatementsPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken javaToken = (PsiJavaToken)element;
        IElementType tokenType = javaToken.getTokenType();
        if (!JavaTokenType.TRY_KEYWORD.equals(tokenType)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!NestedTryStatementsPredicate.isSimpleTry(parent)) {
            return false;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)parent;
        PsiCodeBlock block = tryStatement.getTryBlock();
        if (block == null) {
            return false;
        }
        PsiStatement[] statements = block.getStatements();
        if (statements.length != 1) {
            return false;
        }
        PsiStatement statement = statements[0];
        return NestedTryStatementsPredicate.isSimpleTry((PsiElement)statement);
    }

    private static boolean isSimpleTry(PsiElement element) {
        if (!(element instanceof PsiTryStatement)) {
            return false;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)element;
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            return false;
        }
        PsiCodeBlock block = tryStatement.getTryBlock();
        return block != null;
    }
}

