/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkListener;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.PropertyMetadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ContextDependentAsyncResultConsumer;
import org.jetbrains.debugger.DebugProcessImpl$WhenMappings;
import org.jetbrains.debugger.DebugProcessImpl$_breakpointHandlers$1;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextManager;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.frame.SuspendContextImpl;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"C\u0004)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\u0012\u0015\tA\"A\u0003\u0002\t\u0011)\u0011\u0001c\u0003\u0006\u0003\u0011%Q!\u0001\u0007\u0002\u000b\u0005!)!B\u0001\r\u0003\u0015\tA\u0001B\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001bB\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\t\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011A)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0003\u0004\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0007\tMa\u0001!\u0006\u0004\u0005\u0001!\u0005QcA\u0005\u0002\t\u0007A\u0012!G\u0001\u0019\u0004\u0005V\u0012b\u0001\u0005\u0003\u001b\u0005A*!C\u0002\t\u00075\tA\u0004A\u0005\u0004\u0011\u000fi\u0011\u0001\u0007\u0003\n\r!%Q\u0002B\u0005\u0002\t\u0007a\t\u0001G\u0003\n\t!-QB\u0001G\u00011\u0019\t6!\u0001E\u0007KM!\u0011\u0001c\u0011\u000e\u0003a\u0011\u0013$\u0002E#\u001b\rI\u0011\u0001b\u0001\u0019Ge!\u0001rI\u0007\u0003\u0019\u0003AB%G\u0002\tJ5\t\u0001$J\u0013\u0004\u0011\u0017j\u0011\u0001'\u0007&\u0011\u0011Q\u0001BJ\u0007\u00021\tJ2\u0001#\u0014\u000e\u0003a%Ru\u0003\u0003\u0013\u0011\u001dja!\u0003\u0003\n\u0007%\tA1\u0001\r\t1\u001f\t6!\u0001\u0005\nK\u0011!!\u0002c\u0014\u000e\u0003aIR\u0015\t\u0005)\u001bqI!\"C\u0005\n\u0003\u0011\r\u0001\u0013K\u000b\u0005\u0013\u0005!\u0019\u0001$\u0001\u0019\u0011aA\u0001\u0013K\u000b\u000f\u0013-!\t!C\u0005\n\u0003\u0011\r\u0001\u0013K\u000b\u0005\u0013\u0005!\u0019\u0001$\u0001\u0019\u0011aAA\u0012\u0001M\b1\u001f\t6!\u0001\u0005\nK\u001bA\u0011&$\u0003\r\u0002aM\u0013kA\u0001\u0005U\u0015.\u0001RKG\u00041\u0011\n6!\u0001\u0003,K\rA9&D\u0001\u0019\t\u0015jAa\u0003\u0005-\u001b\u0011I!!C\u0001\u0019[ae\u0013$\u0002E#\u001b\rI\u0011\u0001b\u0001\u0019\\\u0015\nBq\u0003\u0005-\u001b\u0011I!!C\u0001\u0019[ae\u0013$\u0002E#\u001b\rI\u0011\u0001b\u0001\u0019\\e\u0019\u0001BL\u0007\u000213)c\u0001#\u0018\u000e\t%\tA1\u0001G\u00011\u0015)C\u0001B\u0006\t_5\t\u0001\u0014D\u0013\u0004\u0011?j\u0011\u0001'\u0007&\t\u0011Q\u0001\u0002M\u0007\u000213)C\u0003\u0002\u0002\tb5\t\u0001DI\r\u0006\u0011\u0013j1!C\u0001\u0005\u0004a\t\u0014$\u0002E#\u001b\rI\u0011\u0001b\u0001\u0019Ge\u0019\u00012M\u0007\u00021I*C\u0003B\u0001\tf5\t\u0001DI\r\u0006\u0011\u000bj1!C\u0001\u0005\u0004a\u0019\u0013d\u0001E2\u001b\u0005A\"'G\u0003\tJ5\u0019\u0011\"\u0001C\u00021E*3\u0001C\u001a\u000e\u0003a\u0011Se\u0003E4\u001b\u0005A\"%G\u0002\ti5\t\u00014H\r\u0004\u0011Sj\u0011\u0001\u0007\u0010&\t\u0011\u0011\u0001\"N\u0007\u00021\t*3\u0001c\u001b\u000e\u0003a\u0011Se\u0001\u00057\u001b\u0005A\"%J\u0002\tn5\t\u0001DI\u0013\u0004\u0011]j\u0011\u0001\u0007\u0012&\u0007!=T\"\u0001\r#K\u0011!\u0011\u0001\u0003\u001d\u000e\u0003a\u0011\u0013F\u0005\u0003B\u0011!9QBB\u0005\u0005\u0013\rI\u0011\u0001b\u0001\u0019\u0011a=A$I)\u0004\r\u0015\u0011A1\u0003\u0005\u000b\u001b\t!\t\u0002C\u0005*\u0017\u0011\u0019\u0005\u0002C\u0002\u000e\u0003q\u0001\u0011kA\u0003\u0006\u0003!]QB\u0001C\u000b\u0011-Is\u0002\"\"\u001d\u00111i\u0011\u0001'\u0007\u001d\u0005\u0001\u0012\u0011kA\u0004\u0006\u00015\u0011A!\u0004E\u000e#\t!a\u0002#\b*\u000f\u0011\t\u0005\u0002c\u0002\u000e\u0003a!\u0011kA\u0001\u0006\u0001%ZAA\u0011\u0005\t\f5\u0011A\u0012\u0001\r\u0007#\u000e!Q\u0001A\u0007\u0003\t=Ay\"K\b\u0005\u0006rA\u0001#D\u0001\u0019\u001aq\u0011\u0001EA)\u0004\u000f\u0015\u0001QB\u0001\u0003\u0011\u00117\t\"\u0001\"\t\t\u001e%\u0002BQ\u0011\u000f\t#5\u0011A\u0012\u0001M\u00129\t\u0001#!U\u0002\b\u000b\u0001i!\u0001\u0002\n\t&E\u0011Aa\u0005E\u0014SA!)\t\b\u0005\u0015\u001b\ta\t\u0001'\u000b\u001d\u0005\u0001\u0012\u0011kA\u0004\u0006\u00015\u0011A!\u0006E\u0016#\t!a\u0003#\f*\u001b\u0011\u0019E\u0004C\f\u000e\u0003ae\u0011kA\u0004\u0006\u00015\u0011Aq\u0006E\u000e#\t!\u0001\u0004#\b*\u0017\u0011\u0011\u0005\u0002#\r\u000e\u00051\u0005\u0001$\u0007\u000f##\u000e\u0019QB\u0001C\u001a\u0011iI#\u0002\u0002\"\t\u0011ki\u0011\u0001G\u000eR\u0007\u0011)\u0001!\u0004\u0002\u00058!a\u0012F\u0003\u0003B\u0011!%Q\u0002B\u0005\u0002\t\u0007a\t\u0001G\u0003R\u0007\u0005)\u0001!\u000b\t\u0005\u0005\"AI$D\u0004\n\u0005%\t\u00014H\u0005\u0003\u0013\u0005Ab\u0004G\u000fR\u0007\u0011)\u0001!\u0004\u0002\u0005>!y\u0012f\u0003\u0003D\u0011!}RB\u0001G\u00011\u0001b2%U\u0002\u0004\u001b\t!\t\u0005C\u0011"}, strings={"Lorg/jetbrains/debugger/DebugProcessImpl;", "C", "Lorg/jetbrains/debugger/connection/VmConnection;", "Lcom/intellij/xdebugger/XDebugProcess;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "connection", "editorsProvider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "smartStepIntoHandler", "Lcom/intellij/xdebugger/stepping/XSmartStepIntoHandler;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "(Lcom/intellij/xdebugger/XDebugSession;Lorg/jetbrains/debugger/connection/VmConnection;Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;Lcom/intellij/xdebugger/stepping/XSmartStepIntoHandler;Lcom/intellij/execution/ExecutionResult;)V", "_breakpointHandlers", "", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "get_breakpointHandlers", "()[Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "_breakpointHandlers$delegate", "Lkotlin/Lazy;", "getConnection", "()Lorg/jetbrains/debugger/connection/VmConnection;", "Lorg/jetbrains/debugger/connection/VmConnection;", "disableDoNotStepIntoLibraries", "", "getDisableDoNotStepIntoLibraries", "()Z", "setDisableDoNotStepIntoLibraries", "(Z)V", "getExecutionResult", "()Lcom/intellij/execution/ExecutionResult;", "isForceStep", "setForceStep", "lastCallFrame", "Lorg/jetbrains/debugger/CallFrame;", "getLastCallFrame", "()Lorg/jetbrains/debugger/CallFrame;", "setLastCallFrame", "(Lorg/jetbrains/debugger/CallFrame;)V", "lastStep", "Lorg/jetbrains/debugger/StepAction;", "getLastStep", "()Lorg/jetbrains/debugger/StepAction;", "setLastStep", "(Lorg/jetbrains/debugger/StepAction;)V", "processBreakpointConditionsAtIdeSide", "getProcessBreakpointConditionsAtIdeSide", "setProcessBreakpointConditionsAtIdeSide", "realProcessHandler", "Lcom/intellij/execution/process/ProcessHandler;", "getRealProcessHandler", "()Lcom/intellij/execution/process/ProcessHandler;", "repeatStepInto", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getRepeatStepInto", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "urlToFileCache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/util/Url;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getUrlToFileCache", "()Ljava/util/concurrent/ConcurrentMap;", "vm", "Lorg/jetbrains/debugger/Vm;", "getVm", "()Lorg/jetbrains/debugger/Vm;", "breakpointReached", "", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "evaluatedLogExpression", "", "suspendContext", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "checkCanPerformCommands", "continueVm", "stepAction", "createBreakpointHandlers", "doGetProcessHandler", "getBreakpointHandlers", "kotlin.jvm.PlatformType", "getCurrentStateHyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "Lorg/jetbrains/annotations/Nullable;", "getCurrentStateMessage", "Lorg/jetbrains/annotations/NotNull;", "getEditorsProvider", "getLocationsForBreakpoint", "", "Lorg/jetbrains/debugger/Location;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "onlySourceMappedBreakpoints", "getSmartStepIntoHandler", "isLibraryFrameFilterSupported", "isValuesCustomSorted", "isVmStepOutCorrect", "processBreakpoint", "Lorg/jetbrains/debugger/SuspendContext;", "xSuspendContext", "Lorg/jetbrains/debugger/frame/SuspendContextImpl;", "processBreakpointLogExpressionAndSuspend", "resume", "saveResolvedFile", "url", "file", "setOverlay", "startForceStepInto", "startPausing", "startStepInto", "startStepOut", "startStepOver", "updateLastCallFrame"}, moduleName="script-debugger-ui")
public abstract class DebugProcessImpl<C extends VmConnection<?>>
extends XDebugProcess {
    @NotNull
    private final AtomicBoolean repeatStepInto;
    @Nullable
    private volatile StepAction lastStep;
    @Nullable
    private volatile CallFrame lastCallFrame;
    private volatile boolean isForceStep;
    private volatile boolean disableDoNotStepIntoLibraries;
    @NotNull
    private final ConcurrentMap<Url, VirtualFile> urlToFileCache;
    private boolean processBreakpointConditionsAtIdeSide;
    private final Lazy<? extends XBreakpointHandler<?>[]> _breakpointHandlers$delegate;
    @NotNull
    private final C connection;
    private final XDebuggerEditorsProvider editorsProvider;
    private final XSmartStepIntoHandler<?> smartStepIntoHandler;
    @Nullable
    private final ExecutionResult executionResult;
    private static final /* synthetic */ PropertyMetadata[] $$delegatedProperties;

    @NotNull
    protected final AtomicBoolean getRepeatStepInto() {
        return this.repeatStepInto;
    }

    @Nullable
    protected final StepAction getLastStep() {
        return this.lastStep;
    }

    protected final void setLastStep(@Nullable StepAction stepAction) {
        this.lastStep = stepAction;
    }

    @Nullable
    protected final CallFrame getLastCallFrame() {
        return this.lastCallFrame;
    }

    protected final void setLastCallFrame(@Nullable CallFrame callFrame) {
        this.lastCallFrame = callFrame;
    }

    protected final boolean isForceStep() {
        return this.isForceStep;
    }

    protected final void setForceStep(boolean bl) {
        this.isForceStep = bl;
    }

    protected final boolean getDisableDoNotStepIntoLibraries() {
        return this.disableDoNotStepIntoLibraries;
    }

    protected final void setDisableDoNotStepIntoLibraries(boolean bl) {
        this.disableDoNotStepIntoLibraries = bl;
    }

    @NotNull
    protected final ConcurrentMap<Url, VirtualFile> getUrlToFileCache() {
        return this.urlToFileCache;
    }

    public final boolean getProcessBreakpointConditionsAtIdeSide() {
        return this.processBreakpointConditionsAtIdeSide;
    }

    public final void setProcessBreakpointConditionsAtIdeSide(boolean bl) {
        this.processBreakpointConditionsAtIdeSide = bl;
    }

    private final XBreakpointHandler<?>[] get_breakpointHandlers() {
        return (XBreakpointHandler[])LazyKt.getValue(this._breakpointHandlers$delegate, (Object)((Object)this), (KProperty)((KProperty)$$delegatedProperties[0]));
    }

    @Nullable
    protected final ProcessHandler getRealProcessHandler() {
        ExecutionResult executionResult = this.executionResult;
        return executionResult != null ? executionResult.getProcessHandler() : null;
    }

    @Nullable
    public final XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.smartStepIntoHandler;
    }

    public final XBreakpointHandler<?>[] getBreakpointHandlers() {
        XBreakpointHandler[] xBreakpointHandlerArray;
        switch (DebugProcessImpl$WhenMappings.$EnumSwitchMapping$1[((VmConnection)this.connection).getState().getStatus().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                xBreakpointHandlerArray = XBreakpointHandler.EMPTY_ARRAY;
                break;
            }
            default: {
                xBreakpointHandlerArray = this.get_breakpointHandlers();
            }
        }
        return xBreakpointHandlerArray;
    }

    @NotNull
    public final XDebuggerEditorsProvider getEditorsProvider() {
        return this.editorsProvider;
    }

    @Nullable
    public final Vm getVm() {
        return ((VmConnection)this.connection).getVm();
    }

    @NotNull
    protected abstract XBreakpointHandler<?>[] createBreakpointHandlers();

    private final void updateLastCallFrame() {
        Object object = this.getVm();
        this.lastCallFrame = object != null && (object = object.getSuspendContextManager()) != null && (object = object.getContext()) != null ? object.getTopFrame() : null;
    }

    public final boolean checkCanPerformCommands() {
        return this.getVm() != null;
    }

    public final boolean isValuesCustomSorted() {
        return true;
    }

    public final void startStepOver() {
        this.updateLastCallFrame();
        this.continueVm(StepAction.OVER);
    }

    public final void startForceStepInto() {
        this.isForceStep = true;
        this.startStepInto();
    }

    public final void startStepInto() {
        this.updateLastCallFrame();
        this.continueVm(StepAction.IN);
    }

    public final void startStepOut() {
        if (this.isVmStepOutCorrect()) {
            this.lastCallFrame = null;
        } else {
            this.updateLastCallFrame();
        }
        this.continueVm(StepAction.OUT);
    }

    protected boolean isVmStepOutCorrect() {
        return true;
    }

    public final void resume() {
        this.continueVm(StepAction.CONTINUE);
    }

    protected void continueVm(@NotNull StepAction stepAction) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)stepAction), (String)"stepAction");
        Vm vm = this.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        SuspendContextManager<? extends CallFrame> suspendContextManager = vm.getSuspendContextManager();
        if (stepAction == StepAction.CONTINUE) {
            if (suspendContextManager.getContext() == null) {
                return;
            }
            this.lastStep = null;
            this.lastCallFrame = null;
            this.urlToFileCache.clear();
            this.disableDoNotStepIntoLibraries = false;
        } else {
            this.lastStep = stepAction;
        }
        suspendContextManager.continueVm(stepAction, 1);
    }

    protected final void setOverlay() {
        Vm vm = this.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        vm.getSuspendContextManager().setOverlayMessage("Paused in debugger");
    }

    protected final void processBreakpoint(@NotNull SuspendContext<?> suspendContext, @NotNull XBreakpoint<?> breakpoint, @NotNull SuspendContextImpl xSuspendContext) {
        String condition;
        Intrinsics.checkParameterIsNotNull(suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull((Object)((Object)xSuspendContext), (String)"xSuspendContext");
        XExpression xExpression = breakpoint.getConditionExpression();
        String string = condition = xExpression != null ? xExpression.getExpression() : null;
        if (!this.processBreakpointConditionsAtIdeSide || condition == null) {
            this.processBreakpointLogExpressionAndSuspend(breakpoint, xSuspendContext, suspendContext);
        } else {
            Promise $receiver;
            Promise<String> promise2 = xSuspendContext.evaluateExpression(condition);
            $receiver = $receiver.done((Consumer)new ContextDependentAsyncResultConsumer<T>(suspendContext, this, breakpoint, xSuspendContext, suspendContext){
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint$inlined;
                final /* synthetic */ SuspendContextImpl $xSuspendContext$inlined;
                final /* synthetic */ SuspendContext $suspendContext$inlined;

                protected void consume(T result2, Vm vm) {
                    String it = (String)result2;
                    if (Intrinsics.areEqual((Object)"false", (Object)it)) {
                        this.this$0.resume();
                    } else {
                        DebugProcessImpl.access$processBreakpointLogExpressionAndSuspend(this.this$0, this.$breakpoint$inlined, this.$xSuspendContext$inlined, this.$suspendContext$inlined);
                    }
                }
                {
                    void $super_call_param$1;
                    this.this$0 = debugProcessImpl;
                    this.$breakpoint$inlined = xBreakpoint;
                    this.$xSuspendContext$inlined = suspendContextImpl;
                    this.$suspendContext$inlined = suspendContext2;
                    super((SuspendContext<?>)$super_call_param$1);
                }
            });
            $receiver.rejected((Consumer)new ContextDependentAsyncResultConsumer<Throwable>(suspendContext, this, breakpoint, xSuspendContext, suspendContext){
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint$inlined;
                final /* synthetic */ SuspendContextImpl $xSuspendContext$inlined;
                final /* synthetic */ SuspendContext $suspendContext$inlined;

                protected void consume(Throwable result2, Vm vm) {
                    Throwable it = result2;
                    DebugProcessImpl.access$processBreakpointLogExpressionAndSuspend(this.this$0, this.$breakpoint$inlined, this.$xSuspendContext$inlined, this.$suspendContext$inlined);
                }
                {
                    void $super_call_param$1;
                    this.this$0 = debugProcessImpl;
                    this.$breakpoint$inlined = xBreakpoint;
                    this.$xSuspendContext$inlined = suspendContextImpl;
                    this.$suspendContext$inlined = suspendContext2;
                    super((SuspendContext<?>)$super_call_param$1);
                }
            });
        }
    }

    private final void processBreakpointLogExpressionAndSuspend(XBreakpoint<?> breakpoint, SuspendContextImpl xSuspendContext, SuspendContext<?> suspendContext) {
        String logExpression;
        XExpression xExpression = breakpoint.getLogExpressionObject();
        String string = logExpression = xExpression != null ? xExpression.getExpression() : null;
        if (logExpression == null) {
            this.breakpointReached(breakpoint, null, xSuspendContext);
        } else {
            Promise $receiver;
            Promise<String> promise2 = xSuspendContext.evaluateExpression(logExpression);
            $receiver = $receiver.done((Consumer)new ContextDependentAsyncResultConsumer<T>(suspendContext, this, breakpoint, xSuspendContext){
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint$inlined;
                final /* synthetic */ SuspendContextImpl $xSuspendContext$inlined;

                protected void consume(T result2, Vm vm) {
                    String it = (String)result2;
                    DebugProcessImpl.access$breakpointReached(this.this$0, this.$breakpoint$inlined, it, this.$xSuspendContext$inlined);
                }
                {
                    void $super_call_param$1;
                    this.this$0 = debugProcessImpl;
                    this.$breakpoint$inlined = xBreakpoint;
                    this.$xSuspendContext$inlined = suspendContextImpl;
                    super((SuspendContext<?>)$super_call_param$1);
                }
            });
            $receiver.rejected((Consumer)new ContextDependentAsyncResultConsumer<Throwable>(suspendContext, this, breakpoint, logExpression, xSuspendContext){
                final /* synthetic */ DebugProcessImpl this$0;
                final /* synthetic */ XBreakpoint $breakpoint$inlined;
                final /* synthetic */ String $logExpression$inlined;
                final /* synthetic */ SuspendContextImpl $xSuspendContext$inlined;

                protected void consume(Throwable result2, Vm vm) {
                    Throwable it = result2;
                    DebugProcessImpl.access$breakpointReached(this.this$0, this.$breakpoint$inlined, "Failed to evaluate expression: " + this.$logExpression$inlined, this.$xSuspendContext$inlined);
                }
                {
                    void $super_call_param$1;
                    this.this$0 = debugProcessImpl;
                    this.$breakpoint$inlined = xBreakpoint;
                    this.$logExpression$inlined = string;
                    this.$xSuspendContext$inlined = suspendContextImpl;
                    super((SuspendContext<?>)$super_call_param$1);
                }
            });
        }
    }

    private final void breakpointReached(XBreakpoint<?> breakpoint, String evaluatedLogExpression, XSuspendContext suspendContext) {
        if (this.getSession().breakpointReached(breakpoint, evaluatedLogExpression, suspendContext)) {
            this.setOverlay();
        } else {
            this.resume();
        }
    }

    public final void startPausing() {
        ((VmConnection)this.connection).getVm().getSuspendContextManager().suspend().rejected((Consumer)new RejectErrorReporter(this.getSession(), "Cannot pause"));
    }

    @NotNull
    public final String getCurrentStateMessage() {
        return ((VmConnection)this.connection).getState().getMessage();
    }

    @Nullable
    public final HyperlinkListener getCurrentStateHyperlinkListener() {
        return ((VmConnection)this.connection).getState().getMessageLinkListener();
    }

    @NotNull
    protected ProcessHandler doGetProcessHandler() {
        ExecutionResult executionResult = this.executionResult;
        if (executionResult == null || (executionResult = executionResult.getProcessHandler()) == null) {
            executionResult = (ProcessHandler)new DefaultDebugProcessHandler(){

                public boolean isSilentlyDestroyOnClose() {
                    return true;
                }
            };
        }
        return executionResult;
    }

    public final void saveResolvedFile(@NotNull Url url, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.urlToFileCache.putIfAbsent(url, file);
    }

    @NotNull
    public List<Location> getLocationsForBreakpoint(@NotNull XLineBreakpoint<?> breakpoint) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        throw (Throwable)new UnsupportedOperationException();
    }

    @Deprecated(message="onlySourceMappedBreakpoints is not required anymore", replaceWith=@ReplaceWith(imports={}, expression="getLocationsForBreakpoint(breakpoint)"))
    @NotNull
    public List<Location> getLocationsForBreakpoint(@NotNull XLineBreakpoint<?> breakpoint, boolean onlySourceMappedBreakpoints) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        return this.getLocationsForBreakpoint(breakpoint);
    }

    public boolean isLibraryFrameFilterSupported() {
        return true;
    }

    @NotNull
    public final C getConnection() {
        return this.connection;
    }

    @Nullable
    protected final ExecutionResult getExecutionResult() {
        return this.executionResult;
    }

    static {
        $$delegatedProperties = new PropertyMetadata[]{(PropertyMetadata)DebugProcessImpl$_breakpointHandlers$1.INSTANCE};
    }

    public DebugProcessImpl(@NotNull XDebugSession session, @NotNull C connection, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XSmartStepIntoHandler<?> smartStepIntoHandler, @Nullable ExecutionResult executionResult) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)editorsProvider, (String)"editorsProvider");
        super(session);
        this.connection = connection;
        this.editorsProvider = editorsProvider;
        this.smartStepIntoHandler = smartStepIntoHandler;
        this.executionResult = executionResult;
        this.repeatStepInto = new AtomicBoolean();
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurrentMap<Url, VirtualFile>()");
        this.urlToFileCache = concurrentMap;
        this._breakpointHandlers$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<XBreakpointHandler<?>[]>(this){
            final /* synthetic */ DebugProcessImpl this$0;

            @NotNull
            public final XBreakpointHandler<?>[] invoke() {
                return this.this$0.createBreakpointHandlers();
            }
            {
                this.this$0 = debugProcessImpl;
                super(0);
            }
        }));
        ((VmConnection)this.connection).stateChanged((Function1<ConnectionState, Unit>)((Function1)new Function1<ConnectionState, Unit>(){

            public final void invoke(@NotNull ConnectionState it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                switch (DebugProcessImpl$WhenMappings.$EnumSwitchMapping$0[it.getStatus().ordinal()]) {
                    case 1: 
                    case 2: {
                        if (Intrinsics.areEqual((Object)((Object)it.getStatus()), (Object)((Object)ConnectionStatus.DETACHED)) && this.getRealProcessHandler() != null) {
                            this.getProcessHandler().detachProcess();
                        }
                        this.getSession().stop();
                        break;
                    }
                    case 3: {
                        this.getSession().reportError(it.getMessage());
                        this.getSession().stop();
                        break;
                    }
                    default: {
                        this.getSession().rebuildViews();
                    }
                }
            }
        }));
    }

    public static final /* synthetic */ void access$processBreakpointLogExpressionAndSuspend(DebugProcessImpl<C> $this, @NotNull XBreakpoint<?> breakpoint, @NotNull SuspendContextImpl xSuspendContext, @NotNull SuspendContext<?> suspendContext) {
        super.processBreakpointLogExpressionAndSuspend(breakpoint, xSuspendContext, suspendContext);
    }

    public static final /* synthetic */ void access$breakpointReached(DebugProcessImpl<C> $this, @NotNull XBreakpoint<?> breakpoint, @Nullable String evaluatedLogExpression, @NotNull XSuspendContext suspendContext) {
        super.breakpointReached(breakpoint, evaluatedLogExpression, suspendContext);
    }

    @NotNull
    public static final /* synthetic */ XBreakpointHandler<?>[] access$get_breakpointHandlers$p(DebugProcessImpl<C> $this) {
        return super.get_breakpointHandlers();
    }
}

