/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Consumer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.GenericFutureListener;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.KotlinInterfaceDefaultImpls;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.AttachStateManager;
import org.jetbrains.debugger.ExceptionCatchMode;
import org.jetbrains.debugger.StandaloneVmHelperKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.MessageProcessor;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"?\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003!\u0001Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!-Q!\u0001\u0003\u0003\t-a\u0001!G\u0001\u0019\u0002u\u00051\"i\t\u0005\b%\u0019\u0001\"A\u0007\u00021\u0007I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011\"\u0002\u0003\u0002\u0011\ri!\u0001$\u0001\u0019\bE\u001b\u0011\u0001\u0003\u0003&!\u0011Q\u0001\u0012B\u0007\u00021\u0015I2\u0001C\u0002\u000e\u0003a\u001d\u0011d\u0002E\u0006\u001b\u0015I1!\u0003\u0002\r\u0002a5\u0001DB\u0013\u0007\t-Aq!D\u0002\n\u0003\u0011\r\u0001tB\u0013\u0005\u0011!i!\u0001$\u0001\u0019\b\u0015\"Aa\u0003E\t\u001b\u0005A\u0012\"J\u0004\t\u00145\t\u0001$B\r\u0004\u0011\ri\u0011\u0001g\u0002&\u000f!QQ\"\u0001\r\n3\rA)\"D\u0001\u0019\u000e%RA1\u0011\u000f\t\u00075\u0011A\u0012\u0001M\u00049\u0005\u0001\u0013!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\ti\u0011\u0001'\u0002R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"A\u0011!D\u0001\u0019\u0004E\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/debugger/StandaloneVmHelper;", "Lorg/jetbrains/debugger/AttachStateManager;", "vm", "Lorg/jetbrains/debugger/Vm;", "messageProcessor", "Lorg/jetbrains/rpc/MessageProcessor;", "channel", "Lio/netty/channel/Channel;", "(Lorg/jetbrains/debugger/Vm;Lorg/jetbrains/rpc/MessageProcessor;Lio/netty/channel/Channel;)V", "closeChannel", "", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "detach", "Lorg/jetbrains/concurrency/Promise;", "getChannelIfActive", "isAttached", "", "setChannel", "write", "content", "VmEx"}, moduleName="script-debugger-backend")
public class StandaloneVmHelper
implements AttachStateManager {
    private volatile Channel channel;
    private final Vm vm;
    private final MessageProcessor messageProcessor;

    public final void setChannel(@NotNull Channel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        this.channel = channel;
        ChannelFuture $receiver = channel.closeFuture();
        $receiver.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(this){
            final /* synthetic */ StandaloneVmHelper this$0;

            public void operationComplete(ChannelFuture future2) {
                ChannelFuture it = future2;
                if (StandaloneVmHelper.access$getChannel$p(this.this$0) != null) {
                    StandaloneVmHelper.access$getMessageProcessor$p(this.this$0).closed();
                    StandaloneVmHelper.access$getVm$p(this.this$0).getDebugListener().disconnected();
                }
            }
            {
                this.this$0 = standaloneVmHelper;
            }
        });
    }

    @Nullable
    public final Channel getChannelIfActive() {
        Channel currentChannel = this.channel;
        return currentChannel == null || !currentChannel.isActive() ? (Channel)null : currentChannel;
    }

    public final boolean write(@NotNull Object content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Channel channel = this.getChannelIfActive();
        return channel != null && !channel.writeAndFlush(content).isCancelled();
    }

    @Override
    public boolean isAttached() {
        return this.channel != null;
    }

    @Override
    @NotNull
    public Promise<?> detach() {
        Channel channel = this.channel;
        if (channel == null) {
            return PromiseKt.resolvedPromise();
        }
        Channel currentChannel = channel;
        this.messageProcessor.cancelWaitingRequests();
        Vm vm = this.vm;
        if (!(vm instanceof VmEx)) {
            vm = null;
        }
        VmEx vmEx = (VmEx)vm;
        Request<? extends Object> disconnectRequest = vmEx != null ? vmEx.createDisconnectRequest() : null;
        AsyncPromise promise2 = new AsyncPromise();
        if (disconnectRequest == null) {
            this.messageProcessor.closed();
            this.channel = null;
            this.closeChannel(currentChannel, (AsyncPromise<Object>)promise2);
            return (Promise)promise2;
        }
        this.messageProcessor.closed();
        this.channel = null;
        this.messageProcessor.send(disconnectRequest).processed(new Consumer<T>(this, promise2, currentChannel){
            final /* synthetic */ StandaloneVmHelper this$0;
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ Channel $currentChannel;

            public final void consume(@Nullable Object it) {
                AsyncPromise $receiver = this.$promise;
                try {
                    StandaloneVmHelper.access$getMessageProcessor$p(this.this$0).cancelWaitingRequests();
                    this.this$0.closeChannel(this.$currentChannel, (AsyncPromise<Object>)this.$promise);
                }
                catch (Throwable e) {
                    $receiver.setError(e);
                }
            }
            {
                this.this$0 = standaloneVmHelper;
                this.$promise = asyncPromise;
                this.$currentChannel = channel;
            }
        });
        return (Promise)promise2;
    }

    protected void closeChannel(@NotNull Channel channel, @NotNull AsyncPromise<Object> promise2) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull(promise2, (String)"promise");
        StandaloneVmHelperKt.doCloseChannel(channel, promise2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public StandaloneVmHelper(@NotNull Vm vm, @NotNull MessageProcessor messageProcessor, @Nullable Channel channel) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)messageProcessor, (String)"messageProcessor");
        this.vm = vm;
        this.messageProcessor = messageProcessor;
        this.channel = channel;
        Channel channel2 = channel;
        if (channel2 != null) {
            void $receiver;
            Channel channel3 = channel2;
            Channel it = (Channel)$receiver;
            this.setChannel(channel);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    @JvmOverloads
    public /* synthetic */ StandaloneVmHelper(Vm vm, MessageProcessor messageProcessor, Channel channel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            channel = null;
        }
        this(vm, messageProcessor, channel);
    }

    @JvmOverloads
    public StandaloneVmHelper(@NotNull Vm vm, @NotNull MessageProcessor messageProcessor) {
        this(vm, messageProcessor, null, 4, null);
    }

    @Nullable
    public static final /* synthetic */ Channel access$getChannel$p(StandaloneVmHelper $this) {
        return $this.channel;
    }

    public static final /* synthetic */ void access$setChannel$p(StandaloneVmHelper $this, @Nullable Channel channel) {
        $this.channel = channel;
    }

    @NotNull
    public static final /* synthetic */ MessageProcessor access$getMessageProcessor$p(StandaloneVmHelper $this) {
        return $this.messageProcessor;
    }

    @NotNull
    public static final /* synthetic */ Vm access$getVm$p(StandaloneVmHelper $this) {
        return $this.vm;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0013\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\t\u0001\u0002\u0001\u00034\u0019\u0001I\u0012\u0001'\u0001&\u0013\u0011\u0019\u0002\"A\u0007\u0007\u0013\r!\t!C\u0001\u0019\u00051\u0005\u00014\u0001"}, strings={"Lorg/jetbrains/debugger/StandaloneVmHelper$VmEx;", "Lorg/jetbrains/debugger/Vm;", "createDisconnectRequest", "Lorg/jetbrains/jsonProtocol/Request;", ""}, moduleName="script-debugger-backend")
    public static interface VmEx
    extends Vm {
        @Nullable
        public Request<? extends Object> createDisconnectRequest();

        @KotlinInterfaceDefaultImpls(version={1, 0, 0})
        @KotlinSyntheticClass(version={1, 0, 0}, abiVersion=32, moduleName="script-debugger-backend")
        public static final class DefaultImpls {
            @NotNull
            public static Promise<?> setBreakOnException(@NotNull VmEx $this, ExceptionCatchMode catchMode) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)catchMode), (String)"catchMode");
                return Vm.DefaultImpls.setBreakOnException($this, catchMode);
            }
        }
    }
}

