/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceMap;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"[\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t!\u0015\t\u0001bB\u0003\u0001\u000b\u0005A\t\"B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u0003!!Q!\u0001\u0003\u0003\u0019\u0001\u0001\"#G\u0001\u0019\u0002u\t!SEQ\u0019\u0013\u0019A\u0011!\u0004\u0003\n\u0005%\t\u0001D\u0001M\u0002\u0013\u0019A)!\u0004\u0003\n\u0005%\t\u0001t\u0001\r\u0004\u0013\u001dAA!D\u0003\n\u0005%\t\u0001D\u0001G\u00011\u0007\t6!\u0001E\u0005K1Ay!\u0004\u0002\r\u0002aA\u0011d\u0001E\t\u001b\u0005A\u0012\"G\u0002\t\u00145\t\u0001DC\u0013\u0012\u0011+i!\u0001$\u0001\u0019\u0011e!\u00012C\u0007\u0003\u0019\u0003A\"\"G\u0002\t\u00125\t\u0001$C\r\u0004\u0011-i\u0011\u0001g\u0006&)!UQB\u0001G\u00011!Ib\u0001\u0003\u0007\u000e\t%\u0011\u0011\"\u0001M\u00041\u0007I2\u0001#\u0005\u000e\u0003aI\u0011\u0004\u0002E\n\u001b\ta\t\u0001\u0007\u0006&\u0016!eQ\u0012\u0002G\u00011\t\t6!\u0001\u0003\u000e3\rAY\"D\u0001\u0019\u001d\u0015B\u0001RD\u0007\u0003\u0019\u0003A\"!G\u0002\t\u001c5\t\u0001DD\u0013\t\u0011=i!\u0001$\u0001\u0019\be\u0019\u00012D\u0007\u000219)\u0003\u0002c\b\u000e\u00051\u0005\u0001DA\r\u0004\u0011Ai\u0011\u0001'\t&\u0011!}QB\u0001G\u00011\tI2\u0001c\u0007\u000e\u0003aqQe\u0002\u0005\u0012\u001b\u0005A\n#G\u0002\t$5\t\u0001tA\u0015\u000b\t\u0005C\u0001\"B\u0007\u0005\u0013\tI\u0011\u0001g\u0002\u0019\fE\u001b\u0011!\u0002\u0001*\u001d\u0011\u0001\u0005\u0002#\u0002\u000e\t%\u0011\u0011\"\u0001M\u00041\r\t6!B\u0003\u0002\u0011\u001di!\u0001\u0002\u0004\t\u000e%RA!\u0011\u0005\t\u00035!\u0011BA\u0005\u00021\tA\u001a!U\u0002\u0002\u000b\u0001I3\u0002B!\t\u0011\u0011iQ!\u0003\u0002\n\u0003a\u0011A\u0012\u0001M\u0002#\u000e\tQ\u0001\u0001"}, strings={"Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "", "rawSources", "", "", "canonicalizedUrls", "", "Lcom/intellij/util/Url;", "sourceContents", "(Ljava/util/List;[Lcom/intellij/util/Url;Ljava/util/List;)V", "canonicalizedUrlToSourceIndex", "Lcom/intellij/util/containers/ObjectIntHashMap;", "getCanonicalizedUrls$script_debugger_backend", "()[Lcom/intellij/util/Url;", "[Lcom/intellij/util/Url;", "findByFile", "Lorg/jetbrains/debugger/sourcemap/MappingList;", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findMappings", "resolver", "Lorg/jetbrains/debugger/sourcemap/SourceResolver$Resolver;", "sourceUrls", "getLocalFilePath", "Lorg/jetbrains/annotations/NotNull;", "entry", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "getRawSource", "getSource", "getSourceContent", "sourceIndex", "", "getSourceIndex", "url", "Companion", "Resolver"}, moduleName="script-debugger-backend")
public final class SourceResolver {
    private final ObjectIntHashMap<Url> canonicalizedUrlToSourceIndex;
    private final List<? extends String> rawSources;
    @NotNull
    private final Url[] canonicalizedUrls;
    private final List<? extends String> sourceContents;
    public static final Companion Companion = org.jetbrains.debugger.sourcemap.SourceResolver$Companion.INSTANCE;

    @Nullable
    public final Url getSource(@NotNull MappingEntry entry) {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        int index = entry.getSource();
        return index < 0 ? (Url)null : this.canonicalizedUrls[index];
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final String getSourceContent(@NotNull MappingEntry entry) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        if (UtilKt.isNullOrEmpty(this.sourceContents)) {
            return null;
        }
        int index = entry.getSource();
        if (index >= 0) {
            List<? extends String> list = this.sourceContents;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            if (index < list.size()) {
                string = this.sourceContents.get(index);
                return string;
            }
        }
        string = null;
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final String getSourceContent(int sourceIndex) {
        String string;
        if (UtilKt.isNullOrEmpty(this.sourceContents)) {
            return null;
        }
        if (sourceIndex >= 0) {
            List<? extends String> list = this.sourceContents;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            if (sourceIndex < list.size()) {
                string = this.sourceContents.get(sourceIndex);
                return string;
            }
        }
        string = null;
        return string;
    }

    public final int getSourceIndex(@NotNull Url url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return ArrayUtil.indexOf((Object[])this.canonicalizedUrls, (Object)url);
    }

    @Nullable
    public final String getRawSource(@NotNull MappingEntry entry) {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        int index = entry.getSource();
        return index < 0 ? (String)null : this.rawSources.get(index);
    }

    @Nullable
    public final MappingList findMappings(@Nullable VirtualFile sourceFile, @NotNull SourceMap sourceMap, @NotNull Resolver resolver) {
        Intrinsics.checkParameterIsNotNull((Object)sourceMap, (String)"sourceMap");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        int index = resolver.resolve(sourceFile, this.canonicalizedUrlToSourceIndex);
        return index < 0 ? (MappingList)null : sourceMap.getSourceIndexToMappings$script_debugger_backend()[index];
    }

    @Nullable
    public final MappingList findMappings(@NotNull List<? extends Url> sourceUrls, @NotNull SourceMap sourceMap, @Nullable VirtualFile sourceFile) {
        MappingList mappingList;
        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
        Intrinsics.checkParameterIsNotNull((Object)sourceMap, (String)"sourceMap");
        for (Url url : sourceUrls) {
            int index = this.canonicalizedUrlToSourceIndex.get((Object)url);
            if (index == -1) continue;
            return sourceMap.getSourceIndexToMappings$script_debugger_backend()[index];
        }
        if (sourceFile != null && (mappingList = this.findByFile(sourceMap, sourceFile)) != null) {
            return mappingList;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MappingList findByFile(@NotNull SourceMap sourceMap, @NotNull VirtualFile sourceFile) {
        Intrinsics.checkParameterIsNotNull((Object)sourceMap, (String)"sourceMap");
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        int index = this.canonicalizedUrlToSourceIndex.get((Object)Urls.newFromVirtualFile(sourceFile).trimParameters());
        if (index != -1) {
            return sourceMap.getSourceIndexToMappings$script_debugger_backend()[index];
        }
        if (sourceFile.isInLocalFileSystem() && (index = this.canonicalizedUrlToSourceIndex.get((Object)Urls.newLocalFileUrl(sourceFile))) != -1) {
            return sourceMap.getSourceIndexToMappings$script_debugger_backend()[index];
        }
        VirtualFile canonicalFile = sourceFile.getCanonicalFile();
        if (canonicalFile != null && Intrinsics.areEqual((Object)canonicalFile, (Object)sourceFile) ^ true) {
            int n;
            IntRange intRange = ArraysKt.getIndices((Object[])this.canonicalizedUrls);
            int n2 = ((Number)intRange.getStart()).intValue();
            if (n2 <= (n = ((Number)intRange.getEnd()).intValue())) {
                while (true) {
                    void i;
                    Url url;
                    if (Urls.equalsIgnoreParameters(url = this.canonicalizedUrls[i], canonicalFile)) {
                        return sourceMap.getSourceIndexToMappings$script_debugger_backend()[i];
                    }
                    if (i == n) break;
                    ++i;
                }
            }
        }
        return null;
    }

    @Nullable
    public final String getLocalFilePath(@NotNull MappingEntry entry) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        Url url = (Url)ArraysKt.getOrNull((Object[])this.canonicalizedUrls, (int)entry.getSource());
        if (url != null) {
            Url $receiver = url;
            Url it = $receiver;
            string = it.isInLocalFileSystem() ? it.getPath() : (String)null;
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final Url[] getCanonicalizedUrls$script_debugger_backend() {
        return this.canonicalizedUrls;
    }

    /*
     * WARNING - void declaration
     */
    public SourceResolver(@NotNull List<? extends String> rawSources, @NotNull Url[] canonicalizedUrls, @Nullable List<? extends String> sourceContents) {
        Intrinsics.checkParameterIsNotNull(rawSources, (String)"rawSources");
        Intrinsics.checkParameterIsNotNull((Object)canonicalizedUrls, (String)"canonicalizedUrls");
        this.rawSources = rawSources;
        this.canonicalizedUrls = canonicalizedUrls;
        this.sourceContents = sourceContents;
        this.canonicalizedUrlToSourceIndex = SystemInfo.isFileSystemCaseSensitive ? new ObjectIntHashMap(this.rawSources.size()) : new ObjectIntHashMap(this.rawSources.size(), Urls.getCaseInsensitiveUrlHashingStrategy());
        IntRange intRange = CollectionsKt.getIndices((Collection)this.rawSources);
        int n = ((Number)intRange.getStart()).intValue();
        int n2 = ((Number)intRange.getEnd()).intValue();
        if (n <= n2) {
            while (true) {
                void i;
                this.canonicalizedUrlToSourceIndex.put((Object)this.canonicalizedUrls[i], (int)i);
                if (i == n2) break;
                ++i;
            }
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\t\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tAa\r\u0007\u00013\u0005A\n!\n\t\u0005'!\tQ\"\u0001M\u00023\u0011A!!\u0004\u0002\r\u0002a\u0015\u0011D\u0002\u0005\u0004\u001b\u0011I!!C\u0001\u0019\ta\u001d\u0001"}, strings={"Lorg/jetbrains/debugger/sourcemap/SourceResolver$Resolver;", "", "resolve", "", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "map", "Lcom/intellij/util/containers/ObjectIntHashMap;", "Lcom/intellij/util/Url;"}, moduleName="script-debugger-backend")
    public static interface Resolver {
        public int resolve(@Nullable VirtualFile var1, @NotNull ObjectIntHashMap<Url> var2);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0017\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0011\u001d!19\u0001\u0007\u00013\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&\u000f!\rQ\"\u0001\r\u00033\rA)!D\u0001\u0019\u0007\u0001"}, strings={"Lorg/jetbrains/debugger/sourcemap/SourceResolver$Companion;", "", "()V", "isAbsolute", "", "path", ""}, moduleName="script-debugger-backend")
    public static final class Companion {
        public static final Companion INSTANCE;

        public final boolean isAbsolute(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            return Intrinsics.areEqual((Object)StringsKt.firstOrNull((CharSequence)path), (Object)Character.valueOf('/')) || SystemInfo.isWindows && path.length() > 2 && path.charAt(1) == ':';
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

