/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rpc;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.rpc.RequestCallback;
import org.jetbrains.rpc.ResultReader;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0001!B\u0001\u0005\u0003\u0015\t\u0001\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0005'1\u0001QC\u0001\u0003\u0001\u0011\u0003I\u0012\u0001G\u0001\u001e\u0002\u001b\t+!U\u0002\u0002\u0011\u0007)\u0003\u0004\u0002\n\t\u00055\t\u0001TA\t\u0003\t\u0003A1!\u0007\u0004\t\b5!\u0011BA\u0005\u0002I\rAB!G\u0005\t\n59\u0011BA\u0005\u00029\u0001I!!C\u0001%\u0007a)Q\u0005\u0005E\u0006\u001b\u0011I!!C\u0001%\u0007a1\u0011C\u0001C\u0001\u0011\rIb\u0001c\u0002\u000e\t%\u0011\u0011\"\u0001\u0013\u00041\u0011\u0001"}, strings={"Lorg/jetbrains/rpc/CommandSenderBase;", "SUCCESS_RESPONSE", "", "()V", "doSend", "", "RESULT", "message", "Lorg/jetbrains/jsonProtocol/Request;", "callback", "Lorg/jetbrains/rpc/CommandSenderBase$RequestPromise;", "send", "Lorg/jetbrains/concurrency/Promise;", "RequestPromise"}, moduleName="script-debugger-backend")
public abstract class CommandSenderBase<SUCCESS_RESPONSE> {
    protected abstract <RESULT> void doSend(@NotNull Request<RESULT> var1, @NotNull RequestPromise<SUCCESS_RESPONSE, RESULT> var2);

    @NotNull
    public final <RESULT> Promise<RESULT> send(@NotNull Request<RESULT> message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        RequestPromise callback = new RequestPromise(message.getMethodName());
        this.doSend(message, callback);
        return (Promise)callback;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u001d)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0011\u0007)\u0011\u0001b\u0001\u0006\u00031\tQ\u0001\u0001\u0007\u0001+\t!\t\u0001#\u0001\u0016\u0005\u0011\t\u0001\"A\r\u0005\u0013\tI\u0011\u0001J\u0001\u0019\u0004e!\u0011BA\u0005\u0002I\u0003A\"!i\u0004\n\t!\u0015QB\u0001G\u00011\r\t6!\u0001E\u0004K!!1\u0002\u0003\u0003\u000e\u0003a%\u0011d\u0001\u0005\u0006\u001b\u0005AZ!j\n\u0005\u0017!1Q\"\u0001M\u00053\u0011Ai!\u0004\u0002\r\u0002q\u0005\u0011d\u0002\u0005\b\u001b\u0015I!!C\u0001\u001d\u00021\u0005\u0001tB)\u0004\u0003!A\u0011\u0006\u0003\u0003B\u0011!\u0015QB\u0001G\u00011\r\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/rpc/CommandSenderBase$RequestPromise;", "SUCCESS_RESPONSE", "RESULT", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lorg/jetbrains/rpc/RequestCallback;", "methodName", "", "(Ljava/lang/String;)V", "onError", "", "error", "", "onSuccess", "response", "resultReader", "Lorg/jetbrains/rpc/ResultReader;", "(Ljava/lang/Object;Lorg/jetbrains/rpc/ResultReader;)V"}, moduleName="script-debugger-backend")
    public static final class RequestPromise<SUCCESS_RESPONSE, RESULT>
    extends AsyncPromise<RESULT>
    implements RequestCallback<SUCCESS_RESPONSE> {
        private final String methodName;

        @Override
        public void onSuccess(@Nullable SUCCESS_RESPONSE response, @Nullable ResultReader<SUCCESS_RESPONSE> resultReader) {
            try {
                if (resultReader == null || response == null) {
                    this.setResult(response);
                } else if (this.methodName == null) {
                    this.setResult(null);
                } else {
                    this.setResult(resultReader.readResult(this.methodName, response));
                }
            }
            catch (Throwable e) {
                CommandProcessorKt.getLOG().error(e);
                this.setError(e);
            }
        }

        @Override
        public void onError(@NotNull Throwable error) {
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            this.setError(error);
        }

        public RequestPromise(@Nullable String methodName) {
            this.methodName = methodName;
        }

        @Override
        public void onError(@NotNull String error) {
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            RequestCallback.DefaultImpls.onError(this, error);
        }
    }
}

