/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.HashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.storage.StorageOwner;

public class AndroidProGuardStateStorage
implements StorageOwner {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.android.AndroidProGuardStateStorage");
    private final File myFile;

    public AndroidProGuardStateStorage(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/android/AndroidProGuardStateStorage", "<init>"));
        }
        this.myFile = file;
    }

    public void flush(boolean memoryCachesOnly) {
    }

    public void clean() throws IOException {
        FileUtil.delete((File)this.myFile);
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public MyState read() {
        try {
            DataInputStream input222 = new DataInputStream(new FileInputStream(this.myFile));
            try {
                boolean hasValue = input222.readBoolean();
                if (!hasValue) {
                    MyState myState = null;
                    return myState;
                }
                int n = input222.readInt();
                HashMap cfgFiles = new HashMap();
                for (int i = 0; i < n; ++i) {
                    String path = input222.readUTF();
                    long timestamp = input222.readLong();
                    cfgFiles.put(path, timestamp);
                }
                MyState myState = new MyState((Map)cfgFiles);
                return myState;
            }
            finally {
                input222.close();
            }
        }
        catch (FileNotFoundException input222) {
            return null;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(@Nullable MyState state) {
        FileUtil.createParentDirs((File)this.myFile);
        try {
            DataOutputStream output = new DataOutputStream(new FileOutputStream(this.myFile));
            try {
                output.writeBoolean(state != null);
                if (state != null) {
                    output.writeInt(state.myProGuardConfigFiles.size());
                    for (Map.Entry entry : state.myProGuardConfigFiles.entrySet()) {
                        String path = (String)entry.getKey();
                        Long timestamp = (Long)entry.getValue();
                        output.writeUTF(path);
                        output.writeLong(timestamp);
                    }
                }
            }
            finally {
                output.close();
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    public static class MyState {
        private final Map<String, Long> myProGuardConfigFiles;

        public MyState(@NotNull File[] proGuardCfgFiles) {
            if (proGuardCfgFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proGuardCfgFiles", "org/jetbrains/jps/android/AndroidProGuardStateStorage$MyState", "<init>"));
            }
            this.myProGuardConfigFiles = new HashMap();
            for (File file : proGuardCfgFiles) {
                this.myProGuardConfigFiles.put(file.getPath(), file.lastModified());
            }
        }

        private MyState(@NotNull Map<String, Long> proGuardConfigFiles) {
            if (proGuardConfigFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proGuardConfigFiles", "org/jetbrains/jps/android/AndroidProGuardStateStorage$MyState", "<init>"));
            }
            this.myProGuardConfigFiles = proGuardConfigFiles;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyState state = (MyState)o;
            return this.myProGuardConfigFiles.equals(state.myProGuardConfigFiles);
        }

        public int hashCode() {
            return this.myProGuardConfigFiles.hashCode();
        }
    }
}

