/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9;

import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.InstructionDetails;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trace.InstructionInfo;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.intellij.plugins.xsltDebugger.rt.engine.Value;
import org.intellij.plugins.xsltDebugger.rt.engine.local.LocalDebugger;
import org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9.AbstractSaxon9Frame;
import org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9.Saxon9SourceFrame;
import org.intellij.plugins.xsltDebugger.rt.engine.local.saxon9.Saxon9StyleFrame;

public class Saxon9TraceListener
implements TraceListener {
    private static final boolean TRACE = "true".equals(System.getProperty("xslt.debugger.trace", "false"));
    private LocalDebugger myDebugger;
    static boolean MUTED;

    public void setDebugger(LocalDebugger debugger) {
        this.myDebugger = debugger;
    }

    private static void trace(String s) {
        if (TRACE) {
            System.err.println(s);
        }
    }

    public void open() {
        this.myDebugger.getEventQueue().startDocument();
        if (TRACE) {
            Saxon9TraceListener.trace("<trace>");
        }
    }

    public void close() {
        this.myDebugger.getEventQueue().endDocument();
        if (TRACE) {
            Saxon9TraceListener.trace("</trace>");
        }
    }

    public void enter(InstructionInfo instructionInfo, XPathContext xPathContext) {
        if (MUTED) {
            return;
        }
        if (TRACE) {
            Saxon9TraceListener.trace("<" + instructionInfo + ">");
        }
        if (instructionInfo instanceof StyleElement) {
            this.myDebugger.enter(new Saxon9StyleFrame<StyleElement>(this.myDebugger.getCurrentFrame(), (StyleElement)instructionInfo, xPathContext));
        } else if (instructionInfo instanceof InstructionDetails) {
            this.myDebugger.enter(new VirtualFrame(this.myDebugger.getCurrentFrame(), (InstructionDetails)instructionInfo));
        }
    }

    public void leave(InstructionInfo instructionInfo) {
        if (MUTED) {
            return;
        }
        if (TRACE) {
            Saxon9TraceListener.trace("</>");
        }
        if (instructionInfo instanceof StyleElement || instructionInfo instanceof InstructionDetails) {
            this.myDebugger.leave();
        }
    }

    public void startCurrentItem(Item item) {
        if (MUTED) {
            return;
        }
        if (item instanceof NodeInfo) {
            if (TRACE) {
                Saxon9TraceListener.trace("<" + ((NodeInfo)item).getDisplayName() + ">");
            }
            this.myDebugger.pushSource(new Saxon9SourceFrame<NodeInfo>(this.myDebugger.getSourceFrame(), (NodeInfo)item));
        }
    }

    public void endCurrentItem(Item item) {
        if (MUTED) {
            return;
        }
        if (item instanceof NodeInfo) {
            this.myDebugger.popSource();
        }
    }

    private static class VirtualFrame
    extends AbstractSaxon9Frame<Debugger.StyleFrame, Source>
    implements Debugger.StyleFrame {
        public VirtualFrame(Debugger.StyleFrame previous, InstructionDetails instr) {
            super(previous, new MySource(instr));
        }

        public String getInstruction() {
            return ((Debugger.StyleFrame)this.getPrevious()).getInstruction();
        }

        public Value eval(String expr) throws Debugger.EvaluationException {
            return ((Debugger.StyleFrame)this.getPrevious()).eval(expr);
        }

        public List<Debugger.Variable> getVariables() {
            return ((Debugger.StyleFrame)this.getPrevious()).getVariables();
        }

        private static class MySource
        implements Source,
        SourceLocator {
            private final InstructionDetails myInstruction;

            public MySource(InstructionDetails instr) {
                this.myInstruction = instr;
            }

            @Override
            public void setSystemId(String systemId) {
            }

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public String getSystemId() {
                return this.myInstruction.getSystemId();
            }

            @Override
            public int getLineNumber() {
                return this.myInstruction.getLineNumber();
            }

            @Override
            public int getColumnNumber() {
                return this.myInstruction.getColumnNumber();
            }
        }
    }
}

