/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class IncludeDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("IncludeLayoutParam", "Ignored layout params on include", "Layout parameters specified on an `<include>` tag will only be used if you also override `layout_width` and `layout_height` on the `<include>` tag; otherwise they will be ignored.", Category.CORRECTNESS, 5, Severity.ERROR, new Implementation(IncludeDetector.class, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("http://stackoverflow.com/questions/2631614/does-android-xml-layouts-include-tag-really-work");

    @Override
    @Nullable
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("include");
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        boolean flagHeight;
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        boolean hasWidth = false;
        boolean hasHeight = false;
        boolean hasOtherLayoutParam = false;
        for (int i = 0; i < length; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String name = attribute.getLocalName();
            if (name == null || !name.startsWith("layout_")) continue;
            if ("layout_width".equals(name)) {
                hasWidth = true;
                continue;
            }
            if ("layout_height".equals(name)) {
                hasHeight = true;
                continue;
            }
            if (!"http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) continue;
            hasOtherLayoutParam = true;
        }
        boolean flagWidth = !hasOtherLayoutParam && hasWidth && !hasHeight;
        boolean bl = flagHeight = !hasOtherLayoutParam && !hasWidth && hasHeight;
        if (hasOtherLayoutParam && (!hasWidth || !hasHeight) || flagWidth || flagHeight) {
            for (int i = 0; i < length; ++i) {
                Attr attribute = (Attr)attributes.item(i);
                String name = attribute.getLocalName();
                if (name == null || !name.startsWith("layout_") || "layout_width".equals(name) && !flagWidth || "layout_height".equals(name) && !flagHeight || !"http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) continue;
                String condition = !hasWidth && !hasHeight ? "both `layout_width` and `layout_height` are also specified" : (!hasWidth ? "`layout_width` is also specified" : "`layout_height` is also specified");
                String message = String.format("Layout parameter `%1$s` ignored unless %2$s on `<include>` tag", name, condition);
                context.report(ISSUE, element, context.getLocation(attribute), message);
            }
        }
    }

    public static boolean requestsWidth(@NonNull String errorMessage) {
        int index = errorMessage.indexOf(" unless ");
        if (index != -1) {
            return errorMessage.contains("layout_width");
        }
        return false;
    }

    public static boolean requestsHeight(@NonNull String errorMessage) {
        int index = errorMessage.indexOf(" unless ");
        if (index != -1) {
            return errorMessage.contains("layout_height");
        }
        return false;
    }
}

