/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.application;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.application.CvsStorageSupportingDeletionComponent;
import com.intellij.cvsSupport2.application.DeletedCVSDirectoryStorage;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConsumer;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class CvsFileOperationsHandler
implements LocalFileOperationsHandler {
    private final Project myProject;
    private final CvsStorageSupportingDeletionComponent myComponent;
    private boolean myInternalDelete = false;

    public CvsFileOperationsHandler(Project project, CvsStorageSupportingDeletionComponent component) {
        this.myProject = project;
        this.myComponent = component;
    }

    public boolean delete(VirtualFile file) throws IOException {
        return this.processDeletedFile(file);
    }

    private boolean processDeletedFile(VirtualFile file) throws IOException {
        if (this.myInternalDelete) {
            return false;
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(file);
        if (vcs != CvsVcs2.getInstance(this.myProject)) {
            return false;
        }
        file.putUserData(CvsStorageSupportingDeletionComponent.FILE_VCS, (Object)vcs);
        if (!CvsUtil.fileIsUnderCvs(file)) {
            return false;
        }
        this.myComponent.getDeleteHandler().addDeletedRoot(file);
        if (file.isDirectory()) {
            this.myInternalDelete = true;
            try {
                this.deleteFilesInVFS(file);
            }
            finally {
                this.myInternalDelete = false;
            }
            return true;
        }
        return false;
    }

    private void deleteFilesInVFS(VirtualFile file) throws IOException {
        for (VirtualFile child : file.getChildren()) {
            if (child.isDirectory()) {
                if (DeletedCVSDirectoryStorage.isAdminDir(child)) continue;
                this.deleteFilesInVFS(child);
                continue;
            }
            child.delete((Object)this);
        }
    }

    public boolean move(VirtualFile file, VirtualFile toDir) throws IOException {
        return this.doMoveRename(file, toDir, file.getName());
    }

    @Nullable
    public File copy(VirtualFile file, VirtualFile toDir, String copyName) throws IOException {
        return null;
    }

    public boolean rename(VirtualFile file, String newName) throws IOException {
        return this.doMoveRename(file, file.getParent(), newName);
    }

    private boolean doMoveRename(VirtualFile file, VirtualFile newParent, String newName) throws IOException {
        if (!CvsUtil.fileIsUnderCvs(file)) {
            return false;
        }
        if (newParent == null) {
            return false;
        }
        File newFile = new File(newParent.getPath(), newName);
        this.myComponent.getDeleteHandler().addDeletedRoot(file);
        if (!file.isDirectory()) {
            this.myComponent.getAddHandler().addFile(newFile);
            return false;
        }
        newFile.mkdir();
        CvsFileOperationsHandler.copyDirectoryStructure(file, newFile);
        this.myComponent.getAddHandler().addFile(newFile);
        DocumentReference ref = DocumentReferenceManager.getInstance().create(file);
        UndoManager.getInstance((Project)this.myProject).nonundoableActionPerformed(ref, false);
        return true;
    }

    private static void copyDirectoryStructure(VirtualFile file, File newFile) throws IOException {
        for (VirtualFile child : file.getChildren()) {
            File newChild = new File(newFile, child.getName());
            if (child.isDirectory()) {
                if (DeletedCVSDirectoryStorage.isAdminDir(child)) continue;
                newChild.mkdir();
                CvsFileOperationsHandler.copyDirectoryStructure(child, newChild);
                continue;
            }
            new File(child.getPath()).renameTo(newChild);
        }
    }

    public boolean createFile(VirtualFile dir, String name) throws IOException {
        return false;
    }

    public boolean createDirectory(VirtualFile dir, String name) throws IOException {
        return false;
    }

    public void afterDone(ThrowableConsumer<LocalFileOperationsHandler, IOException> invoker) {
    }
}

