/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvshandlers;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.actions.update.UpdateSettings;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.FileSetToBeUpdated;
import com.intellij.cvsSupport2.cvshandlers.IOFilesBasedDirectoryPruner;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperation;
import com.intellij.cvsSupport2.cvsoperations.common.PostCvsActivity;
import com.intellij.cvsSupport2.cvsoperations.cvsUpdate.MergedWithConflictProjectOrModuleFile;
import com.intellij.cvsSupport2.cvsoperations.cvsUpdate.UpdateOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsUpdate.ui.CorruptedProjectFilesDialog;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class UpdateHandler
extends CommandCvsHandler
implements PostCvsActivity {
    private final FilePath[] myFiles;
    private final Project myProject;
    private final Collection<MergedWithConflictProjectOrModuleFile> myCorruptedFiles;
    private final UpdatedFiles myUpdatedFiles;
    private final UpdateSettings myUpdateSettings;

    public UpdateHandler(FilePath[] files, UpdateSettings updateSettings, @NotNull Project project, @NotNull UpdatedFiles updatedFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/cvsSupport2/cvshandlers/UpdateHandler", "<init>"));
        }
        if (updatedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatedFiles", "com/intellij/cvsSupport2/cvshandlers/UpdateHandler", "<init>"));
        }
        super(CvsBundle.message((String)"operation.name.update", (Object[])new Object[0]), (CvsOperation)new UpdateOperation(files, updateSettings, project), FileSetToBeUpdated.selectedFiles(files));
        this.myCorruptedFiles = new ArrayList<MergedWithConflictProjectOrModuleFile>();
        this.myFiles = files;
        this.myProject = project;
        this.myUpdatedFiles = updatedFiles;
        this.myUpdateSettings = updateSettings;
    }

    @Override
    public void registerCorruptedProjectOrModuleFile(MergedWithConflictProjectOrModuleFile mergedWithConflictProjectOrModuleFile) {
        this.myCorruptedFiles.add(mergedWithConflictProjectOrModuleFile);
    }

    @Override
    protected void onOperationFinished(ModalityContext modalityContext) {
        if (this.myUpdateSettings.getPruneEmptyDirectories()) {
            IOFilesBasedDirectoryPruner pruner = new IOFilesBasedDirectoryPruner(ProgressManager.getInstance().getProgressIndicator());
            for (FilePath file : this.myFiles) {
                pruner.addFile(file.getIOFile());
            }
            pruner.execute();
        }
        if (!this.myCorruptedFiles.isEmpty()) {
            int showOptions = CvsConfiguration.getInstance((Project)this.myProject).SHOW_CORRUPTED_PROJECT_FILES;
            if (showOptions == 1) {
                for (MergedWithConflictProjectOrModuleFile myCorruptedFile : this.myCorruptedFiles) {
                    myCorruptedFile.setShouldBeCheckedOut();
                }
            } else if (showOptions == 0) {
                modalityContext.runInDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        new CorruptedProjectFilesDialog(UpdateHandler.this.myProject, UpdateHandler.this.myCorruptedFiles).show();
                    }
                }, this.myProject);
            }
            VcsKey vcsKey = CvsVcs2.getKey();
            for (MergedWithConflictProjectOrModuleFile myCorruptedFile : this.myCorruptedFiles) {
                if (myCorruptedFile.shouldBeCheckedOut()) {
                    this.addFileToCheckout(myCorruptedFile.getOriginal());
                    continue;
                }
                this.myUpdatedFiles.getGroupById("MODIFIED").add(myCorruptedFile.getOriginal().getPath(), vcsKey, null);
            }
        }
    }

    @Override
    protected PostCvsActivity getPostActivityHandler() {
        return this;
    }
}

