/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.AbstractAppPlugin;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.ScannerParamFilter;
import org.parosproxy.paros.core.scanner.Util;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.core.scanner.VariantCookie;
import org.parosproxy.paros.core.scanner.VariantCustom;
import org.parosproxy.paros.core.scanner.VariantDirectWebRemotingQuery;
import org.parosproxy.paros.core.scanner.VariantFormQuery;
import org.parosproxy.paros.core.scanner.VariantGWTQuery;
import org.parosproxy.paros.core.scanner.VariantHeader;
import org.parosproxy.paros.core.scanner.VariantJSONQuery;
import org.parosproxy.paros.core.scanner.VariantMultipartFormQuery;
import org.parosproxy.paros.core.scanner.VariantODataFilterQuery;
import org.parosproxy.paros.core.scanner.VariantODataIdQuery;
import org.parosproxy.paros.core.scanner.VariantURLPath;
import org.parosproxy.paros.core.scanner.VariantURLQuery;
import org.parosproxy.paros.core.scanner.VariantUserDefined;
import org.parosproxy.paros.core.scanner.VariantXMLQuery;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptWrapper;

public abstract class AbstractAppParamPlugin
extends AbstractAppPlugin {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final ArrayList<Variant> listVariant = new ArrayList();
    private NameValuePair originalPair = null;
    private Variant variant = null;
    private ExtensionScript extension;

    @Override
    public void scan() {
        int n = this.getParent().getScannerParam().getTargetParamsInjectable();
        int n2 = this.getParent().getScannerParam().getTargetParamsEnabledRPC();
        if ((n & 1) != 0) {
            this.listVariant.add(new VariantURLQuery());
            if ((n2 & 0x10) != 0) {
                this.listVariant.add(new VariantODataIdQuery());
                this.listVariant.add(new VariantODataFilterQuery());
            }
        }
        if ((n & 2) != 0) {
            this.listVariant.add(new VariantFormQuery());
            if ((n2 & 1) != 0) {
                this.listVariant.add(new VariantMultipartFormQuery());
            }
            if ((n2 & 2) != 0) {
                this.listVariant.add(new VariantXMLQuery());
            }
            if ((n2 & 4) != 0) {
                this.listVariant.add(new VariantJSONQuery());
            }
            if ((n2 & 8) != 0) {
                this.listVariant.add(new VariantGWTQuery());
            }
            if ((n2 & 0x20) != 0) {
                this.listVariant.add(new VariantDirectWebRemotingQuery());
            }
        }
        if ((n & 8) != 0) {
            this.listVariant.add(new VariantHeader());
        }
        if ((n & 0x10) != 0) {
            this.listVariant.add(new VariantURLPath());
        }
        if ((n & 4) != 0) {
            this.listVariant.add(new VariantCookie());
        }
        if ((n2 & 0x80) != 0 && this.getExtension() != null) {
            List<ScriptWrapper> list = this.getExtension().getScripts("variant");
            for (ScriptWrapper scriptWrapper : list) {
                if (!scriptWrapper.isEnabled()) continue;
                this.listVariant.add(new VariantCustom(scriptWrapper, this.getExtension()));
            }
        }
        if ((n2 & 0x100) != 0) {
            this.listVariant.add(new VariantUserDefined());
        }
        for (int i = 0; i < this.listVariant.size() && !this.isStop(); ++i) {
            HttpMessage httpMessage = this.getNewMsg();
            this.variant = this.listVariant.get(i);
            try {
                this.variant.setMessage(httpMessage);
                this.scanVariant();
            }
            catch (Exception exception) {
                this.logger.error((Object)("Error occurred while scanning with variant " + this.variant.getClass().getCanonicalName()), (Throwable)exception);
            }
            while (this.getParent().isPaused() && !this.isStop()) {
                Util.sleep(500);
            }
        }
    }

    private void scanVariant() {
        for (int i = 0; i < this.variant.getParamList().size() && !this.isStop(); ++i) {
            this.originalPair = this.variant.getParamList().get(i);
            if (this.isToExclude(this.originalPair)) continue;
            HttpMessage httpMessage = this.getNewMsg();
            try {
                this.scan(httpMessage, this.originalPair);
                continue;
            }
            catch (Exception exception) {
                this.logger.error((Object)"Error occurred while scanning a message:", (Throwable)exception);
            }
        }
    }

    private boolean isToExclude(NameValuePair nameValuePair) {
        List<ScannerParamFilter> list = this.getParameterExclusionFilters(nameValuePair);
        HttpMessage httpMessage = this.getBaseMsg();
        for (ScannerParamFilter scannerParamFilter : list) {
            if (!scannerParamFilter.isToExclude(httpMessage, nameValuePair)) continue;
            return true;
        }
        return false;
    }

    private List<ScannerParamFilter> getParameterExclusionFilters(NameValuePair nameValuePair) {
        List<ScannerParamFilter> list = this.getParent().getScannerParam().getExcludedParamList(-1);
        List<ScannerParamFilter> list2 = this.getParent().getScannerParam().getExcludedParamList(nameValuePair.getType());
        if (list == null) {
            if (list2 != null) {
                return list2;
            }
            return Collections.emptyList();
        }
        if (list2 == null) {
            return list;
        }
        ArrayList<ScannerParamFilter> arrayList = new ArrayList<ScannerParamFilter>(list.size() + list2.size());
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    public abstract void scan(HttpMessage var1, String var2, String var3);

    public void scan(HttpMessage httpMessage, NameValuePair nameValuePair) {
        this.scan(httpMessage, nameValuePair.getName(), nameValuePair.getValue());
    }

    protected String setParameter(HttpMessage httpMessage, String string, String string2) {
        return this.variant.setParameter(httpMessage, this.originalPair, string, string2);
    }

    protected String setEscapedParameter(HttpMessage httpMessage, String string, String string2) {
        return this.variant.setEscapedParameter(httpMessage, this.originalPair, string, string2);
    }

    private ExtensionScript getExtension() {
        if (this.extension == null) {
            this.extension = (ExtensionScript)Control.getSingleton().getExtensionLoader().getExtension("ExtensionScript");
        }
        return this.extension;
    }
}

