/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import com.github.zafarkhaja.semver.ParseException;
import com.github.zafarkhaja.semver.Version;
import org.apache.commons.lang.Validate;

public final class Version
implements Comparable<Version> {
    private final com.github.zafarkhaja.semver.Version impl;

    public Version(String string) throws IllegalArgumentException {
        Validate.notEmpty(string, "Parameter version must not be null nor empty.");
        try {
            this.impl = new Version.Builder(string).build();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Parameter version is not valid.");
        }
    }

    public int getMajorVersion() {
        return this.impl.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.impl.getMinorVersion();
    }

    public int getPatchVersion() {
        return this.impl.getPatchVersion();
    }

    public boolean matches(String string) throws IllegalArgumentException {
        Validate.notEmpty(string, "Parameter versionRange must not be null nor empty.");
        try {
            return this.impl.satisfies(string);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Parameter versionRange is not valid.");
        }
    }

    public int hashCode() {
        return 31 + (this.impl == null ? 0 : this.impl.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Version version = (Version)object;
        return !(this.impl == null ? version.impl != null : !this.impl.equals((Object)version.impl));
    }

    @Override
    public int compareTo(Version version) {
        if (version == null) {
            return 1;
        }
        return this.impl.compareTo(version.impl);
    }

    public String toString() {
        return this.impl.toString();
    }
}

